/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.user.json.parser;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.DistributionListEntryObject;
import com.openexchange.groupware.container.LinkEntryObject;
import com.openexchange.java.StringAllocator;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.user.json.field.DistributionListField;
import com.openexchange.user.json.field.UserField;
import com.openexchange.user.json.parser.ParsedUser;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class UserParser {
    private static final Pattern identifierPattern = Pattern.compile("(\\p{Lower}{2})(?:_(\\p{Upper}{2}))?(?:_([a-zA-Z]{2}))?");
    private static final JSONAttributeMapper[] mapping = new JSONAttributeMapper[]{new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("last_name");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setSurName(UserParser.parseString(jsonobject, "last_name"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("title");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setTitle(UserParser.parseString(jsonobject, "title"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("first_name");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setGivenName(UserParser.parseString(jsonobject, "first_name"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("marital_status");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setMaritalStatus(UserParser.parseString(jsonobject, "marital_status"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("anniversary");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setAnniversary(UserParser.parseDate(jsonobject, "anniversary"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("assistant_name");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setAssistantName(UserParser.parseString(jsonobject, "assistant_name"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("birthday");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setBirthday(UserParser.parseDate(jsonobject, "birthday"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("branches");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setBranches(UserParser.parseString(jsonobject, "branches"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("busines_categorie");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setBusinessCategory(UserParser.parseString(jsonobject, "busines_categorie"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("cellular_telephone1");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setCellularTelephone1(UserParser.parseString(jsonobject, "cellular_telephone1"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("cellular_telephone2");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setCellularTelephone2(UserParser.parseString(jsonobject, "cellular_telephone2"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("city_home");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setCityHome(UserParser.parseString(jsonobject, "city_home"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("city_business");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setCityBusiness(UserParser.parseString(jsonobject, "city_business"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("city_other");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setCityOther(UserParser.parseString(jsonobject, "city_other"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("commercial_register");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setCommercialRegister(UserParser.parseString(jsonobject, "commercial_register"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("company");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setCompany(UserParser.parseString(jsonobject, "company"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("country_home");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setCountryHome(UserParser.parseString(jsonobject, "country_home"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("country_business");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setCountryBusiness(UserParser.parseString(jsonobject, "country_business"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("country_other");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setCountryOther(UserParser.parseString(jsonobject, "country_other"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("default_address");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setDefaultAddress(UserParser.parseInt(jsonobject, "default_address"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("department");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setDepartment(UserParser.parseString(jsonobject, "department"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("display_name");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setDisplayName(UserParser.parseString(jsonobject, "display_name"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("mark_as_distributionlist");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setMarkAsDistributionlist(UserParser.parseBoolean(jsonobject, "mark_as_distributionlist"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("email1");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setEmail1(UserParser.parseString(jsonobject, "email1"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("email2");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setEmail2(UserParser.parseString(jsonobject, "email2"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("email3");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setEmail3(UserParser.parseString(jsonobject, "email3"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("employee_type");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setEmployeeType(UserParser.parseString(jsonobject, "employee_type"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("fax_business");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setFaxBusiness(UserParser.parseString(jsonobject, "fax_business"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("fax_home");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setFaxHome(UserParser.parseString(jsonobject, "fax_home"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("fax_other");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setFaxOther(UserParser.parseString(jsonobject, "fax_other"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("image1");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            String image = UserParser.parseString(jsonobject, "image1");
            if (image != null) {
                contactobject.setImage1(image.getBytes());
            } else {
                contactobject.setImage1(null);
            }
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("note");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setNote(UserParser.parseString(jsonobject, "note"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("info");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setInfo(UserParser.parseString(jsonobject, "info"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("instant_messenger1");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setInstantMessenger1(UserParser.parseString(jsonobject, "instant_messenger1"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("instant_messenger2");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setInstantMessenger2(UserParser.parseString(jsonobject, "instant_messenger2"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("manager_name");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setManagerName(UserParser.parseString(jsonobject, "manager_name"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("second_name");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setMiddleName(UserParser.parseString(jsonobject, "second_name"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("nickname");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setNickname(UserParser.parseString(jsonobject, "nickname"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("number_of_children");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setNumberOfChildren(UserParser.parseString(jsonobject, "number_of_children"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("number_of_employees");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setNumberOfEmployee(UserParser.parseString(jsonobject, "number_of_employees"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("position");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setPosition(UserParser.parseString(jsonobject, "position"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("postal_code_home");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setPostalCodeHome(UserParser.parseString(jsonobject, "postal_code_home"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("postal_code_business");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setPostalCodeBusiness(UserParser.parseString(jsonobject, "postal_code_business"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("postal_code_other");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setPostalCodeOther(UserParser.parseString(jsonobject, "postal_code_other"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("profession");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setProfession(UserParser.parseString(jsonobject, "profession"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("room_number");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setRoomNumber(UserParser.parseString(jsonobject, "room_number"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("sales_volume");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setSalesVolume(UserParser.parseString(jsonobject, "sales_volume"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("spouse_name");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setSpouseName(UserParser.parseString(jsonobject, "spouse_name"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("state_home");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setStateHome(UserParser.parseString(jsonobject, "state_home"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("state_business");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setStateBusiness(UserParser.parseString(jsonobject, "state_business"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("state_other");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setStateOther(UserParser.parseString(jsonobject, "state_other"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("street_home");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setStreetHome(UserParser.parseString(jsonobject, "street_home"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("street_business");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setStreetBusiness(UserParser.parseString(jsonobject, "street_business"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("street_other");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setStreetOther(UserParser.parseString(jsonobject, "street_other"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("suffix");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setSuffix(UserParser.parseString(jsonobject, "suffix"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("tax_id");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setTaxID(UserParser.parseString(jsonobject, "tax_id"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("telephone_assistant");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setTelephoneAssistant(UserParser.parseString(jsonobject, "telephone_assistant"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("telephone_business1");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setTelephoneBusiness1(UserParser.parseString(jsonobject, "telephone_business1"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("telephone_business2");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setTelephoneBusiness2(UserParser.parseString(jsonobject, "telephone_business2"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("telephone_callback");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setTelephoneCallback(UserParser.parseString(jsonobject, "telephone_callback"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("telephone_car");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setTelephoneCar(UserParser.parseString(jsonobject, "telephone_car"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("telephone_company");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setTelephoneCompany(UserParser.parseString(jsonobject, "telephone_company"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("telephone_home1");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setTelephoneHome1(UserParser.parseString(jsonobject, "telephone_home1"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("telephone_home2");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setTelephoneHome2(UserParser.parseString(jsonobject, "telephone_home2"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("telephone_ip");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setTelephoneIP(UserParser.parseString(jsonobject, "telephone_ip"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("telephone_isdn");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setTelephoneISDN(UserParser.parseString(jsonobject, "telephone_isdn"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("telephone_other");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setTelephoneOther(UserParser.parseString(jsonobject, "telephone_other"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("telephone_pager");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setTelephonePager(UserParser.parseString(jsonobject, "telephone_pager"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("telephone_primary");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setTelephonePrimary(UserParser.parseString(jsonobject, "telephone_primary"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("telephone_radio");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setTelephoneRadio(UserParser.parseString(jsonobject, "telephone_radio"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("telephone_telex");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setTelephoneTelex(UserParser.parseString(jsonobject, "telephone_telex"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("telephone_ttytdd");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setTelephoneTTYTTD(UserParser.parseString(jsonobject, "telephone_ttytdd"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("url");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setURL(UserParser.parseString(jsonobject, "url"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("useCount");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setUseCount(UserParser.parseInt(jsonobject, "useCount"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("userfield01");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setUserField01(UserParser.parseString(jsonobject, "userfield01"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("userfield02");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setUserField02(UserParser.parseString(jsonobject, "userfield02"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("userfield03");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setUserField03(UserParser.parseString(jsonobject, "userfield03"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("userfield04");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setUserField04(UserParser.parseString(jsonobject, "userfield04"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("userfield05");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setUserField05(UserParser.parseString(jsonobject, "userfield05"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("userfield06");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setUserField06(UserParser.parseString(jsonobject, "userfield06"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("userfield07");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setUserField07(UserParser.parseString(jsonobject, "userfield07"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("userfield08");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setUserField08(UserParser.parseString(jsonobject, "userfield08"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("userfield09");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setUserField09(UserParser.parseString(jsonobject, "userfield09"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("userfield10");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setUserField10(UserParser.parseString(jsonobject, "userfield10"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("userfield11");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setUserField11(UserParser.parseString(jsonobject, "userfield11"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("userfield12");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setUserField12(UserParser.parseString(jsonobject, "userfield12"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("userfield13");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setUserField13(UserParser.parseString(jsonobject, "userfield13"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("userfield14");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setUserField14(UserParser.parseString(jsonobject, "userfield14"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("userfield15");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setUserField15(UserParser.parseString(jsonobject, "userfield15"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("userfield16");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setUserField16(UserParser.parseString(jsonobject, "userfield16"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("userfield17");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setUserField17(UserParser.parseString(jsonobject, "userfield17"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("userfield18");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setUserField18(UserParser.parseString(jsonobject, "userfield18"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("userfield19");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setUserField19(UserParser.parseString(jsonobject, "userfield19"));
        }
    }, new JSONAttributeMapper(){

        @Override
        public boolean jsonObjectContains(JSONObject jsonobject) {
            return jsonobject.has("userfield20");
        }

        @Override
        public void setObject(Contact contactobject, JSONObject jsonobject) throws JSONException {
            contactobject.setUserField20(UserParser.parseString(jsonobject, "userfield20"));
        }
    }};

    private UserParser() {
    }

    public static ParsedUser parseUserData(JSONObject userJSONObject, int userId) throws OXException {
        try {
            ParsedUser user = new ParsedUser();
            if (userJSONObject.has(UserField.LOCALE.getName())) {
                user.setLocale(UserParser.parseLocaleString(userJSONObject.getString(UserField.LOCALE.getName())));
            }
            if (userJSONObject.has(UserField.TIME_ZONE.getName())) {
                user.setTimeZone(userJSONObject.getString(UserField.TIME_ZONE.getName()));
            }
            user.setId(userId);
            return user;
        }
        catch (JSONException e) {
            throw AjaxExceptionCodes.JSON_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
    }

    public static Contact parseUserContact(JSONObject userJSONObject, TimeZone timeZone) throws OXException {
        try {
            Contact contact = new Contact();
            for (JSONAttributeMapper element : mapping) {
                if (!element.jsonObjectContains(userJSONObject)) continue;
                element.setObject(contact, userJSONObject);
            }
            if (userJSONObject.has(UserField.DISTRIBUTIONLIST.getName())) {
                UserParser.parseDistributionList(contact, userJSONObject);
            }
            if (userJSONObject.has(UserField.LINKS.getName())) {
                UserParser.parseLinks(contact, userJSONObject);
            }
            if (userJSONObject.has(UserField.CATEGORIES.getName())) {
                contact.setCategories(UserParser.parseString(userJSONObject, UserField.CATEGORIES.getName()));
            }
            if (userJSONObject.has(UserField.COLOR_LABEL.getName())) {
                contact.setLabel(UserParser.parseInt(userJSONObject, UserField.COLOR_LABEL.getName()));
            }
            if (userJSONObject.has(UserField.PRIVATE_FLAG.getName())) {
                contact.setPrivateFlag(UserParser.parseBoolean(userJSONObject, UserField.PRIVATE_FLAG.getName()));
            }
            if (userJSONObject.has(UserField.NUMBER_OF_ATTACHMENTS.getName())) {
                contact.setNumberOfAttachments(UserParser.parseInt(userJSONObject, UserField.NUMBER_OF_ATTACHMENTS.getName()));
            }
            if (userJSONObject.has(UserField.FOLDER_ID.getName())) {
                contact.setParentFolderID(UserParser.parseInt(userJSONObject, UserField.FOLDER_ID.getName()));
            }
            if (userJSONObject.has(UserField.ID.getName())) {
                contact.setObjectID(UserParser.parseInt(userJSONObject, UserField.ID.getName()));
            }
            if (userJSONObject.has(UserField.INTERNAL_USERID.getName())) {
                contact.setInternalUserId(UserParser.parseInt(userJSONObject, UserField.INTERNAL_USERID.getName()));
            }
            if (userJSONObject.has(UserField.CREATED_BY.getName())) {
                contact.setCreatedBy(UserParser.parseInt(userJSONObject, UserField.CREATED_BY.getName()));
            }
            if (userJSONObject.has(UserField.CREATION_DATE.getName())) {
                contact.setCreationDate(UserParser.parseTime(userJSONObject, UserField.CREATION_DATE.getName(), timeZone));
            }
            if (userJSONObject.has(UserField.MODIFIED_BY.getName())) {
                contact.setModifiedBy(UserParser.parseInt(userJSONObject, UserField.MODIFIED_BY.getName()));
            }
            if (userJSONObject.has(UserField.LAST_MODIFIED.getName())) {
                contact.setLastModified(UserParser.parseTime(userJSONObject, UserField.LAST_MODIFIED.getName(), timeZone));
            }
            return contact;
        }
        catch (JSONException e) {
            throw AjaxExceptionCodes.JSON_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
        catch (OXException e) {
            throw new OXException(e);
        }
    }

    private static void parseDistributionList(Contact oxobject, JSONObject jsonobject) throws JSONException, OXException {
        JSONArray jdistributionlist = jsonobject.getJSONArray("distribution_list");
        DistributionListEntryObject[] distributionlist = new DistributionListEntryObject[jdistributionlist.length()];
        for (int a = 0; a < jdistributionlist.length(); ++a) {
            JSONObject entry = jdistributionlist.getJSONObject(a);
            distributionlist[a] = new DistributionListEntryObject();
            if (entry.has("id")) {
                distributionlist[a].setEntryID(UserParser.parseInt(entry, "id"));
            }
            if (entry.has(UserField.FIRST_NAME.getName())) {
                distributionlist[a].setFirstname(UserParser.parseString(entry, UserField.FIRST_NAME.getName()));
            }
            if (entry.has(UserField.LAST_NAME.getName())) {
                distributionlist[a].setLastname(UserParser.parseString(entry, UserField.LAST_NAME.getName()));
            }
            distributionlist[a].setDisplayname(UserParser.parseString(entry, UserField.DISPLAY_NAME.getName()));
            distributionlist[a].setEmailaddress(UserParser.parseString(entry, DistributionListField.MAIL.getName()));
            distributionlist[a].setEmailfield(UserParser.parseInt(entry, DistributionListField.MAIL_FIELD.getName()));
        }
        oxobject.setDistributionList(distributionlist);
    }

    private static void parseLinks(Contact oxobject, JSONObject jsonobject) throws JSONException {
        JSONArray jlinks = jsonobject.getJSONArray(UserField.LINKS.getName());
        LinkEntryObject[] links = new LinkEntryObject[jlinks.length()];
        for (int a = 0; a < links.length; ++a) {
            links[a] = new LinkEntryObject();
            JSONObject entry = jlinks.getJSONObject(a);
            if (entry.has("id")) {
                links[a].setLinkID(UserParser.parseInt(entry, UserField.ID.getName()));
            }
            links[a].setLinkDisplayname(UserParser.parseString(entry, UserField.DISPLAY_NAME.getName()));
        }
        oxobject.setLinks(links);
    }

    private static Locale parseLocaleString(String localeStr) throws OXException {
        Matcher match = identifierPattern.matcher(localeStr);
        Locale retval = null;
        if (match.matches()) {
            String country = match.group(2);
            String variant = match.group(3);
            retval = new Locale(match.group(1), country == null ? "" : country, variant == null ? "" : variant);
        }
        return retval;
    }

    static String parseString(JSONObject jsonObj, String name) throws JSONException {
        String test;
        String retval = null;
        if (jsonObj.hasAndNotNull(name) && 0 != (test = jsonObj.getString(name)).length()) {
            retval = test;
        }
        return retval;
    }

    static int parseInt(JSONObject jsonObj, String name) throws JSONException {
        if (!jsonObj.has(name)) {
            return 0;
        }
        String tmp = jsonObj.getString(name);
        if (tmp == null || jsonObj.isNull(name) || tmp.length() == 0) {
            return 0;
        }
        try {
            return Integer.parseInt(tmp);
        }
        catch (NumberFormatException exc) {
            StringAllocator sb = new StringAllocator(32).append("Attribute \"");
            sb.append(name).append("\" is not a number: ").append(tmp);
            throw new JSONException(sb.toString());
        }
    }

    static boolean parseBoolean(JSONObject jsonObj, String name) throws JSONException {
        if (!jsonObj.has(name)) {
            return false;
        }
        return jsonObj.getBoolean(name);
    }

    static Date parseDate(JSONObject jsonObj, String name) throws JSONException {
        if (!jsonObj.has(name)) {
            return null;
        }
        String tmp = UserParser.parseString(jsonObj, name);
        if (tmp == null) {
            return null;
        }
        try {
            return new Date(Long.parseLong(tmp));
        }
        catch (NumberFormatException e) {
            StringAllocator sb = new StringAllocator(64).append("Attribute \"");
            sb.append(name).append("\" does not denote date's milliseconds since January 1, 1970, 00:00:00 GMT: ").append(tmp);
            throw new JSONException(sb.toString());
        }
    }

    static Date parseTime(JSONObject jsonObj, String name, TimeZone timeZone) throws JSONException {
        Date d = UserParser.parseDate(jsonObj, name);
        if (d == null) {
            return null;
        }
        int offset = timeZone.getOffset(d.getTime());
        d.setTime(d.getTime() - (long)offset);
        return d;
    }

    private static interface JSONAttributeMapper {
        public boolean jsonObjectContains(JSONObject var1);

        public void setObject(Contact var1, JSONObject var2) throws JSONException;
    }
}

