/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.xml;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.session.Session;
import com.openexchange.webdav.WebdavExceptionCode;
import com.openexchange.webdav.xml.FolderChildParser;
import java.util.ArrayList;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class FolderParser
extends FolderChildParser {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(FolderParser.class));

    public FolderParser(Session sessionObj) {
        this.sessionObj = sessionObj;
    }

    public void parse(XmlPullParser parser, FolderObject folderobject) throws OXException, XmlPullParserException {
        try {
            while (parser.getEventType() != 3 || !parser.getName().equals("prop")) {
                this.parseElementFolder(folderobject, parser);
                parser.nextTag();
            }
        }
        catch (XmlPullParserException exc) {
            throw exc;
        }
        catch (Exception exc) {
            throw new OXException((Throwable)exc);
        }
    }

    protected void parseElementFolder(FolderObject folderobject, XmlPullParser parser) throws Exception {
        if (!this.hasCorrectNamespace(parser)) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("unknown namespace in tag: " + parser.getName()));
            }
            parser.nextText();
            return;
        }
        if (this.isTag(parser, "title")) {
            folderobject.setFolderName(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "type")) {
            String type = this.getValue(parser);
            if ("private".equals(type)) {
                folderobject.setType(1);
            } else if ("public".equals(type)) {
                folderobject.setType(2);
            } else {
                throw WebdavExceptionCode.IO_ERROR.create("unknown value in type: " + type);
            }
            return;
        }
        if (this.isTag(parser, "module")) {
            String module = this.getValue(parser);
            if ("calendar".equals(module)) {
                folderobject.setModule(2);
            } else if ("contact".equals(module)) {
                folderobject.setModule(3);
            } else if ("task".equals(module)) {
                folderobject.setModule(1);
            } else if ("unbound".equals(module)) {
                folderobject.setModule(4);
            } else {
                throw WebdavExceptionCode.IO_ERROR.create("unknown value in module: " + module);
            }
            return;
        }
        if (this.isTag(parser, "permissions")) {
            this.parseElementPermissions(folderobject, parser);
            return;
        }
        this.parseElementFolderChildObject(folderobject, parser);
    }

    protected void parseElementPermissions(FolderObject folderobject, XmlPullParser parser) throws OXException {
        ArrayList<OCLPermission> permissions = new ArrayList<OCLPermission>();
        try {
            boolean isPermission = true;
            while (isPermission) {
                parser.nextTag();
                if (FolderParser.isEnd(parser)) {
                    throw WebdavExceptionCode.IO_ERROR.create("invalid xml in permission!");
                }
                if (parser.getName().equals("permissions") && parser.getEventType() == 3) {
                    isPermission = false;
                    break;
                }
                OCLPermission oclp = new OCLPermission();
                if (this.isTag(parser, "user")) {
                    this.parseElementPermissionAttributes(oclp, parser);
                    this.parseEntity(oclp, parser);
                } else if (this.isTag(parser, "group")) {
                    this.parseElementPermissionAttributes(oclp, parser);
                    this.parseEntity(oclp, parser);
                    oclp.setGroupPermission(true);
                } else {
                    throw WebdavExceptionCode.IO_ERROR.create("unknown xml tag in permissions: " + parser.getName());
                }
                permissions.add(oclp);
            }
        }
        catch (Exception exc) {
            throw new OXException((Throwable)exc);
        }
        folderobject.setPermissions(permissions);
    }

    protected void parseEntity(OCLPermission oclp, XmlPullParser parser) throws Exception {
        oclp.setEntity(this.getValueAsInt(parser));
    }

    protected void parseElementPermissionAttributes(OCLPermission oclp, XmlPullParser parser) throws Exception {
        int fp = this.getPermissionAttributeValue(parser, "folderpermission");
        int orp = this.getPermissionAttributeValue(parser, "objectreadpermission");
        int owp = this.getPermissionAttributeValue(parser, "objectwritepermission");
        int odp = this.getPermissionAttributeValue(parser, "objectdeletepermission");
        oclp.setAllPermission(fp, orp, owp, odp);
        oclp.setFolderAdmin(this.getPermissionAdminFlag(parser));
    }

    protected int getPermissionAttributeValue(XmlPullParser parser, String name) throws Exception {
        return Integer.parseInt(parser.getAttributeValue("http://www.open-xchange.org", name));
    }

    protected boolean getPermissionAdminFlag(XmlPullParser parser) throws Exception {
        return Boolean.parseBoolean(parser.getAttributeValue("http://www.open-xchange.org", "admin_flag"));
    }
}

