/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.protocol.osgi;

import com.openexchange.exception.OXException;
import com.openexchange.tools.session.SessionHolder;
import com.openexchange.webdav.protocol.WebdavProperty;
import com.openexchange.webdav.protocol.helpers.PropertyMixin;
import com.openexchange.webdav.protocol.helpers.PropertyMixinFactory;
import java.util.ArrayList;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class OSGiPropertyMixin
implements PropertyMixin {
    private ServiceTracker mixinTracker = null;
    private final ServiceTracker factoryTracker;
    private final SessionHolder sessionHolder;

    public OSGiPropertyMixin(BundleContext context, SessionHolder sessionHolder) {
        this.sessionHolder = sessionHolder;
        this.mixinTracker = new ServiceTracker(context, PropertyMixin.class.getName(), null);
        this.mixinTracker.open();
        this.factoryTracker = new ServiceTracker(context, PropertyMixinFactory.class.getName(), null);
        this.factoryTracker.open();
    }

    public void close() {
        this.mixinTracker.close();
        this.factoryTracker.close();
    }

    @Override
    public List<WebdavProperty> getAllProperties() throws OXException {
        Object[] factories;
        Object[] mixins = this.mixinTracker.getServices();
        ArrayList<WebdavProperty> allProperties = new ArrayList<WebdavProperty>();
        if (mixins != null) {
            for (Object object : mixins) {
                PropertyMixin mixin = (PropertyMixin)object;
                allProperties.addAll(mixin.getAllProperties());
            }
        }
        if ((factories = this.factoryTracker.getServices()) != null) {
            for (Object object : factories) {
                PropertyMixinFactory factory = (PropertyMixinFactory)object;
                PropertyMixin mixin = factory.create(this.sessionHolder);
                allProperties.addAll(mixin.getAllProperties());
            }
        }
        return allProperties;
    }

    @Override
    public WebdavProperty getProperty(String namespace, String name) throws OXException {
        Object[] factories;
        Object[] mixins = this.mixinTracker.getServices();
        if (mixins != null) {
            for (Object object : mixins) {
                PropertyMixin mixin = (PropertyMixin)object;
                WebdavProperty property = mixin.getProperty(namespace, name);
                if (property == null) continue;
                return property;
            }
        }
        if ((factories = this.factoryTracker.getServices()) != null) {
            for (Object object : factories) {
                PropertyMixinFactory factory = (PropertyMixinFactory)object;
                PropertyMixin mixin = factory.create(this.sessionHolder);
                WebdavProperty property = mixin.getProperty(namespace, name);
                if (property == null) continue;
                return property;
            }
        }
        return null;
    }
}

