/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.action.ifheader;

public abstract class IfHeaderEntity {
    private final String payload;
    private boolean matches;

    public IfHeaderEntity(String payload) {
        this.payload = payload;
    }

    public abstract boolean isETag();

    public abstract boolean isLockToken();

    public String getPayload() {
        return this.payload;
    }

    public boolean mustMatch() {
        return this.matches;
    }

    public void setMatches(boolean matches) {
        this.matches = matches;
    }

    public static class ETag
    extends IfHeaderEntity {
        public ETag(String etag) {
            super(etag);
        }

        @Override
        public boolean isETag() {
            return true;
        }

        @Override
        public boolean isLockToken() {
            return false;
        }
    }

    public static class LockToken
    extends IfHeaderEntity {
        public LockToken(String payload) {
            super(payload);
        }

        @Override
        public boolean isETag() {
            return false;
        }

        @Override
        public boolean isLockToken() {
            return true;
        }
    }
}

