/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.webdav;

import com.openexchange.authentication.Cookie;
import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;
import com.openexchange.java.util.UUIDs;
import com.openexchange.log.LogFactory;
import com.openexchange.login.Interface;
import com.openexchange.login.LoginRequest;
import com.openexchange.login.internal.LoginPerformer;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.sessiond.SessiondService;
import com.openexchange.tools.servlet.http.Authorization;
import com.openexchange.tools.servlet.http.Tools;
import com.openexchange.tools.webdav.LoginCustomizer;
import com.openexchange.tools.webdav.WebDavServlet;
import com.openexchange.tools.webdav.digest.Authorization;
import com.openexchange.tools.webdav.digest.DigestUtility;
import com.openexchange.webdav.WebdavExceptionCode;
import com.openexchange.xml.jdom.JDOMParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.jdom2.Document;
import org.jdom2.JDOMException;

public abstract class OXServlet
extends WebDavServlet {
    private static final long serialVersionUID = 301910346402779362L;
    private static final transient Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(OXServlet.class));
    private static final String SESSION = OXServlet.class.getName() + "SESSION";
    private static final String basicRealm = "OX WebDAV";
    private static final String digestRealm = "Open-Xchange";
    protected static final String COOKIE_SESSIONID = "sessionid";
    private static final String DIGEST_AUTH = "digest";
    private static final LoginPerformer loginPerformer = LoginPerformer.getInstance();

    protected OXServlet() {
    }

    protected boolean useHttpAuth() {
        return true;
    }

    protected abstract Interface getInterface();

    @Override
    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        req.getSession(true);
        if (!"TRACE".equals(req.getMethod()) && this.useHttpAuth() && !OXServlet.doAuth(req, resp, this.getInterface(), this.getLoginCustomizer())) {
            return;
        }
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Entering HTTP sub method. Session: " + OXServlet.getSession(req)));
            }
            super.service(req, resp);
        }
        catch (ServletException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            ServletException se = new ServletException(e.getMessage(), (Throwable)e);
            throw se;
        }
    }

    protected LoginCustomizer getLoginCustomizer() {
        return null;
    }

    public static boolean doAuth(HttpServletRequest req, HttpServletResponse resp, Interface face) throws IOException {
        return OXServlet.doAuth(req, resp, face, null);
    }

    public static boolean doAuth(HttpServletRequest req, HttpServletResponse resp, Interface face, LoginCustomizer customizer) throws IOException {
        Session session;
        try {
            session = OXServlet.findSessionByCookie(req, resp);
        }
        catch (OXException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            resp.sendError(500, e.getMessage());
            return false;
        }
        if (null == session) {
            LoginRequest loginRequest;
            try {
                loginRequest = OXServlet.parseLogin(req, face);
                if (customizer != null) {
                    loginRequest = customizer.modifyLogin(loginRequest);
                }
            }
            catch (OXException e) {
                LOG.debug((Object)e.getMessage(), (Throwable)e);
                OXServlet.addUnauthorizedHeader(req, resp);
                resp.sendError(401, "Authorization Required!");
                return false;
            }
            try {
                HashMap<String, Object> properties = new HashMap<String, Object>(1);
                properties.put("http.request", req);
                session = OXServlet.addSession(loginRequest, properties);
            }
            catch (OXException e) {
                if (e.getCategory() == Category.CATEGORY_USER_INPUT) {
                    OXServlet.addUnauthorizedHeader(req, resp);
                    resp.sendError(401, "Authorization Required!");
                } else {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                    resp.sendError(500, e.getMessage());
                }
                return false;
            }
            resp.addCookie(new javax.servlet.http.Cookie(COOKIE_SESSIONID, session.getSessionID()));
        } else {
            String address = req.getRemoteAddr();
            if (null == address || !address.equals(session.getLocalIp())) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("Request to server denied for session: " + session.getSessionID() + ". in WebDAV XML interface. Client login IP changed from " + session.getLocalIp() + " to " + address + "."));
                }
                OXServlet.addUnauthorizedHeader(req, resp);
                OXServlet.removeSession(session.getSessionID());
                OXServlet.removeCookie(req, resp, COOKIE_SESSIONID);
                resp.sendError(401, "Authorization Required!");
                return false;
            }
        }
        req.setAttribute(SESSION, (Object)session);
        return true;
    }

    private static void removeCookie(HttpServletRequest req, HttpServletResponse resp, String ... cookiesToRemove) {
        javax.servlet.http.Cookie[] cookies = req.getCookies();
        if (cookies == null) {
            return;
        }
        List<String> cookieNames = Arrays.asList(cookiesToRemove);
        for (javax.servlet.http.Cookie cookie : cookies) {
            String name = cookie.getName();
            for (String string : cookieNames) {
                if (!name.startsWith(string)) continue;
                javax.servlet.http.Cookie respCookie = new javax.servlet.http.Cookie(name, cookie.getValue());
                respCookie.setPath("/");
                respCookie.setMaxAge(0);
                resp.addCookie(respCookie);
            }
        }
    }

    private static void removeSession(String sessionID) {
        try {
            ServerServiceRegistry.getInstance().getService(SessiondService.class, true).removeSession(sessionID);
        }
        catch (OXException oXException) {
            // empty catch block
        }
    }

    private static boolean checkForDigestAuthorization(String auth) {
        if (null == auth) {
            return false;
        }
        if (auth.length() <= DIGEST_AUTH.length()) {
            return false;
        }
        return auth.substring(0, DIGEST_AUTH.length()).equalsIgnoreCase(DIGEST_AUTH);
    }

    protected static void addUnauthorizedHeader(HttpServletRequest req, HttpServletResponse resp) {
        StringBuilder builder = new StringBuilder(64);
        builder.append("Basic realm=\"").append(basicRealm).append("\", encoding=\"UTF-8\"");
        resp.setHeader("WWW-Authenticate", builder.toString());
        builder.setLength(0);
        builder.append("Digest realm=\"").append(digestRealm).append('\"').append(", ");
        builder.append("qop=\"auth,auth-int\"").append(", ");
        builder.append("nonce=\"").append(DigestUtility.getInstance().generateNOnce(req)).append('\"').append(", ");
        String opaque = UUIDs.getUnformattedString((UUID)UUID.randomUUID());
        builder.append("opaque=\"").append(opaque).append('\"').append(", ");
        builder.append("stale=\"false\"").append(", ");
        builder.append("algorithm=\"MD5\"");
    }

    private static LoginRequest parseLogin(HttpServletRequest req, Interface face) throws OXException {
        String mech;
        String auth = req.getHeader("authorization");
        if (null == auth) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Authorization header missing.");
            }
            throw WebdavExceptionCode.MISSING_HEADER_FIELD.create("Authorization");
        }
        if (com.openexchange.tools.servlet.http.Authorization.checkForBasicAuthorization(auth)) {
            Authorization.Credentials creds = com.openexchange.tools.servlet.http.Authorization.decode(auth);
            if (!com.openexchange.tools.servlet.http.Authorization.checkLogin(creds.getPassword())) {
                throw WebdavExceptionCode.EMPTY_PASSWORD.create();
            }
            return new LoginRequestImpl(creds.getLogin(), creds.getPassword(), face, req);
        }
        if (OXServlet.checkForDigestAuthorization(auth)) {
            Authorization authorization;
            String userName;
            DigestUtility digestUtility = DigestUtility.getInstance();
            String password = digestUtility.getPasswordByUserName(userName = (authorization = digestUtility.parseDigestAuthorization(auth)).getUser());
            if (!com.openexchange.tools.servlet.http.Authorization.checkLogin(password)) {
                throw WebdavExceptionCode.UNSUPPORTED_AUTH_MECH.create("Digest");
            }
            String serverDigest = digestUtility.generateServerDigest(req, password);
            if (!serverDigest.equals(authorization.getResponse())) {
                throw WebdavExceptionCode.AUTH_FAILED.create(userName);
            }
            return new LoginRequestImpl(userName, password, face, req);
        }
        int pos = auth.indexOf(32);
        String string = mech = pos > 0 ? auth.substring(0, pos) : auth;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Unsupported Authentication header.");
        }
        throw WebdavExceptionCode.UNSUPPORTED_AUTH_MECH.create(mech);
    }

    private static Session addSession(LoginRequest request, Map<String, Object> properties) throws OXException {
        return loginPerformer.doLogin(request, properties).getSession();
    }

    private static Session findSessionByCookie(HttpServletRequest req, HttpServletResponse resp) throws OXException {
        javax.servlet.http.Cookie[] cookies = req.getCookies();
        String sessionId = null;
        if (null != cookies) {
            for (javax.servlet.http.Cookie cookie : cookies) {
                if (!COOKIE_SESSIONID.equals(cookie.getName())) continue;
                sessionId = cookie.getValue();
                break;
            }
        }
        if (null == sessionId) {
            return null;
        }
        Session session = ServerServiceRegistry.getInstance().getService(SessiondService.class, true).getSession(sessionId);
        if (null == session && resp != null) {
            javax.servlet.http.Cookie cookie = new javax.servlet.http.Cookie(COOKIE_SESSIONID, sessionId);
            cookie.setMaxAge(0);
            resp.addCookie(cookie);
        }
        return session;
    }

    public static Session getSession(HttpServletRequest req) {
        Session session = (Session)req.getAttribute(SESSION);
        if (null == session) {
            LOG.error((Object)"Somebody gets a null session.");
        }
        return session;
    }

    protected Document getJDOMDocument(HttpServletRequest req) throws JDOMException, IOException {
        Document doc = null;
        if (req.getContentLength() > 0) {
            doc = ServerServiceRegistry.getInstance().getService(JDOMParser.class).parse((InputStream)req.getInputStream());
        }
        return doc;
    }

    private static final class LoginRequestImpl
    implements LoginRequest {
        private final String login;
        private final HttpServletRequest req;
        private final String userAgent;
        private final String pass;
        private final String client;
        private final Interface interfaze;
        private final String version;
        private final boolean isVolatile;

        public LoginRequestImpl(String login, String pass, Interface interfaze, HttpServletRequest req) {
            this.client = req.getParameter("client");
            this.version = req.getParameter("version");
            this.userAgent = req.getParameter("agent");
            String parameter = req.getParameter("volatile");
            this.isVolatile = null != parameter && Boolean.parseBoolean(parameter.trim());
            this.login = login;
            this.req = req;
            this.pass = pass;
            this.interfaze = interfaze;
        }

        @Override
        public boolean isVolatile() {
            return this.isVolatile;
        }

        @Override
        public String getUserAgent() {
            return null == this.userAgent ? this.req.getHeader("user-agent") : this.userAgent;
        }

        @Override
        public String getPassword() {
            return this.pass;
        }

        @Override
        public String getLogin() {
            return this.login;
        }

        @Override
        public Interface getInterface() {
            return this.interfaze;
        }

        @Override
        public String getClientIP() {
            return this.req.getRemoteAddr();
        }

        @Override
        public String getAuthId() {
            return UUIDs.getUnformattedString((UUID)UUID.randomUUID());
        }

        @Override
        public String getClient() {
            return this.client;
        }

        @Override
        public String getVersion() {
            return this.version;
        }

        @Override
        public String getHash() {
            return null;
        }

        @Override
        public Map<String, List<String>> getHeaders() {
            return Tools.copyHeaders(this.req);
        }

        @Override
        public Cookie[] getCookies() {
            return Tools.getCookieFromHeader(this.req);
        }
    }
}

