/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.oxfolder.treeconsistency;

import com.openexchange.cache.impl.FolderCacheManager;
import com.openexchange.cache.impl.FolderQueryCacheManager;
import com.openexchange.exception.OXException;
import com.openexchange.group.GroupStorage;
import com.openexchange.groupware.calendar.CalendarCache;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.log.LogFactory;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.oxfolder.OXFolderExceptionCode;
import com.openexchange.tools.oxfolder.OXFolderSQL;
import com.openexchange.tools.oxfolder.memory.ConditionTreeMapManagement;
import com.openexchange.tools.oxfolder.treeconsistency.CheckPermission;
import com.openexchange.tools.oxfolder.treeconsistency.ToDoPermission;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.osgi.service.event.EventAdmin;

public final class CheckPermissionOnRemove
extends CheckPermission {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(CheckPermissionOnRemove.class));

    public CheckPermissionOnRemove(Session session, Connection writeCon, Context ctx) {
        super(session, writeCon, ctx);
    }

    public void checkPermissionsOnUpdate(int folderId, OCLPermission[] removedPerms, long lastModified) throws OXException {
        try {
            FolderObject folder = this.getFolderFromMaster(folderId);
            HashMap<Integer, ToDoPermission> toRemove = new HashMap<Integer, ToDoPermission>();
            List<OCLPermission> permissions = folder.getPermissions();
            for (OCLPermission perm : removedPerms) {
                OCLPermission removedPerm = perm;
                if (CheckPermissionOnRemove.containsSystemPermission(permissions, removedPerm.getEntity())) continue;
                int parent = folder.getParentFolderID();
                this.hasVisibleSibling(parent, folderId, parent, removedPerm.getEntity(), removedPerm.isGroupPermission(), toRemove);
            }
            if (!toRemove.isEmpty()) {
                this.removeSystemPermissions(lastModified, toRemove);
            }
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
    }

    public void checkPermissionsOnDelete(int parent, int deletedId, OCLPermission[] formerPerms, long lastModified) throws OXException {
        try {
            HashMap<Integer, ToDoPermission> toRemove = new HashMap<Integer, ToDoPermission>();
            for (OCLPermission formerPerm : formerPerms) {
                this.hasVisibleSibling(parent, deletedId, parent, formerPerm.getEntity(), formerPerm.isGroupPermission(), toRemove);
            }
            if (!toRemove.isEmpty()) {
                this.removeSystemPermissions(lastModified, toRemove);
            }
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
    }

    private void hasVisibleSibling(int parent, int exclude, int origin, int entity, boolean isGroup, Map<Integer, ToDoPermission> toRemove) throws OXException, OXException, SQLException {
        if (parent < 20) {
            return;
        }
        ArrayList<Integer> siblingIDs = FolderObject.getSubfolderIds(parent, this.ctx, this.writeCon);
        for (Integer siblingID : siblingIDs) {
            if (siblingID == exclude || !this.getFolderFromMaster(siblingID).isVisible(entity)) continue;
            return;
        }
        Integer key = parent;
        ToDoPermission todo = toRemove.get(key);
        if (todo == null) {
            todo = new ToDoPermission(parent);
            toRemove.put(key, todo);
        }
        if (isGroup) {
            todo.addGroup(entity);
        } else {
            todo.addUser(entity);
        }
        if (!this.getFolderFromMaster(parent).isNonSystemVisible(entity)) {
            this.hasVisibleSibling(this.getFolderFromMaster(parent).getParentFolderID(), parent, origin, entity, isGroup, toRemove);
        }
    }

    private void deleteSystemFolderReadPermission(int folderId, int entity) throws OXException, SQLException {
        OXFolderSQL.deleteSingleSystemPermission(folderId, entity, this.writeCon, this.ctx);
    }

    private void removeSystemPermissions(long lastModified, Map<Integer, ToDoPermission> toRemove) throws OXException, SQLException {
        int size2 = toRemove.size();
        Iterator<Map.Entry<Integer, ToDoPermission>> iter2 = toRemove.entrySet().iterator();
        for (int i = 0; i < size2; ++i) {
            int[] groups;
            int[] users;
            Map.Entry<Integer, ToDoPermission> entry = iter2.next();
            int fid = entry.getKey();
            for (int user : users = entry.getValue().getUsers()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Auto-Delete system-folder-read permission for user " + UserStorage.getStorageUser(user, this.ctx).getDisplayName() + " from folder " + fid));
                }
                this.deleteSystemFolderReadPermission(fid, user);
            }
            for (int group : groups = entry.getValue().getGroups()) {
                if (LOG.isDebugEnabled()) {
                    try {
                        LOG.debug((Object)("Auto-Delete system-folder-read permission for group " + GroupStorage.getInstance().getGroup(group, this.ctx).getDisplayName() + " from folder " + fid));
                    }
                    catch (OXException e) {
                        LOG.trace((Object)"Logging failed", (Throwable)e);
                    }
                }
                this.deleteSystemFolderReadPermission(fid, group);
            }
            OXFolderSQL.updateLastModified(fid, lastModified, this.ctx.getMailadmin(), this.writeCon, this.ctx);
            ConditionTreeMapManagement.dropFor(this.ctx.getContextId());
            try {
                if (FolderCacheManager.isEnabled()) {
                    FolderCacheManager.getInstance().removeFolderObject(fid, this.ctx);
                }
                this.broadcastEvent(fid, true, ServerServiceRegistry.getInstance().getService(EventAdmin.class));
                if (FolderQueryCacheManager.isInitialized()) {
                    FolderQueryCacheManager.getInstance().invalidateContextQueries(this.session);
                }
                if (!CalendarCache.isInitialized()) continue;
                CalendarCache.getInstance().invalidateGroup(this.ctx.getContextId());
                continue;
            }
            catch (OXException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }
}

