/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.mail.spam;

import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;

public final class CommandExecutor {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(CommandExecutor.class));
    private final Process process;
    private final InputStreamSucker errSucker;
    private final InputStreamSucker outSucker;
    private final OutputStream inputStream;
    private static final int BUFFERSIZE = 8192;

    public CommandExecutor(String cmd) throws IOException {
        if (cmd == null) {
            throw new IllegalArgumentException("command is null");
        }
        this.process = Runtime.getRuntime().exec(cmd);
        this.errSucker = new InputStreamSucker(this.process.getErrorStream());
        this.outSucker = new InputStreamSucker(this.process.getInputStream());
        this.inputStream = this.process.getOutputStream();
        this.errSucker.start();
        this.outSucker.start();
    }

    public void send(String in) throws IOException {
        this.inputStream.write(in.getBytes());
        this.inputStream.flush();
        this.inputStream.close();
    }

    public void send(InputStream in) throws IOException {
        CommandExecutor.streamCopy(in, this.inputStream);
        this.inputStream.flush();
        this.inputStream.close();
    }

    public int waitFor() throws InterruptedException {
        int exitCode = this.process.waitFor();
        this.waitForThreads();
        return exitCode;
    }

    public String getErrorString() {
        return this.errSucker.getBuffer();
    }

    public String getOutputString() {
        return this.outSucker.getBuffer();
    }

    private void waitForThreads() throws InterruptedException {
        if (this.outSucker.isAlive()) {
            this.outSucker.join();
        }
        if (this.errSucker.isAlive()) {
            this.errSucker.join();
        }
    }

    private static long streamCopy(InputStream in, OutputStream out) throws IOException {
        int read;
        byte[] buffer = new byte[8192];
        long copied = 0L;
        while ((read = in.read(buffer)) > 0) {
            out.write(buffer, 0, read);
            copied += (long)read;
        }
        return copied;
    }

    public static class InputStreamSucker
    extends Thread {
        private final InputStream is;
        private final StringBuilder buf;

        public InputStreamSucker(InputStream is) {
            this.is = is;
            this.buf = new StringBuilder();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            InputStreamReader isr = null;
            BufferedReader br = null;
            try {
                isr = new InputStreamReader(this.is);
                br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    this.buf.append(line).append('\n');
                }
            }
            catch (IOException ioe) {
                LOG.error((Object)ioe.getMessage(), (Throwable)ioe);
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        LOG.error((Object)e.getMessage(), (Throwable)e);
                    }
                    br = null;
                }
                if (isr != null) {
                    try {
                        isr.close();
                    }
                    catch (IOException e) {
                        LOG.error((Object)e.getMessage(), (Throwable)e);
                    }
                    isr = null;
                }
            }
        }

        public final String getBuffer() {
            return this.buf.toString();
        }
    }
}

