/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.sessiond.impl.clt;

import com.openexchange.exception.OXException;
import com.openexchange.management.console.JMXAuthenticatorImpl;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public final class CloseSessionsCLT {
    private static final Options toolkitOptions = new Options();

    private static void printHelp() {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.printHelp("forceupdatetask", toolkitOptions);
    }

    private CloseSessionsCLT() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        PosixParser parser = new PosixParser();
        int contextId = -1;
        try {
            HashMap<String, JMXAuthenticatorImpl> environment;
            String val;
            CommandLine cmd = parser.parse(toolkitOptions, args);
            if (cmd.hasOption('h')) {
                CloseSessionsCLT.printHelp();
                System.exit(0);
            }
            int port = 9999;
            if (cmd.hasOption('p') && null != (val = cmd.getOptionValue('p'))) {
                try {
                    port = Integer.parseInt(val.trim());
                }
                catch (NumberFormatException e) {
                    System.err.println("Port parameter is not a number: " + val);
                    CloseSessionsCLT.printHelp();
                    System.exit(0);
                }
                if (port < 1 || port > 65535) {
                    System.err.println("Port parameter is out of range: " + val + ". Valid range is from 1 to 65535.");
                    CloseSessionsCLT.printHelp();
                    System.exit(0);
                }
            }
            if (cmd.hasOption('c')) {
                String optionValue = cmd.getOptionValue('c');
                try {
                    contextId = Integer.parseInt(optionValue.trim());
                }
                catch (NumberFormatException e) {
                    System.err.println("Context identifier parameter is not a number: " + optionValue);
                    CloseSessionsCLT.printHelp();
                    System.exit(0);
                }
            } else {
                System.err.println("Missing context identifier.");
                CloseSessionsCLT.printHelp();
                System.exit(0);
            }
            String jmxLogin = null;
            if (cmd.hasOption('l')) {
                jmxLogin = cmd.getOptionValue('l');
            }
            String jmxPassword = null;
            if (cmd.hasOption('s')) {
                jmxPassword = cmd.getOptionValue('s');
            }
            if (jmxLogin == null || jmxPassword == null) {
                environment = null;
            } else {
                environment = new HashMap<String, JMXAuthenticatorImpl>(1);
                environment.put("jmx.remote.authenticator", new JMXAuthenticatorImpl(jmxLogin, jmxPassword));
            }
            JMXServiceURL url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://localhost:" + port + "/server");
            JMXConnector jmxConnector = JMXConnectorFactory.connect(url, environment);
            try {
                MBeanServerConnection mbsc = jmxConnector.getMBeanServerConnection();
                String[] signature = new String[]{Integer.TYPE.getName()};
                Object[] params = new Object[]{contextId};
                mbsc.invoke(CloseSessionsCLT.getObjectName("SessionD Toolkit", "com.openexchange.sessiond"), "clearContextSessions", params, signature);
            }
            finally {
                jmxConnector.close();
            }
        }
        catch (MalformedObjectNameException e) {
            System.err.println("Invalid MBean name: " + e.getMessage());
        }
        catch (ParseException e) {
            System.err.println("Unable to parse command line: " + e.getMessage());
            CloseSessionsCLT.printHelp();
        }
        catch (MalformedURLException e) {
            System.err.println("URL to connect to server is invalid: " + e.getMessage());
        }
        catch (IOException e) {
            System.err.println("Unable to communicate with the server: " + e.getMessage());
        }
        catch (InstanceNotFoundException e) {
            System.err.println("Instance is not available: " + e.getMessage());
        }
        catch (MBeanException e) {
            OXException oxe;
            Throwable t = e.getCause();
            String message = null == t ? e.getMessage() : (t instanceof OXException ? ("CTX".equals((oxe = (OXException)t).getPrefix()) ? "Cannot find context " + contextId : t.getMessage()) : t.getMessage());
            System.err.println(null == message ? "Unexpected error." : "Unexpected error: " + message);
        }
        catch (ReflectionException e) {
            System.err.println("Problem with reflective type handling: " + e.getMessage());
        }
        catch (RuntimeException e) {
            System.err.println("Problem in runtime: " + e.getMessage());
            CloseSessionsCLT.printHelp();
        }
    }

    private static ObjectName getObjectName(String className, String domain) throws MalformedObjectNameException {
        int pos = className.lastIndexOf(46);
        return new ObjectName(domain, "name", pos == -1 ? className : className.substring(pos + 1));
    }

    static {
        toolkitOptions.addOption("h", "help", false, "Prints a help text");
        toolkitOptions.addOption("c", "context", true, "A valid context identifier");
        toolkitOptions.addOption("p", "port", true, "The optional JMX port (default:9999)");
        toolkitOptions.addOption("l", "login", true, "The optional JMX login (if JMX has authentication enabled)");
        toolkitOptions.addOption("s", "password", true, "The optional JMX password (if JMX has authentication enabled)");
    }
}

