/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.server.osgi;

import com.openexchange.log.LogFactory;
import com.openexchange.passwordchange.PasswordChangeService;
import com.openexchange.passwordchange.service.PasswordChange;
import org.apache.commons.logging.Log;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public final class PasswordChangeCustomizer
implements ServiceTrackerCustomizer<PasswordChangeService, PasswordChangeService> {
    private static final Log LOG = LogFactory.getLog(PasswordChangeCustomizer.class);
    private final BundleContext context;

    public PasswordChangeCustomizer(BundleContext context) {
        this.context = context;
    }

    public PasswordChangeService addingService(ServiceReference<PasswordChangeService> reference) {
        PasswordChangeService addedService = (PasswordChangeService)this.context.getService(reference);
        if (null == addedService) {
            LOG.warn((Object)"Added service is null!", new Throwable());
        }
        if (PasswordChange.getService() == null) {
            PasswordChange.setService(addedService);
        } else {
            LOG.error((Object)"Several password change services found. Remove all except one!", new Throwable());
        }
        return addedService;
    }

    public void modifiedService(ServiceReference<PasswordChangeService> reference, PasswordChangeService service) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"UserPasswordChangeCustomizer.modifiedService()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedService(ServiceReference<PasswordChangeService> reference, PasswordChangeService service) {
        try {
            if (PasswordChange.getService() == service) {
                PasswordChange.setService(null);
            }
        }
        finally {
            this.context.ungetService(reference);
        }
    }
}

