/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.report.internal;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserImpl;
import com.openexchange.login.LoginHandlerService;
import com.openexchange.login.LoginRequest;
import com.openexchange.login.LoginResult;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.user.UserService;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class LastLoginRecorder
implements LoginHandlerService {
    @Override
    public void handleLogin(LoginResult login) throws OXException {
        String key;
        LoginRequest request = login.getRequest();
        if (null != request.getClient()) {
            key = request.getClient();
        } else if (null != request.getInterface()) {
            key = request.getInterface().toString();
        } else {
            return;
        }
        key = "client:" + key;
        Context ctx = login.getContext();
        if (ctx.isReadOnly()) {
            return;
        }
        User origUser = login.getUser();
        HashMap<String, Set<String>> attributes = new HashMap<String, Set<String>>();
        attributes.putAll(origUser.getAttributes());
        HashSet<String> value = new HashSet<String>();
        value.add(Long.toString(System.currentTimeMillis()));
        attributes.put(key, value);
        UserImpl newUser = new UserImpl();
        newUser.setId(origUser.getId());
        newUser.setAttributes(attributes);
        UserService service = ServerServiceRegistry.getInstance().getService(UserService.class, true);
        service.updateUser(newUser, ctx);
    }

    @Override
    public void handleLogout(LoginResult logout) {
    }
}

