/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.report.console;

import com.openexchange.report.Constants;
import edu.emory.mathcs.backport.java.util.Arrays;
import java.io.IOException;
import java.net.MalformedURLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Pattern;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public final class LoginCounterTool {
    private static final Options countingOptions = new Options();

    private LoginCounterTool() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        PosixParser parser = new PosixParser();
        Date startDate = null;
        Date endDate = null;
        try {
            String source;
            SimpleDateFormat sdf;
            CommandLine cmd;
            block24: {
                cmd = parser.parse(countingOptions, args);
                if (cmd.hasOption('h')) {
                    LoginCounterTool.printHelp();
                    System.exit(0);
                    return;
                }
                if (!cmd.hasOption('s') || !cmd.hasOption('e')) {
                    System.out.println("Parameters 'start' and 'end' are required.");
                    LoginCounterTool.printHelp();
                    System.exit(0);
                    return;
                }
                sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                source = LoginCounterTool.unquote(cmd.getOptionValue('s'));
                try {
                    startDate = sdf.parse(source);
                }
                catch (java.text.ParseException e) {
                    String input;
                    Pattern appendix;
                    if (args.length >= 6 && (appendix = Pattern.compile("[0-9]{1,2}:[0-9]{1,2}:[0-9]{1,2}")).matcher(input = LoginCounterTool.unquote(args[2])).matches()) {
                        try {
                            startDate = sdf.parse(source + " " + input);
                            input = LoginCounterTool.unquote(args[5]);
                            if (appendix.matcher(input).matches()) {
                                endDate = sdf.parse(LoginCounterTool.unquote(args[4]) + " " + input);
                            }
                        }
                        catch (java.text.ParseException pe) {
                            startDate = null;
                        }
                    }
                    if (null != startDate) break block24;
                    System.out.println("Wrong format for parameter 'start': " + source + " (specified arguments: " + Arrays.toString((Object[])args) + ")");
                    LoginCounterTool.printHelp();
                    System.exit(0);
                }
            }
            if (null == endDate) {
                source = LoginCounterTool.unquote(cmd.getOptionValue('e'));
                try {
                    endDate = sdf.parse(source);
                }
                catch (java.text.ParseException e) {
                    System.out.println("Wrong format for parameter 'end': " + source + " (specified arguments: " + Arrays.toString((Object[])args) + ")");
                    LoginCounterTool.printHelp();
                    System.exit(0);
                }
            }
            JMXServiceURL url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://localhost:9999/server");
            JMXConnector jmxConnector = JMXConnectorFactory.connect(url, null);
            try {
                MBeanServerConnection mbsc = jmxConnector.getMBeanServerConnection();
                String regex = null;
                if (cmd.hasOption('r')) {
                    regex = cmd.getOptionValue('r');
                }
                LoginCounterTool.writeNumberOfLogins(mbsc, startDate, endDate, regex);
            }
            finally {
                jmxConnector.close();
            }
        }
        catch (ParseException e) {
            System.err.println("Unable to parse command line: " + e.getMessage());
            LoginCounterTool.printHelp();
        }
        catch (MalformedURLException e) {
            System.err.println("URL to connect to server is invalid: " + e.getMessage());
        }
        catch (IOException e) {
            System.err.println("Unable to communicate with the server: " + e.getMessage());
        }
        catch (AttributeNotFoundException e) {
            System.err.println("Attributes for reporting are not available: " + e.getMessage());
        }
        catch (InstanceNotFoundException e) {
            System.err.println("Instance for reporting is not available: " + e.getMessage());
        }
        catch (MBeanException e) {
            System.err.println("Problem on MBean connection: " + e.getMessage());
        }
        catch (ReflectionException e) {
            System.err.println("Problem with reflective type handling: " + e.getMessage());
        }
        catch (InvalidAttributeValueException e) {
            System.err.println("Problem with JMX attribute: " + e.getMessage());
        }
    }

    private static void writeNumberOfLogins(MBeanServerConnection mbsc, Date startDate, Date endDate, String regex) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException {
        String withRegex = "";
        if (regex != null) {
            withRegex = withRegex + "\nfor expression\n    '" + regex + "'";
        }
        int count = 0;
        boolean err = false;
        String errMsg = null;
        try {
            mbsc.setAttribute(Constants.OXTENDER_MONITOR_NAME, new Attribute("DeviceWildcard", regex));
            count = (Integer)mbsc.invoke(Constants.OXTENDER_MONITOR_NAME, "getNumberOfLogins", new Object[]{startDate, endDate}, new String[]{Date.class.getName(), Date.class.getName()});
        }
        catch (Exception e) {
            err = true;
            errMsg = e.getMessage();
        }
        String output = err ? (errMsg != null ? errMsg : "An error occurred.") : "Number of logins between\n    " + startDate.toString() + "\nand\n    " + endDate.toString() + withRegex + "\n\n    :    " + count;
        System.out.println(output);
    }

    private static void printHelp() {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.printHelp("logincounter", countingOptions);
    }

    private static String unquote(String s) {
        int mlen;
        if (LoginCounterTool.isEmpty(s) || s.length() <= 1) {
            return s;
        }
        String retval = s;
        char c = retval.charAt(0);
        if (c == '\"' || c == '\'') {
            retval = retval.substring(1);
        }
        if ((c = retval.charAt(mlen = retval.length() - 1)) == '\"' || c == '\'') {
            retval = retval.substring(0, mlen);
        }
        return retval;
    }

    private static boolean isEmpty(String string) {
        if (null == string) {
            return true;
        }
        int len = string.length();
        boolean isWhitespace = true;
        for (int i = 0; isWhitespace && i < len; ++i) {
            isWhitespace = Character.isWhitespace(string.charAt(i));
        }
        return isWhitespace;
    }

    static {
        countingOptions.addOption("h", "help", false, "Prints a help text");
        countingOptions.addOption("s", "start", true, "Required. Sets the start date for the detecting range. Example: 2009-12-31 00:00:00");
        countingOptions.addOption("e", "end", true, "Required. Sets the end date for the detecting range. Example: 2010-01-1 23:59:59");
        countingOptions.addOption("r", "regex", true, "Optional. Limits the counter to login devices that match regex.");
    }
}

