/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.pooling;

import com.openexchange.log.LogFactory;
import com.openexchange.pooling.Pool;
import com.openexchange.pooling.PoolImplData;
import com.openexchange.pooling.PoolableLifecycle;
import com.openexchange.pooling.PooledData;
import com.openexchange.pooling.PoolingException;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.threadpool.ThreadPoolService;
import com.openexchange.threadpool.ThreadPools;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;

public class SynchronizedPool<T>
implements Pool<T>,
Runnable {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(SynchronizedPool.class));
    private final int minIdle;
    private final int maxIdle;
    private final long maxIdleTime;
    private final int maxActive;
    private final long maxWait;
    private ExhaustedActions exhaustedAction;
    private final boolean testOnActivate;
    private final boolean testOnDeactivate;
    private final boolean testOnIdle;
    private final boolean testThreads;
    private boolean running = true;
    private final int timeBetweenIdleRun = 60000;
    private final PoolImplData<T> data = new PoolImplData();
    private final PoolableLifecycle<T> lifecycle;
    private long maxUseTime;
    private long minUseTime = Long.MAX_VALUE;
    private int numBroken;
    private final TimerTask cleaner = new TimerTask(){

        @Override
        public void run() {
            try {
                ThreadPoolService poolService = ServerServiceRegistry.getInstance().getService(ThreadPoolService.class);
                poolService.submit(ThreadPools.task((Runnable)SynchronizedPool.this, (String)"PoolCleaner"));
            }
            catch (Exception e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    };
    private static final Config DEFAULT_CONFIG = new Config();

    public SynchronizedPool(PoolableLifecycle<T> lifecycle) {
        this(lifecycle, DEFAULT_CONFIG);
    }

    public SynchronizedPool(PoolableLifecycle<T> lifecycle, Config config) {
        this.minIdle = config.minIdle;
        this.maxIdle = config.maxIdle;
        this.maxIdleTime = config.maxIdleTime;
        this.maxActive = config.maxActive;
        this.maxWait = config.maxWait;
        this.exhaustedAction = config.exhaustedAction;
        this.testOnActivate = config.testOnActivate;
        this.testOnDeactivate = config.testOnDeactivate;
        this.testOnIdle = config.testOnIdle;
        this.testThreads = config.testThreads;
        this.lifecycle = lifecycle;
        try {
            this.ensureMinIdle();
        }
        catch (PoolingException e) {
            LOG.error((Object)"Problem while creating initial objects.", (Throwable)e);
        }
    }

    public ExhaustedActions getExhaustedAction() {
        return this.exhaustedAction;
    }

    public void setExhaustedAction(ExhaustedActions exhaustedAction) {
        this.exhaustedAction = exhaustedAction;
    }

    @Override
    public void back(T pooled) throws PoolingException {
        if (null == pooled) {
            throw new NullPointerException("A null object was returned to pool.");
        }
        this.back(pooled, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void back(T pooled, boolean decrementActive) throws PoolingException {
        PooledData<T> metaData = decrementActive ? this.data.getActive(pooled) : new PooledData<T>(pooled);
        if (null == metaData) {
            throw new PoolingException("Object does not belong to this pool.");
        }
        boolean poolable = this.running && this.testOnDeactivate && !this.lifecycle.validate(metaData) ? false : this.lifecycle.deactivate(metaData);
        if (this.testThreads) {
            PoolImplData<T> poolImplData = this.data;
            synchronized (poolImplData) {
                this.data.removeByThread(metaData);
            }
        }
        metaData.resetTrace();
        metaData.touch();
        boolean destroy = !poolable;
        PoolImplData<T> poolImplData = this.data;
        synchronized (poolImplData) {
            if (decrementActive) {
                this.data.removeActive(metaData);
            }
            this.data.notifyAll();
            if (this.maxIdle > 0 && this.data.numIdle() >= this.maxIdle) {
                destroy = true;
            } else if (poolable) {
                this.data.addIdle(metaData);
            }
        }
        if (destroy) {
            this.lifecycle.destroy(metaData.getPooled());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() throws PoolingException {
        long startTime = System.currentTimeMillis();
        block18: while (this.running) {
            PooledData<T> retval;
            boolean created = false;
            PoolImplData<T> poolImplData = this.data;
            synchronized (poolImplData) {
                Thread thread;
                PooledData<T> other;
                if (this.testThreads && (other = this.data.getByThread(thread = Thread.currentThread())) != null && thread.equals(other.getThread())) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Found thread using two objects: \n");
                    this.createStackTrace(sb, other.getTrace());
                    sb.append('\n');
                    this.createStackTrace(sb, thread.getStackTrace());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)sb.toString());
                    }
                }
                if (null == (retval = this.data.popIdle()) && this.maxActive > 0 && this.data.numActive() >= this.maxActive) {
                    switch (this.exhaustedAction) {
                        case GROW: {
                            break;
                        }
                        case FAIL: {
                            throw new PoolingException("Pool exhausted.");
                        }
                        case BLOCK: {
                            try {
                                if (this.maxWait > 0L) {
                                    this.data.wait(SynchronizedPool.getWaitTime(startTime));
                                } else {
                                    this.data.wait();
                                }
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                                this.data.notifyAll();
                            }
                            if (this.maxWait > 0L && SynchronizedPool.getWaitTime(startTime) > this.maxWait) {
                                this.data.notifyAll();
                                throw new PoolingException("Wait time exceeded. Active: " + this.data.numActive() + ", Idle: " + this.data.numIdle() + ", Waiting: " + ", Time: " + SynchronizedPool.getWaitTime(startTime));
                            }
                            continue block18;
                        }
                        default: {
                            throw new IllegalStateException("Unknown exhausted action: " + (Object)((Object)this.exhaustedAction));
                        }
                    }
                }
                if (null == retval) {
                    T pooled;
                    try {
                        pooled = this.lifecycle.create();
                    }
                    catch (Exception e) {
                        this.data.notifyAll();
                        throw new PoolingException("Cannot create pooled object.", e);
                    }
                    retval = new PooledData<T>(pooled);
                    this.data.addActive(retval);
                    created = true;
                }
            }
            if (!this.lifecycle.activate(retval) || this.testOnActivate && !this.lifecycle.validate(retval)) {
                poolImplData = this.data;
                synchronized (poolImplData) {
                    this.data.removeActive(retval);
                    this.data.notifyAll();
                }
                this.lifecycle.destroy(retval.getPooled());
                if (!created) continue;
                throw new PoolingException("Problem while creating new object.");
            }
            Thread thread = Thread.currentThread();
            retval.setThread(thread);
            retval.setTrace(thread.getStackTrace());
            retval.touch();
            if (this.testThreads) {
                PoolImplData<T> poolImplData2 = this.data;
                synchronized (poolImplData2) {
                    this.data.addByThread(retval);
                }
            }
            return retval.getPooled();
        }
        throw new PoolingException("Pool has been stopped.");
    }

    private static final long getWaitTime(long startTime) {
        return System.currentTimeMillis() - startTime;
    }

    @Override
    public void destroy() {
        this.running = false;
        this.cleaner.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        PoolImplData<T> poolImplData = this.data;
        synchronized (poolImplData) {
            return this.data.isIdleEmpty() && this.data.isActiveEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumIdle() {
        PoolImplData<T> poolImplData = this.data;
        synchronized (poolImplData) {
            return this.data.numIdle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumActive() {
        PoolImplData<T> poolImplData = this.data;
        synchronized (poolImplData) {
            return this.data.numActive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPoolSize() {
        PoolImplData<T> poolImplData = this.data;
        synchronized (poolImplData) {
            return this.data.numActive() + this.data.numIdle();
        }
    }

    public int numWaiting() {
        return -1;
    }

    @Override
    public long getMaxUseTime() {
        return this.maxUseTime;
    }

    @Override
    public long getMinUseTime() {
        return this.minUseTime;
    }

    @Override
    public int getNumBroken() {
        return this.numBroken;
    }

    @Override
    public void resetMaxUseTime() {
        this.maxUseTime = 0L;
    }

    @Override
    public void resetMinUseTime() {
        this.minUseTime = Long.MAX_VALUE;
    }

    public void registerCleaner(Timer timer) {
        timer.scheduleAtFixedRate(this.getCleanerTask(), 60000L, 60000L);
    }

    public TimerTask getCleanerTask() {
        return this.cleaner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isBelowMinIdle() {
        int numActive;
        int numIdle;
        PoolImplData<T> poolImplData = this.data;
        synchronized (poolImplData) {
            numIdle = this.data.numIdle();
            numActive = this.data.numActive();
        }
        int maxCreate = Math.max(0, this.maxActive - numActive - numIdle);
        return Math.min(this.minIdle - numIdle, maxCreate) > 0;
    }

    private void ensureMinIdle() throws PoolingException {
        while (this.isBelowMinIdle()) {
            this.createObject();
        }
    }

    private void createObject() throws PoolingException {
        T pooled;
        try {
            pooled = this.lifecycle.create();
        }
        catch (Exception e) {
            throw new PoolingException("Cannot create pooled object.", e);
        }
        this.back(pooled, false);
    }

    private void createStackTrace(StringBuilder sb, StackTraceElement[] trace) {
        for (StackTraceElement e : trace) {
            sb.append("\tat ");
            sb.append(e);
            sb.append('\n');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"Starting cleaner run.");
        }
        PoolImplData<T> poolImplData = this.data;
        synchronized (poolImplData) {
            try {
                PooledData<T> metaData;
                int idleSize = this.data.numIdle();
                boolean remove = true;
                int index = 0;
                while (remove && index < idleSize) {
                    metaData = this.data.getIdle(index);
                    boolean bl = remove = this.maxIdleTime > 0L && metaData.getTimeDiff() > this.maxIdleTime || this.testOnIdle && (!this.lifecycle.activate(metaData) || !this.lifecycle.validate(metaData) || !this.lifecycle.deactivate(metaData));
                    if (remove) {
                        this.data.removeIdle(index);
                        idleSize = this.data.numIdle();
                        this.lifecycle.destroy(metaData.getPooled());
                        continue;
                    }
                    ++index;
                }
                this.ensureMinIdle();
                if (this.testThreads) {
                    Iterator<PooledData<T>> iter = this.data.listActive();
                    while (iter.hasNext()) {
                        metaData = iter.next();
                        if (metaData.getTimeDiff() <= this.maxIdleTime) continue;
                        StringBuilder sb = new StringBuilder();
                        sb.append("Object was not returned. Fetched: ");
                        sb.append(metaData.getTimestamp());
                        sb.append('\n');
                        this.createStackTrace(sb, metaData.getTrace());
                        LOG.error((Object)sb.toString());
                        iter.remove();
                        this.data.notifyAll();
                    }
                }
            }
            catch (PoolingException e) {
                LOG.error((Object)"Housekeeping problem.", (Throwable)e);
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"Clean run ending.");
        }
    }

    static {
        SynchronizedPool.DEFAULT_CONFIG.minIdle = 0;
        SynchronizedPool.DEFAULT_CONFIG.maxIdle = -1;
        SynchronizedPool.DEFAULT_CONFIG.maxIdleTime = 60000L;
        SynchronizedPool.DEFAULT_CONFIG.maxActive = -1;
        SynchronizedPool.DEFAULT_CONFIG.maxWait = 10000L;
        SynchronizedPool.DEFAULT_CONFIG.exhaustedAction = ExhaustedActions.GROW;
        SynchronizedPool.DEFAULT_CONFIG.testOnActivate = true;
        SynchronizedPool.DEFAULT_CONFIG.testOnDeactivate = true;
        SynchronizedPool.DEFAULT_CONFIG.testOnIdle = false;
        SynchronizedPool.DEFAULT_CONFIG.testThreads = false;
    }

    public static class Config {
        public int minIdle;
        public int maxIdle;
        public long maxIdleTime;
        public int maxActive;
        public long maxWait;
        public ExhaustedActions exhaustedAction;
        public boolean testOnActivate;
        public boolean testOnDeactivate;
        public boolean testOnIdle;
        public boolean testThreads;
    }

    public static enum ExhaustedActions {
        FAIL,
        BLOCK,
        GROW;

    }
}

