/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mailaccount;

import com.openexchange.exception.OXException;
import com.openexchange.java.StringAllocator;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.mailaccount.MailAccountExceptionCodes;
import com.openexchange.tools.net.URIDefaults;
import com.openexchange.tools.net.URIParser;
import com.openexchange.tools.net.URITools;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.mail.internet.idn.IDNA;

public final class MailAccountDescription
implements Serializable {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(MailAccountDescription.class));
    private static final long serialVersionUID = -2443656355399068302L;
    private int id = -1;
    private String login;
    private String password;
    private String transportLogin;
    private String transportPassword;
    private String name;
    private String primaryAddress;
    private String personal;
    private String replyTo;
    private String spamHandler;
    private String trash;
    private String sent;
    private String drafts;
    private String spam;
    private String confirmedSpam;
    private String confirmedHam;
    private boolean defaultFlag;
    private String mailServer;
    private int mailPort = 143;
    private String mailProtocol = "imap";
    private boolean mailSecure;
    private String transportServer;
    private int transportPort = 25;
    private String transportProtocol = "smtp";
    private boolean transportSecure;
    private String mailServerUrl;
    private String transportUrl;
    private boolean unifiedINBOXEnabled;
    private String trashFullname;
    private String sentFullname;
    private String draftsFullname;
    private String spamFullname;
    private String confirmedSpamFullname;
    private String confirmedHamFullname;
    private Map<String, String> properties = new HashMap<String, String>(4);

    public int getId() {
        return this.id;
    }

    public String getLogin() {
        return this.login;
    }

    public String getName() {
        return this.name;
    }

    public String getPassword() {
        return this.password;
    }

    public String getPrimaryAddress() {
        return this.primaryAddress;
    }

    public String getPersonal() {
        return this.personal;
    }

    public String getReplyTo() {
        if (MailAccountDescription.isEmpty(this.replyTo)) {
            return this.properties.get("replyto");
        }
        return this.replyTo;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getMailServer() {
        return this.mailServer;
    }

    public int getMailPort() {
        return this.mailPort;
    }

    public String getMailProtocol() {
        return this.mailProtocol;
    }

    public boolean isMailSecure() {
        return this.mailSecure;
    }

    public void setMailServer(String mailServer) {
        this.mailServerUrl = null;
        this.mailServer = mailServer == null ? null : IDNA.toUnicode((String)mailServer);
    }

    public void setMailPort(int mailPort) {
        this.mailServerUrl = null;
        this.mailPort = mailPort;
    }

    public void setMailProtocol(String mailProtocol) {
        this.mailServerUrl = null;
        this.mailProtocol = mailProtocol;
    }

    public void setMailSecure(boolean mailSecure) {
        this.mailServerUrl = null;
        this.mailSecure = mailSecure;
    }

    public String getTransportServer() {
        return this.transportServer;
    }

    public int getTransportPort() {
        return this.transportPort;
    }

    public String getTransportProtocol() {
        return this.transportProtocol;
    }

    public boolean isTransportSecure() {
        return this.transportSecure;
    }

    public void setTransportServer(String transportServer) {
        this.transportUrl = null;
        this.transportServer = transportServer == null ? null : IDNA.toUnicode((String)transportServer);
    }

    public void setTransportPort(int transportPort) {
        this.transportUrl = null;
        this.transportPort = MailAccountDescription.checkTransportPort(transportPort);
    }

    public void setTransportProtocol(String transportProtocol) {
        this.transportUrl = null;
        this.transportProtocol = transportProtocol;
    }

    public void setTransportSecure(boolean transportSecure) {
        this.transportUrl = null;
        this.transportSecure = transportSecure;
    }

    public String generateMailServerURL() throws OXException {
        if (null != this.mailServerUrl) {
            return this.mailServerUrl;
        }
        if (MailAccountDescription.isEmpty(this.mailServer)) {
            return null;
        }
        try {
            this.mailServerUrl = URITools.generateURI(this.mailSecure ? this.mailProtocol + 's' : this.mailProtocol, IDNA.toASCII((String)this.mailServer), this.mailPort).toString();
            return this.mailServerUrl;
        }
        catch (URISyntaxException e) {
            StringAllocator sb = new StringAllocator(32);
            sb.append(this.mailProtocol);
            if (this.mailSecure) {
                sb.append('s');
            }
            throw MailAccountExceptionCodes.INVALID_HOST_NAME.create(e, sb.append("://").append(this.mailServer).append(':').append(this.mailPort).toString());
        }
    }

    public void parseMailServerURL(String mailServerURL) throws OXException {
        if (null == mailServerURL) {
            this.setMailServer((String)null);
            return;
        }
        try {
            this.setMailServer(URIParser.parse(IDNA.toASCII((String)mailServerURL), URIDefaults.IMAP));
        }
        catch (URISyntaxException e) {
            throw MailAccountExceptionCodes.INVALID_HOST_NAME.create(e, mailServerURL);
        }
    }

    public void setMailServer(URI mailServer) {
        if (null == mailServer) {
            this.setMailServer("");
        } else {
            String protocol = mailServer.getScheme();
            if (protocol.endsWith("s")) {
                this.setMailSecure(true);
                this.setMailProtocol(protocol.substring(0, protocol.length() - 1));
            } else {
                this.setMailSecure(false);
                this.setMailProtocol(protocol);
            }
            this.setMailServer(mailServer.getHost());
            this.setMailPort(mailServer.getPort());
        }
    }

    public void parseTransportServerURL(String transportServerURL) throws OXException {
        if (null == transportServerURL) {
            this.setTransportServer((String)null);
            return;
        }
        try {
            this.setTransportServer(URIParser.parse(IDNA.toASCII((String)transportServerURL), URIDefaults.SMTP));
        }
        catch (URISyntaxException e) {
            throw MailAccountExceptionCodes.INVALID_HOST_NAME.create(e, transportServerURL);
        }
    }

    public void setTransportServer(URI transportServer) {
        if (null == transportServer) {
            this.setTransportServer("");
        } else {
            String protocol = transportServer.getScheme();
            if (protocol.endsWith("s")) {
                this.setTransportSecure(true);
                this.setTransportProtocol(protocol.substring(0, protocol.length() - 1));
            } else {
                this.setTransportSecure(false);
                this.setTransportProtocol(protocol);
            }
            this.setTransportServer(URITools.getHost(transportServer));
            this.setTransportPort(transportServer.getPort());
        }
    }

    private static int checkTransportPort(int port) {
        if (URIDefaults.IMAP.getPort() == port) {
            return URIDefaults.SMTP.getPort();
        }
        if (URIDefaults.IMAP.getSSLPort() == port) {
            return URIDefaults.SMTP.getSSLPort();
        }
        return port;
    }

    public String generateTransportServerURL() throws OXException {
        if (null != this.transportUrl) {
            return this.transportUrl;
        }
        if (MailAccountDescription.isEmpty(this.transportServer)) {
            return null;
        }
        String protocol = this.transportSecure ? this.transportProtocol + 's' : this.transportProtocol;
        try {
            this.transportUrl = URITools.generateURI(protocol, IDNA.toASCII((String)this.transportServer), this.transportPort).toString();
            return this.transportUrl;
        }
        catch (URISyntaxException e) {
            StringAllocator sb = new StringAllocator(32);
            sb.append(this.transportProtocol);
            if (this.transportSecure) {
                sb.append('s');
            }
            throw MailAccountExceptionCodes.INVALID_HOST_NAME.create(e, sb.append("://").append(this.transportServer).append(':').append(this.mailPort).toString());
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPrimaryAddress(String primaryAddress) {
        this.primaryAddress = primaryAddress;
    }

    public void setPersonal(String personal) {
        this.personal = personal;
    }

    public void setReplyTo(String replyTo) {
        this.replyTo = replyTo;
        if (MailAccountDescription.isEmpty(replyTo)) {
            this.properties.remove("replyto");
        } else {
            this.properties.put("replyto", replyTo);
        }
    }

    public String getDrafts() {
        return this.drafts;
    }

    public String getSent() {
        return this.sent;
    }

    public String getSpam() {
        return this.spam;
    }

    public String getTrash() {
        return this.trash;
    }

    public String getConfirmedHam() {
        return this.confirmedHam;
    }

    public String getConfirmedSpam() {
        return this.confirmedSpam;
    }

    public String getSpamHandler() {
        return this.spamHandler;
    }

    public void setTrash(String trash) {
        this.trash = trash;
    }

    public void setSent(String sent) {
        this.sent = sent;
    }

    public void setDrafts(String drafts) {
        this.drafts = drafts;
    }

    public void setSpam(String spam) {
        this.spam = spam;
    }

    public void setConfirmedSpam(String confirmedSpam) {
        this.confirmedSpam = confirmedSpam;
    }

    public void setConfirmedHam(String confirmedHam) {
        this.confirmedHam = confirmedHam;
    }

    public void setSpamHandler(String spamHandler) {
        this.spamHandler = spamHandler;
    }

    public boolean isDefaultFlag() {
        return this.defaultFlag;
    }

    public void setDefaultFlag(boolean defaultFlag) {
        this.defaultFlag = defaultFlag;
    }

    public String getTransportLogin() {
        return this.transportLogin;
    }

    public String getTransportPassword() {
        return this.transportPassword;
    }

    public void setTransportLogin(String transportLogin) {
        this.transportLogin = transportLogin;
    }

    public void setTransportPassword(String transportPassword) {
        this.transportPassword = transportPassword;
    }

    public boolean isUnifiedINBOXEnabled() {
        return this.unifiedINBOXEnabled;
    }

    public void setUnifiedINBOXEnabled(boolean unifiedINBOXEnabled) {
        this.unifiedINBOXEnabled = unifiedINBOXEnabled;
    }

    public String getTrashFullname() {
        return this.trashFullname;
    }

    public void setTrashFullname(String trashFullname) {
        this.trashFullname = trashFullname;
    }

    public String getSentFullname() {
        return this.sentFullname;
    }

    public void setSentFullname(String sentFullname) {
        this.sentFullname = sentFullname;
    }

    public String getDraftsFullname() {
        return this.draftsFullname;
    }

    public void setDraftsFullname(String draftsFullname) {
        this.draftsFullname = draftsFullname;
    }

    public String getSpamFullname() {
        return this.spamFullname;
    }

    public void setSpamFullname(String spamFullname) {
        this.spamFullname = spamFullname;
    }

    public String getConfirmedSpamFullname() {
        return this.confirmedSpamFullname;
    }

    public void setConfirmedSpamFullname(String confirmedSpamFullname) {
        this.confirmedSpamFullname = confirmedSpamFullname;
    }

    public String getConfirmedHamFullname() {
        return this.confirmedHamFullname;
    }

    public void setConfirmedHamFullname(String confirmedHamFullname) {
        this.confirmedHamFullname = confirmedHamFullname;
    }

    public Map<String, String> getProperties() {
        if (this.properties.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> clone = new HashMap<String, String>(this.properties.size());
        clone.putAll(this.properties);
        if (null != this.replyTo) {
            clone.put("replyto", this.replyTo);
        }
        return clone;
    }

    public void setProperties(Map<String, String> properties) {
        if (null == properties) {
            this.properties = new HashMap<String, String>(4);
        } else if (properties.isEmpty()) {
            this.properties = new HashMap<String, String>(4);
        } else {
            for (Map.Entry<String, String> e : properties.entrySet()) {
                if (!"replyto".equals(e.getKey())) continue;
                this.replyTo = e.getValue();
                break;
            }
            this.properties = new HashMap<String, String>(properties.size());
            this.properties.putAll(properties);
        }
    }

    public void addProperty(String name, String value) {
        if (this.properties.isEmpty()) {
            this.properties = new HashMap<String, String>(4);
        }
        if ("replyto".equals(name)) {
            this.replyTo = value;
        }
        this.properties.put(name, value);
    }

    private static Object[] parseServerAndPort(String server, int defaultPort) {
        int port;
        int pos = server.indexOf(58);
        if (pos == -1) {
            return new Object[]{server, defaultPort};
        }
        try {
            port = Integer.parseInt(server.substring(pos + 1));
        }
        catch (NumberFormatException e) {
            LOG.warn((Object)("Unable to parse port out of URL: " + server + ". Using default port instead: " + defaultPort), (Throwable)e);
            port = defaultPort;
        }
        return new Object[]{server.subSequence(0, pos), port};
    }

    private static boolean isEmpty(String string) {
        if (null == string) {
            return true;
        }
        char[] chars = string.toCharArray();
        boolean isWhitespace = true;
        for (int i = 0; isWhitespace && i < chars.length; ++i) {
            isWhitespace = Character.isWhitespace(chars[i]);
        }
        return isWhitespace;
    }
}

