/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.mime.processing;

import com.openexchange.config.ConfigurationService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.i18n.tools.StringHelper;
import com.openexchange.java.StringAllocator;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailPath;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.dataobjects.CompositeMailMessage;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.mime.ManagedMimeMessage;
import com.openexchange.mail.mime.MimeDefaultSession;
import com.openexchange.mail.mime.MimeMailException;
import com.openexchange.mail.mime.QuotedInternetAddress;
import com.openexchange.mail.mime.converters.MimeMessageConverter;
import com.openexchange.mail.mime.dataobjects.MimeMailMessage;
import com.openexchange.mail.mime.dataobjects.NestedMessageMailPart;
import com.openexchange.mail.mime.datasource.StreamDataSource;
import com.openexchange.mail.mime.filler.MimeMessageFiller;
import com.openexchange.mail.mime.processing.LocaleAndTimeZone;
import com.openexchange.mail.mime.processing.MimeProcessingUtility;
import com.openexchange.mail.mime.utils.MimeMessageUtility;
import com.openexchange.mail.parser.MailMessageParser;
import com.openexchange.mail.parser.handlers.NonInlineForwardPartHandler;
import com.openexchange.mail.text.HtmlProcessing;
import com.openexchange.mail.usersetting.UserSettingMail;
import com.openexchange.mail.usersetting.UserSettingMailStorage;
import com.openexchange.mail.utils.MessageUtility;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.regex.MatcherReplacer;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.stream.UnsynchronizedByteArrayInputStream;
import com.openexchange.tools.stream.UnsynchronizedByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.logging.Log;

public final class MimeForward {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(MimeForward.class));
    private static final String PREFIX_FWD = "Fwd: ";
    private static final String MULTIPART = "multipart/";
    private static final String TEXT = "text/";
    private static final String TEXT_HTM = "text/htm";
    private static final Pattern PAT_META_CT = Pattern.compile("<meta[^>]*?http-equiv=\"?content-type\"?[^>]*?>", 2);
    private static final Pattern PATTERN_BODY = Pattern.compile("<body[^>]*?>", 2);
    private static final Pattern PATTERN_FROM = Pattern.compile(Pattern.quote("#FROM#"));
    private static final Pattern PATTERN_TO = Pattern.compile(Pattern.quote("#TO#"));
    private static final Pattern PATTERN_CCLINE = Pattern.compile(Pattern.quote("#CC_LINE#"));
    private static final Pattern PATTERN_DATE = Pattern.compile(Pattern.quote("#DATE#"));
    private static final Pattern PATTERN_TIME = Pattern.compile(Pattern.quote("#TIME#"));
    private static final Pattern PATTERN_SUBJECT = Pattern.compile(Pattern.quote("#SUBJECT#"));
    private static final Pattern PATTERN_HTML_START = Pattern.compile("<html[^>]*?>", 2);
    private static final Pattern PATTERN_HTML_END = Pattern.compile("</html>", 2);
    private static final String BLOCKQUOTE_START = "<blockquote type=\"cite\" style=\"position: relative; margin-left: 0px; padding-left: 10px; border-left: solid 1px blue;\">\n";
    private static final String BLOCKQUOTE_END = "</blockquote>\n<br>&nbsp;";

    private MimeForward() {
    }

    public static MailMessage getFowardMail(MailMessage[] originalMails, Session session, int accountID) throws OXException {
        return MimeForward.getFowardMail(originalMails, session, accountID, null);
    }

    public static MailMessage getFowardMail(MailMessage[] originalMails, Session session, int accountID, UserSettingMail usm) throws OXException {
        for (int i = 0; i < originalMails.length; ++i) {
            MailMessage cur = originalMails[i];
            if (cur.getMailId() == null || cur.getFolder() == null || cur.getAccountId() == accountID) continue;
            cur.setAccountId(accountID);
        }
        return MimeForward.getFowardMail0(originalMails, session, usm);
    }

    public static MailMessage getFowardMail(MailMessage[] originalMails, Session session, int[] accountIDs, UserSettingMail usm) throws OXException {
        for (int i = 0; i < originalMails.length; ++i) {
            MailMessage cur = originalMails[i];
            if (cur.getMailId() == null || cur.getFolder() == null || cur.getAccountId() == accountIDs[i]) continue;
            cur.setAccountId(accountIDs[i]);
        }
        return MimeForward.getFowardMail0(originalMails, session, usm);
    }

    private static MailMessage getFowardMail0(MailMessage[] originalMsgs, Session session, UserSettingMail userSettingMail) throws OXException {
        try {
            User[] users;
            MailMessage originalMsg;
            String owner;
            MailMessage[] origMsgs = ManagedMimeMessage.clone(originalMsgs);
            Context ctx = ContextStorage.getStorageContext(session.getContextId());
            UserSettingMail usm = userSettingMail == null ? UserSettingMailStorage.getInstance().getUserSettingMail(session.getUserId(), ctx) : userSettingMail;
            MimeMessage forwardMsg = new MimeMessage(MimeDefaultSession.getDefaultSession());
            String subjectPrefix = PREFIX_FWD;
            String origSubject = MimeMessageUtility.checkNonAscii(origMsgs[0].getHeader("Subject", null));
            if (origSubject == null) {
                forwardMsg.setSubject(PREFIX_FWD, MailProperties.getInstance().getDefaultMimeCharset());
            } else {
                String subject = MimeMessageUtility.decodeMultiEncodedHeader((origSubject = MimeMessageUtility.unfold(origSubject)).regionMatches(true, 0, PREFIX_FWD, 0, PREFIX_FWD.length()) ? origSubject : new StringAllocator(PREFIX_FWD.length() + origSubject.length()).append(PREFIX_FWD).append(origSubject).toString());
                forwardMsg.setSubject(subject, MailProperties.getInstance().getDefaultMimeCharset());
            }
            if (usm.getSendAddr() != null) {
                forwardMsg.setFrom((Address)new QuotedInternetAddress(usm.getSendAddr(), true));
            }
            if (usm.isForwardAsAttachment() || origMsgs.length > 1) {
                if (1 == origMsgs.length && null != (owner = MimeProcessingUtility.getFolderOwnerIfShared((originalMsg = origMsgs[0]).getFolder(), originalMsg.getAccountId(), session)) && null != (users = UserStorage.getInstance().searchUserByMailLogin(owner, ctx)) && users.length > 0) {
                    QuotedInternetAddress onBehalfOf = new QuotedInternetAddress(users[0].getMail(), true);
                    forwardMsg.setFrom((Address)onBehalfOf);
                    QuotedInternetAddress sender = new QuotedInternetAddress(usm.getSendAddr(), true);
                    forwardMsg.setSender((Address)sender);
                }
                return MimeForward.asAttachmentForward(origMsgs, forwardMsg);
            }
            originalMsg = origMsgs[0];
            owner = MimeProcessingUtility.getFolderOwnerIfShared(originalMsg.getFolder(), originalMsg.getAccountId(), session);
            if (null != owner && null != (users = UserStorage.getInstance().searchUserByMailLogin(owner, ctx)) && users.length > 0) {
                QuotedInternetAddress onBehalfOf = new QuotedInternetAddress(users[0].getMail(), true);
                forwardMsg.setFrom((Address)onBehalfOf);
                QuotedInternetAddress sender = new QuotedInternetAddress(usm.getSendAddr(), true);
                forwardMsg.setSender((Address)sender);
            }
            return MimeForward.asInlineForward(originalMsg, session, ctx, usm, forwardMsg);
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
        catch (IOException e) {
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
        catch (OXException e) {
            throw new OXException(e);
        }
    }

    private static String replaceMetaEquiv(String html, ContentType contentType) {
        Matcher m = PAT_META_CT.matcher(html);
        MatcherReplacer mr = new MatcherReplacer(m, html);
        StringBuilder replaceBuffer = new StringBuilder(html.length());
        if (m.find()) {
            replaceBuffer.append("<meta content=\"").append(contentType.getBaseType().toLowerCase(Locale.ENGLISH));
            replaceBuffer.append("; charset=").append(contentType.getCharsetParameter()).append("\" http-equiv=\"Content-Type\" />");
            String replacement = replaceBuffer.toString();
            replaceBuffer.setLength(0);
            mr.appendLiteralReplacement(replaceBuffer, replacement);
        }
        mr.appendTail(replaceBuffer);
        return replaceBuffer.toString();
    }

    private static MailMessage asInlineForward(final MailMessage originalMsg, Session session, Context ctx, UserSettingMail usm, MimeMessage forwardMsg) throws OXException, MessagingException, IOException {
        MailMessage forwardMail;
        MailPath msgref = originalMsg.getMailPath();
        ContentType originalContentType = originalMsg.getContentType();
        if (originalContentType.startsWith(MULTIPART)) {
            MimeMultipart multipart = new MimeMultipart();
            List<String> contentIds = null;
            ContentType contentType = new ContentType();
            String firstSeenText = MimeForward.getFirstSeenText(originalMsg, contentType, usm);
            String cs = contentType.getCharsetParameter();
            if (cs == null || "US-ASCII".equalsIgnoreCase(cs)) {
                contentType.setCharsetParameter(MailProperties.getInstance().getDefaultMimeCharset());
            }
            boolean isHtml = contentType.startsWith(TEXT_HTM);
            if (null == firstSeenText) {
                firstSeenText = "";
            } else if (isHtml) {
                contentIds = MimeMessageUtility.getContentIDs(firstSeenText);
                contentType.setCharsetParameter("UTF-8");
                firstSeenText = MimeForward.replaceMetaEquiv(firstSeenText, contentType);
            }
            MimeBodyPart textPart = new MimeBodyPart();
            textPart.setText(usm.isDropReplyForwardPrefix() ? firstSeenText : MimeForward.generateForwardText(firstSeenText, new LocaleAndTimeZone(MimeForward.getUser(session, ctx)), originalMsg, isHtml), contentType.getCharsetParameter(), contentType.getSubType());
            textPart.setHeader("MIME-Version", "1.0");
            textPart.setHeader("Content-Type", MimeMessageUtility.foldContentType(contentType.toString()));
            multipart.addBodyPart((BodyPart)textPart);
            forwardMsg.setContent((Multipart)multipart);
            forwardMsg.saveChanges();
            forwardMsg.removeHeader("Message-ID");
            MimeMessageFiller.setReplyHeaders(originalMsg, forwardMsg);
            CompositeMailMessage compositeMail = new CompositeMailMessage(MimeMessageConverter.convertMessage(forwardMsg));
            NonInlineForwardPartHandler handler = new NonInlineForwardPartHandler();
            if (null != contentIds && !contentIds.isEmpty()) {
                handler.setImageContentIds(contentIds);
            }
            new MailMessageParser().setInlineDetectorBehavior(true).parseMailMessage(originalMsg, handler);
            for (MailPart mailPart : handler.getNonInlineParts()) {
                mailPart.getContentDisposition().setDisposition("attachment");
                compositeMail.addAdditionalParts(mailPart);
            }
            forwardMail = compositeMail;
        } else if (originalContentType.startsWith(TEXT) && !MimeProcessingUtility.isSpecial(originalContentType.getBaseType())) {
            String cs = originalContentType.getCharsetParameter();
            if (null == cs) {
                originalContentType.setCharsetParameter(MessageUtility.checkCharset(originalMsg, originalContentType));
            }
            String content = MimeProcessingUtility.readContent(originalMsg, originalContentType.getCharsetParameter());
            if (originalContentType.startsWith(TEXT_HTM)) {
                originalContentType.setCharsetParameter("UTF-8");
                content = MimeForward.replaceMetaEquiv(content, originalContentType);
            }
            forwardMsg.setText(usm.isDropReplyForwardPrefix() ? (content == null ? "" : content) : MimeForward.generateForwardText(content == null ? "" : content, new LocaleAndTimeZone(MimeForward.getUser(session, ctx)), originalMsg, originalContentType.startsWith(TEXT_HTM)), originalContentType.getCharsetParameter(), originalContentType.getSubType());
            forwardMsg.setHeader("MIME-Version", "1.0");
            forwardMsg.setHeader("Content-Type", MimeMessageUtility.foldContentType(originalContentType.toString()));
            forwardMsg.saveChanges();
            forwardMsg.removeHeader("Message-ID");
            MimeMessageFiller.setReplyHeaders(originalMsg, forwardMsg);
            forwardMail = MimeMessageConverter.convertMessage(forwardMsg);
        } else {
            MimeMultipart multipart = new MimeMultipart();
            ContentType contentType = new ContentType("text/plain");
            contentType.setCharsetParameter(MailProperties.getInstance().getDefaultMimeCharset());
            MimeBodyPart textPart = new MimeBodyPart();
            textPart.setText(usm.isDropReplyForwardPrefix() ? "" : MimeForward.generateForwardText("", new LocaleAndTimeZone(MimeForward.getUser(session, ctx)), originalMsg, false), MailProperties.getInstance().getDefaultMimeCharset(), "plain");
            textPart.setHeader("MIME-Version", "1.0");
            textPart.setHeader("Content-Type", MimeMessageUtility.foldContentType(contentType.toString()));
            multipart.addBodyPart((BodyPart)textPart);
            forwardMsg.setContent((Multipart)multipart);
            forwardMsg.saveChanges();
            forwardMsg.removeHeader("Message-ID");
            MimeMessageFiller.setReplyHeaders(originalMsg, forwardMsg);
            CompositeMailMessage compositeMail = new CompositeMailMessage(MimeMessageConverter.convertMessage(forwardMsg));
            MimeBodyPart attachmentPart = new MimeBodyPart();
            StreamDataSource.InputStreamProvider isp = new StreamDataSource.InputStreamProvider(){

                @Override
                public InputStream getInputStream() throws IOException {
                    try {
                        return originalMsg.getInputStream();
                    }
                    catch (OXException e) {
                        IOException io = new IOException(e.getMessage());
                        io.initCause(e);
                        throw io;
                    }
                }

                @Override
                public String getName() {
                    return null;
                }
            };
            attachmentPart.setDataHandler(new DataHandler((DataSource)new StreamDataSource(isp, originalContentType.toString())));
            Iterator<Map.Entry<String, String>> e = originalMsg.getHeadersIterator();
            while (e.hasNext()) {
                Map.Entry<String, String> header = e.next();
                String name = header.getKey();
                if (!name.toLowerCase(Locale.ENGLISH).startsWith("content-")) continue;
                attachmentPart.addHeader(name, header.getValue());
            }
            MailPart attachmentMailPart = MimeMessageConverter.convertPart((Part)attachmentPart, false);
            attachmentMailPart.setSequenceId(String.valueOf(1));
            compositeMail.addAdditionalParts(attachmentMailPart);
            forwardMail = compositeMail;
        }
        if (null != msgref) {
            forwardMail.setMsgref(msgref);
        }
        return forwardMail;
    }

    private static User getUser(Session session, Context ctx) {
        if (session instanceof ServerSession) {
            return ((ServerSession)session).getUser();
        }
        return UserStorage.getStorageUser(session.getUserId(), ctx);
    }

    private static MailMessage asAttachmentForward(MailMessage[] originalMsgs, MimeMessage forwardMsg) throws MessagingException, OXException {
        MimeMultipart multipart = new MimeMultipart();
        MimeBodyPart textPart = new MimeBodyPart();
        textPart.setText("", MailProperties.getInstance().getDefaultMimeCharset(), "plain");
        textPart.setHeader("MIME-Version", "1.0");
        textPart.setHeader("Content-Type", "text/plain; charset=#CS#".replaceFirst("#CS#", MailProperties.getInstance().getDefaultMimeCharset()));
        multipart.addBodyPart((BodyPart)textPart);
        forwardMsg.setContent((Multipart)multipart);
        forwardMsg.saveChanges();
        forwardMsg.removeHeader("Message-ID");
        CompositeMailMessage compositeMail = new CompositeMailMessage(MimeMessageConverter.convertMessage(forwardMsg));
        for (MailMessage originalMsg : originalMsgs) {
            MailMessage nested;
            if (originalMsg instanceof MimeMailMessage) {
                nested = MimeMessageConverter.convertMessage(((MimeMailMessage)originalMsg).getMimeMessage());
            } else {
                UnsynchronizedByteArrayOutputStream tmp = new UnsynchronizedByteArrayOutputStream((int)originalMsg.getSize());
                originalMsg.writeTo((OutputStream)tmp);
                nested = MimeMessageConverter.convertMessage(new MimeMessage(MimeDefaultSession.getDefaultSession(), (InputStream)new UnsynchronizedByteArrayInputStream(tmp.toByteArray())));
            }
            nested.setMsgref(originalMsg.getMailPath());
            compositeMail.addAdditionalParts(new NestedMessageMailPart(nested));
        }
        return compositeMail;
    }

    private static String getFirstSeenText(MailPart multipartPart, ContentType retvalContentType, UserSettingMail usm) throws OXException, MessagingException, IOException {
        String text;
        String charset;
        MailPart part;
        int i;
        ContentType contentType = multipartPart.getContentType();
        int count = multipartPart.getEnclosedCount();
        ContentType partContentType = new ContentType();
        if ((contentType.startsWith("multipart/alternative") || contentType.startsWith("multipart/related")) && usm.isDisplayHtmlInlineContent() && count >= 2) {
            for (i = 0; i < count; ++i) {
                part = multipartPart.getEnclosedMailPart(i);
                partContentType.setContentType(part.getContentType());
                if (partContentType.startsWith(TEXT_HTM) && MimeProcessingUtility.isInline(part, partContentType)) {
                    charset = MessageUtility.checkCharset(part, partContentType);
                    retvalContentType.setContentType(partContentType);
                    retvalContentType.setCharsetParameter(charset);
                    return MimeProcessingUtility.readContent(part, charset);
                }
                if (!partContentType.startsWith(MULTIPART) || (text = MimeForward.getFirstSeenText(part, retvalContentType, usm)) == null) continue;
                return text;
            }
        }
        for (i = 0; i < count; ++i) {
            part = multipartPart.getEnclosedMailPart(i);
            partContentType.setContentType(part.getContentType());
            if (partContentType.startsWith(TEXT) && MimeProcessingUtility.isInline(part, partContentType) && !MimeProcessingUtility.isSpecial(contentType.getBaseType())) {
                charset = MessageUtility.checkCharset(part, partContentType);
                retvalContentType.setContentType(partContentType);
                retvalContentType.setCharsetParameter(charset);
                return MimeProcessingUtility.handleInlineTextPart(part, retvalContentType, usm.isDisplayHtmlInlineContent());
            }
            if (!partContentType.startsWith(MULTIPART) || (text = MimeForward.getFirstSeenText(part, retvalContentType, usm)) == null) continue;
            return text;
        }
        return null;
    }

    private static String generateForwardText(String firstSeenText, LocaleAndTimeZone ltz, MailMessage msg, boolean html) {
        Matcher m;
        boolean forwardUnquoted;
        StringHelper strHelper = StringHelper.valueOf(ltz.locale);
        String forwardPrefix = strHelper.getString("---------- Original Message ----------\nFrom: #FROM#\nTo: #TO##CC_LINE#\nDate: #DATE# at #TIME#\nSubject: #SUBJECT#");
        InternetAddress[] from = msg.getFrom();
        forwardPrefix = PATTERN_FROM.matcher(forwardPrefix).replaceFirst(from == null || from.length == 0 ? "" : Matcher.quoteReplacement(from[0].toUnicodeString()));
        InternetAddress[] to = msg.getTo();
        forwardPrefix = PATTERN_TO.matcher(forwardPrefix).replaceFirst(to == null || to.length == 0 ? "" : Matcher.quoteReplacement(MimeProcessingUtility.addrs2String(to)));
        InternetAddress[] cc = msg.getCc();
        forwardPrefix = PATTERN_CCLINE.matcher(forwardPrefix).replaceFirst(cc == null || cc.length == 0 ? "" : Matcher.quoteReplacement(new StringAllocator(64).append("\nCc: ").append(MimeProcessingUtility.addrs2String(cc)).toString()));
        Date date = msg.getSentDate();
        try {
            forwardPrefix = PATTERN_DATE.matcher(forwardPrefix).replaceFirst(date == null ? "" : Matcher.quoteReplacement(MimeProcessingUtility.getFormattedDate(date, 1, ltz.locale, ltz.timeZone)));
        }
        catch (Exception t) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)t.getMessage(), (Throwable)t);
            }
            forwardPrefix = PATTERN_DATE.matcher(forwardPrefix).replaceFirst("");
        }
        try {
            forwardPrefix = PATTERN_TIME.matcher(forwardPrefix).replaceFirst(date == null ? "" : Matcher.quoteReplacement(MimeProcessingUtility.getFormattedTime(date, 3, ltz.locale, ltz.timeZone)));
        }
        catch (Exception t) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)t.getMessage(), (Throwable)t);
            }
            forwardPrefix = PATTERN_TIME.matcher(forwardPrefix).replaceFirst("");
        }
        String decodedSubject = MimeMessageUtility.decodeMultiEncodedHeader(msg.getSubject());
        forwardPrefix = PATTERN_SUBJECT.matcher(forwardPrefix).replaceFirst(decodedSubject == null ? "" : Matcher.quoteReplacement(decodedSubject));
        if (html) {
            forwardPrefix = HtmlProcessing.htmlFormat(forwardPrefix);
        }
        String linebreak = html ? "<br>" : "\r\n";
        ConfigurationService service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
        boolean bl = forwardUnquoted = null == service ? false : service.getBoolProperty("com.openexchange.mail.forwardUnquoted", false);
        if (forwardUnquoted) {
            if (html) {
                m = PATTERN_BODY.matcher(firstSeenText);
                MatcherReplacer mr = new MatcherReplacer(m, firstSeenText);
                StringBuilder replaceBuffer = new StringBuilder(firstSeenText.length() + 256);
                if (m.find()) {
                    mr.appendLiteralReplacement(replaceBuffer, new StringBuilder(forwardPrefix.length() + 16).append(linebreak).append(m.group()).append(forwardPrefix).append(linebreak).toString());
                } else {
                    replaceBuffer.append(linebreak).append(forwardPrefix).append(linebreak);
                }
                replaceBuffer.append("<div style=\"position:relative\">");
                mr.appendTail(replaceBuffer);
                replaceBuffer.append("</div>");
                return replaceBuffer.toString();
            }
            return new StringAllocator(firstSeenText.length() + 256).append(linebreak).append(forwardPrefix).append(linebreak).append(firstSeenText).toString();
        }
        if (html) {
            m = PATTERN_BODY.matcher(firstSeenText);
            MatcherReplacer mr = new MatcherReplacer(m, firstSeenText);
            StringBuilder replaceBuffer = new StringBuilder(firstSeenText.length() + 256);
            if (m.find()) {
                mr.appendLiteralReplacement(replaceBuffer, new StringAllocator(forwardPrefix.length() + 16).append(m.group()).append(forwardPrefix).append(linebreak).append(linebreak).toString());
            } else {
                replaceBuffer.append(forwardPrefix).append(linebreak).append(linebreak);
            }
            mr.appendTail(replaceBuffer);
            String tmp = MimeForward.quoteHtml(replaceBuffer.toString());
            replaceBuffer.setLength(0);
            replaceBuffer.append(linebreak);
            replaceBuffer.append(tmp);
            return replaceBuffer.toString();
        }
        StringBuilder builder = new StringBuilder(firstSeenText.length() + 256);
        String tmp = builder.append(forwardPrefix).append(linebreak).append(linebreak).append(firstSeenText).toString();
        builder.setLength(0);
        builder.append(linebreak).append(MimeForward.quoteText(tmp));
        return builder.toString();
    }

    private static String quoteText(String textContent) {
        return textContent.replaceAll("(?m)^", "> ");
    }

    private static String quoteHtml(String htmlContent) {
        Matcher m = PATTERN_HTML_START.matcher(htmlContent);
        MatcherReplacer mr = new MatcherReplacer(m, htmlContent);
        StringBuilder sb = new StringBuilder(htmlContent.length());
        if (m.find()) {
            mr.appendLiteralReplacement(sb, BLOCKQUOTE_START);
        } else {
            sb.append(BLOCKQUOTE_START);
        }
        mr.appendTail(sb);
        String s = sb.toString();
        m = PATTERN_HTML_END.matcher(s);
        mr.resetTo(m, s);
        sb.setLength(0);
        if (m.find()) {
            mr.appendLiteralReplacement(sb, BLOCKQUOTE_END);
            mr.appendTail(sb);
        } else {
            mr.appendTail(sb);
            sb.append(BLOCKQUOTE_END);
        }
        return sb.toString();
    }

    private static User getUserFrom(Session session) {
        try {
            if (null == session) {
                return null;
            }
            if (session instanceof ServerSession) {
                return ((ServerSession)session).getUser();
            }
            Context ctx = ContextStorage.getStorageContext(session.getContextId());
            return UserStorage.getStorageUser(session.getUserId(), ctx);
        }
        catch (Exception e) {
            return null;
        }
    }
}

