/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.mime.dataobjects;

import com.openexchange.exception.OXException;
import com.openexchange.java.StringAllocator;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.mime.ContentDisposition;
import com.openexchange.mail.mime.MimeType2ExtMap;
import com.openexchange.mail.mime.datasource.FileDataSource;
import com.openexchange.mail.mime.datasource.MessageDataSource;
import com.openexchange.mail.utils.CharsetDetector;
import com.openexchange.mail.utils.MessageUtility;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.apache.commons.logging.Log;

public abstract class MimeFileMailPart
extends MailPart {
    private static final long serialVersionUID = 257902073011243269L;
    private static final transient Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(MimeFileMailPart.class));
    private final File file;
    private transient DataSource dataSource;
    private transient Object cachedContent;
    private static final String TEXT = "text/";

    protected MimeFileMailPart(FileDataSource fileDataSource) throws OXException {
        this.file = fileDataSource.getFile();
        String preparedFileName = fileDataSource.getName();
        this.setContentType(MimeFileMailPart.prepareContentType(fileDataSource.getContentType(), preparedFileName));
        this.setFileName(preparedFileName);
        this.setSize(fileDataSource.getFile().length());
        ContentDisposition cd = new ContentDisposition();
        cd.setDisposition("attachment");
        cd.setFilenameParameter(this.getFileName());
        this.setContentDisposition(cd);
        try {
            if (this.getContentType().getCharsetParameter() == null && this.getContentType().startsWith(TEXT)) {
                String cs = CharsetDetector.detectCharset(new FileInputStream(this.file));
                this.getContentType().setCharsetParameter(cs);
            }
            this.dataSource = fileDataSource;
        }
        catch (IOException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            this.dataSource = new MessageDataSource(new byte[0], "application/octet-stream");
        }
    }

    private static String prepareContentType(String contentType, String preparedFileName) {
        if (null == contentType || contentType.length() == 0) {
            return "application/octet-stream";
        }
        int mlen = contentType.length() - 1;
        String retval = 0 == contentType.indexOf(34) && mlen == contentType.lastIndexOf(34) ? contentType.substring(1, mlen) : contentType;
        if ("multipart/form-data".equalsIgnoreCase(retval)) {
            return MimeType2ExtMap.getContentType(preparedFileName);
        }
        return contentType;
    }

    private DataSource getDataSource() {
        if (null == this.dataSource) {
            try {
                if (this.getContentType().getCharsetParameter() == null && this.getContentType().startsWith(TEXT)) {
                    String cs = CharsetDetector.detectCharset(new FileInputStream(this.file));
                    this.getContentType().setCharsetParameter(cs);
                }
                this.dataSource = new FileDataSource(this.file, this.getContentType().toString());
            }
            catch (IOException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                this.dataSource = new MessageDataSource(new byte[0], "application/octet-stream");
            }
        }
        return this.dataSource;
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public Object getContent() throws OXException {
        if (this.cachedContent != null) {
            return this.cachedContent;
        }
        if (this.getContentType().isMimeType("text/*")) {
            String charset = this.getContentType().getCharsetParameter();
            if (charset == null) {
                try {
                    charset = CharsetDetector.detectCharset(new FileInputStream(this.file));
                    if (LOG.isWarnEnabled()) {
                        LOG.warn((Object)new StringAllocator("Uploaded file contains textual content but").append(" does not specify a charset. Assumed charset is: ").append(charset).toString());
                    }
                }
                catch (FileNotFoundException e) {
                    throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
                }
            }
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(this.file);
                this.cachedContent = MessageUtility.readStream(fis, charset);
            }
            catch (FileNotFoundException e) {
                throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
            }
            catch (IOException e) {
                throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        LOG.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
            return this.cachedContent;
        }
        return null;
    }

    @Override
    public DataHandler getDataHandler() throws OXException {
        return new DataHandler(this.getDataSource());
    }

    @Override
    public int getEnclosedCount() throws OXException {
        return -1;
    }

    @Override
    public MailPart getEnclosedMailPart(int index) throws OXException {
        return null;
    }

    @Override
    public InputStream getInputStream() throws OXException {
        try {
            return new FileInputStream(this.file);
        }
        catch (FileNotFoundException e) {
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
    }

    @Override
    public void loadContent() {
    }

    @Override
    public void prepareForCaching() {
    }
}

