/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.mime;

import com.openexchange.java.StringAllocator;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.mime.utils.MimeMessageUtility;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.idn.IDNA;
import org.apache.commons.logging.Log;

public final class QuotedInternetAddress
extends InternetAddress {
    private static final long serialVersionUID = -2523736473507495692L;
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(QuotedInternetAddress.class));
    private static final boolean IGNORE_BOGUS_GROUP_NAME = QuotedInternetAddress.getBooleanSystemProperty("mail.mime.address.ignorebogusgroupname", true);
    private String jcharset;
    private static final Pattern WHITESPACE_OR_CONTROL = Pattern.compile("[\\p{Space}&&[^ ]]|\\p{Cntrl}|[^\\p{Print}\\p{L}]");
    private static final String SPECIALS_NO_DOT_NO_AT = "()<>,;:\\\"[]";
    private static final String SPECIALS_NO_DOT = "()<>@,;:\\\"[]";
    private static final String RFC822 = "()<>@,;:\\\".[]";

    private static boolean getBooleanSystemProperty(String name, boolean def) {
        return Boolean.parseBoolean(System.getProperty(name, def ? "true" : "false"));
    }

    public static InternetAddress[] toQuotedAddresses(InternetAddress[] addrs) throws AddressException {
        if (null == addrs) {
            return null;
        }
        InternetAddress[] ret = new InternetAddress[addrs.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = new QuotedInternetAddress(addrs[i]);
        }
        return ret;
    }

    public static InternetAddress[] parse(String addresslist) throws AddressException {
        return QuotedInternetAddress.parse(addresslist, true);
    }

    public static InternetAddress[] parse(String addresslist, boolean strict) throws AddressException {
        return QuotedInternetAddress.parse(addresslist, strict, false);
    }

    public static InternetAddress[] parseHeader(String addresslist, boolean strict) throws AddressException {
        return QuotedInternetAddress.parse(addresslist, strict, true);
    }

    /*
     * Unable to fully structure code
     */
    private static InternetAddress[] parse(String s, boolean strict, boolean parseHdr) throws AddressException {
        start_personal = -1;
        end_personal = -1;
        length = s.length();
        ignoreErrors = parseHdr != false && strict == false;
        in_group = false;
        route_addr = false;
        rfc822 = false;
        list = new ArrayList<QuotedInternetAddress>();
        end = -1;
        start = -1;
        block30: for (index = 0; index < length; ++index) {
            c = s.charAt(index);
            switch (c) {
                case '(': {
                    rfc822 = true;
                    if (start >= 0 && end == -1) {
                        end = index;
                    }
                    pindex = index++;
                    nesting = 1;
                    while (index < length && nesting > 0) {
                        c = s.charAt(index);
                        switch (c) {
                            case '\\': {
                                ++index;
                                break;
                            }
                            case '(': {
                                ++nesting;
                                break;
                            }
                            case ')': {
                                --nesting;
                                break;
                            }
                        }
                        ++index;
                    }
                    if (nesting > 0) {
                        if (!ignoreErrors) {
                            throw new AddressException("Missing ')'", s, index);
                        }
                        index = pindex + 1;
                        continue block30;
                    }
                    --index;
                    if (start_personal == -1) {
                        start_personal = pindex + 1;
                    }
                    if (end_personal != -1) continue block30;
                    end_personal = index;
                    continue block30;
                }
                case ')': {
                    if (!ignoreErrors) {
                        throw new AddressException("Missing '('", s, index);
                    }
                    if (start != -1) continue block30;
                    start = index;
                    continue block30;
                }
                case '<': {
                    rfc822 = true;
                    if (route_addr) {
                        if (!ignoreErrors) {
                            throw new AddressException("Extra route-addr", s, index);
                        }
                        if (start == -1) {
                            route_addr = false;
                            rfc822 = false;
                            end = -1;
                            start = -1;
                            continue block30;
                        }
                        if (!in_group) {
                            if (end == -1) {
                                end = index;
                            }
                            addr = s.substring(start, end).trim();
                            qia = new QuotedInternetAddress();
                            qia.setAddress(QuotedInternetAddress.toACE(addr));
                            if (start_personal >= 0) {
                                qia.encodedPersonal = QuotedInternetAddress.unquote(s.substring(start_personal, end_personal).trim());
                            }
                            list.add(qia);
                            route_addr = false;
                            rfc822 = false;
                            end = -1;
                            start = -1;
                            end_personal = -1;
                            start_personal = -1;
                        }
                    }
                    rindex = index++;
                    inquote = false;
                    block32: while (index < length) {
                        c = s.charAt(index);
                        switch (c) {
                            case '\\': {
                                ++index;
                                ** GOTO lbl91
                            }
                            case '\"': {
                                inquote ^= true;
                                ** GOTO lbl91
                            }
                            case '>': {
                                if (!inquote) break block32;
                            }
lbl91:
                            // 4 sources

                            default: {
                                ++index;
                                continue block32;
                            }
                        }
                    }
                    if (inquote) {
                        if (!ignoreErrors) {
                            throw new AddressException("Missing '\"'", s, index);
                        }
                        for (index = rindex + 1; index < length; ++index) {
                            c = s.charAt(index);
                            if (c == '\\') {
                                ++index;
                                continue;
                            }
                            if (c == '>') break;
                        }
                    }
                    if (index >= length) {
                        if (!ignoreErrors) {
                            throw new AddressException("Missing '>'", s, index);
                        }
                        index = rindex + 1;
                        if (start != -1) continue block30;
                        start = rindex;
                        continue block30;
                    }
                    if (!in_group) {
                        start_personal = start;
                        if (start_personal >= 0) {
                            end_personal = rindex;
                        }
                        start = rindex + 1;
                    }
                    route_addr = true;
                    end = index;
                    continue block30;
                }
                case '>': {
                    if (!ignoreErrors) {
                        throw new AddressException("Missing '<'", s, index);
                    }
                    if (start != -1) continue block30;
                    start = index;
                    continue block30;
                }
                case '\"': {
                    qindex = index;
                    rfc822 = true;
                    if (start == -1) {
                        start = index;
                    }
                    ++index;
                    block34: while (index < length) {
                        c = s.charAt(index);
                        switch (c) {
                            case '\\': {
                                ++index;
                                ** GOTO lbl139
                            }
                            case '\"': {
                                break block34;
                            }
lbl139:
                            // 2 sources

                            default: {
                                ++index;
                                continue block34;
                            }
                        }
                    }
                    if (index < length) continue block30;
                    if (!ignoreErrors) {
                        throw new AddressException("Missing '\"'", s, index);
                    }
                    index = qindex + 1;
                    continue block30;
                }
                case '[': {
                    rfc822 = true;
                    lindex = index++;
                    block35: while (index < length) {
                        c = s.charAt(index);
                        switch (c) {
                            case '\\': {
                                ++index;
                                ** GOTO lbl158
                            }
                            case ']': {
                                break block35;
                            }
lbl158:
                            // 2 sources

                            default: {
                                ++index;
                                continue block35;
                            }
                        }
                    }
                    if (index < length) continue block30;
                    if (!ignoreErrors) {
                        throw new AddressException("Missing ']'", s, index);
                    }
                    index = lindex + 1;
                    continue block30;
                }
                case ';': {
                    if (start == -1) {
                        route_addr = false;
                        rfc822 = false;
                        end = -1;
                        start = -1;
                        continue block30;
                    }
                    if (in_group) {
                        in_group = false;
                        if (parseHdr && !strict && index + 1 < length && s.charAt(index + 1) == '@') continue block30;
                        qia = new QuotedInternetAddress();
                        end = index + 1;
                        qia.setAddress(QuotedInternetAddress.toACE(s.substring(start, end).trim()));
                        list.add(qia);
                        route_addr = false;
                        rfc822 = false;
                        end = -1;
                        start = -1;
                        end_personal = -1;
                        start_personal = -1;
                        continue block30;
                    }
                    if (!ignoreErrors) {
                        throw new AddressException("Illegal semicolon, not in group", s, index);
                    }
                }
                case ',': {
                    if (start == -1) {
                        route_addr = false;
                        rfc822 = false;
                        end = -1;
                        start = -1;
                        continue block30;
                    }
                    if (in_group) {
                        route_addr = false;
                        continue block30;
                    }
                    if (end == -1) {
                        end = index;
                    }
                    addr = s.substring(start, end).trim();
                    pers = null;
                    if (rfc822 && start_personal >= 0 && QuotedInternetAddress.isEmpty(pers = QuotedInternetAddress.unquote(s.substring(start_personal, end_personal).trim()))) {
                        pers = null;
                    }
                    if (parseHdr && !strict && pers != null && pers.indexOf(64) >= 0 && addr.indexOf(64) < 0 && addr.indexOf(33) < 0) {
                        tmp = addr;
                        addr = pers;
                        pers = tmp;
                    }
                    if (rfc822 || strict || parseHdr) {
                        ace = QuotedInternetAddress.toACE(addr);
                        if (!ignoreErrors) {
                            QuotedInternetAddress.checkAddress(ace, route_addr, false);
                        }
                        qia = new QuotedInternetAddress();
                        qia.setAddress(ace);
                        if (pers != null) {
                            qia.encodedPersonal = pers;
                        }
                        list.add(qia);
                    } else {
                        st = new StringTokenizer(addr);
                        while (st.hasMoreTokens()) {
                            a = st.nextToken();
                            ace = QuotedInternetAddress.toACE(a);
                            QuotedInternetAddress.checkAddress(ace, false, false);
                            qia = new QuotedInternetAddress();
                            qia.setAddress(ace);
                            list.add(qia);
                        }
                    }
                    route_addr = false;
                    rfc822 = false;
                    end = -1;
                    start = -1;
                    end_personal = -1;
                    start_personal = -1;
                    continue block30;
                }
                case ':': {
                    rfc822 = true;
                    if (in_group && !ignoreErrors) {
                        throw new AddressException("Nested group", s, index);
                    }
                    if (start == -1) {
                        start = index;
                    }
                    if (parseHdr && !strict) {
                        if (index + 1 < length) {
                            addressSpecials = ")>[]:@\\,.";
                            nc = s.charAt(index + 1);
                            if (")>[]:@\\,.".indexOf(nc) >= 0) {
                                if (nc != '@') continue block30;
                                for (i = index + 2; i < length && (nc = s.charAt(i)) != ';' && ")>[]:@\\,.".indexOf(nc) < 0; ++i) {
                                }
                                if (nc == ';') continue block30;
                            }
                        }
                        gname = s.substring(start, index);
                        if (QuotedInternetAddress.IGNORE_BOGUS_GROUP_NAME && (gname.equalsIgnoreCase("mailto") || gname.equalsIgnoreCase("From") || gname.equalsIgnoreCase("To") || gname.equalsIgnoreCase("Cc") || gname.equalsIgnoreCase("Subject") || gname.equalsIgnoreCase("Re"))) {
                            start = -1;
                            continue block30;
                        }
                        in_group = true;
                        continue block30;
                    }
                    in_group = true;
                    continue block30;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block30;
                }
                default: {
                    if (start != -1) continue block30;
                    start = index;
                }
            }
        }
        if (start >= 0) {
            if (end == -1) {
                end = length;
            }
            addr = s.substring(start, end).trim();
            pers = null;
            if (rfc822 && start_personal >= 0 && QuotedInternetAddress.isEmpty(pers = QuotedInternetAddress.unquote(s.substring(start_personal, end_personal).trim()))) {
                pers = null;
            }
            if (parseHdr && !strict && pers != null && pers.indexOf(64) >= 0 && addr.indexOf(64) < 0 && addr.indexOf(33) < 0) {
                tmp = addr;
                addr = pers;
                pers = tmp;
            }
            if (rfc822 || strict || parseHdr) {
                ace = QuotedInternetAddress.toACE(addr);
                if (!ignoreErrors) {
                    QuotedInternetAddress.checkAddress(ace, route_addr, false);
                }
                qia = new QuotedInternetAddress();
                qia.setAddress(ace);
                if (pers != null) {
                    qia.encodedPersonal = pers;
                }
                list.add(qia);
            } else {
                st = new StringTokenizer(addr);
                while (st.hasMoreTokens()) {
                    a = st.nextToken();
                    ace = QuotedInternetAddress.toACE(a);
                    QuotedInternetAddress.checkAddress(ace, false, false);
                    qia = new QuotedInternetAddress();
                    qia.setAddress(ace);
                    list.add(qia);
                }
            }
        }
        return list.toArray(new InternetAddress[list.size()]);
    }

    private static void checkAddress(String addr, boolean routeAddr, boolean validate) throws AddressException {
        int i;
        int start = 0;
        int len = addr.length();
        if (len == 0) {
            throw new AddressException("Empty address", addr.toString());
        }
        if (routeAddr && addr.charAt(0) == '@') {
            start = 0;
            while ((i = QuotedInternetAddress.indexOfAny(addr, ",:", start)) >= 0) {
                if (addr.charAt(start) != '@') {
                    throw new AddressException("Illegal route-addr", addr.toString());
                }
                if (addr.charAt(i) == ':') {
                    start = i + 1;
                    break;
                }
                start = i + 1;
            }
        }
        int c = 65535;
        int lastc = 65535;
        boolean inquote = false;
        for (i = start; i < len; ++i) {
            lastc = c;
            c = addr.charAt(i);
            if (c == 92 || lastc == 92) continue;
            if (c == 34) {
                if (inquote) {
                    if (validate && i + 1 < len && addr.charAt(i + 1) != '@') {
                        throw new AddressException("Quote not at end of local address", addr.toString());
                    }
                    inquote = false;
                    continue;
                }
                if (validate && i != 0) {
                    throw new AddressException("Quote not at start of local address", addr.toString());
                }
                inquote = true;
                continue;
            }
            if (inquote) continue;
            if (c == 64) {
                if (i != 0) break;
                throw new AddressException("Missing local name", addr.toString());
            }
            if (c <= 32 || c >= 127) {
                throw new AddressException("Local address contains control or whitespace", addr.toString());
            }
            if (SPECIALS_NO_DOT.indexOf(c) < 0) continue;
            throw new AddressException("Local address contains illegal character", addr.toString());
        }
        if (inquote) {
            throw new AddressException("Unterminated quote", addr.toString());
        }
        if (c != 64) {
            if (validate) {
                throw new AddressException("Missing final '@domain'", addr.toString());
            }
            return;
        }
        start = i + 1;
        if (start >= len) {
            throw new AddressException("Missing domain", addr.toString());
        }
        if (addr.charAt(start) == '.') {
            throw new AddressException("Domain starts with dot", addr.toString());
        }
        for (i = start; i < len; ++i) {
            c = addr.charAt(i);
            if (c == 91) {
                return;
            }
            if (c <= 32 || c >= 127) {
                throw new AddressException("Domain contains control or whitespace", addr.toString());
            }
            if (SPECIALS_NO_DOT.indexOf(c) >= 0) {
                throw new AddressException("Domain contains illegal character", addr.toString());
            }
            if (c == 46 && lastc == 46) {
                throw new AddressException("Domain contains dot-dot", addr.toString());
            }
            lastc = c;
        }
        if (lastc == 46) {
            throw new AddressException("Domain ends with dot", addr.toString());
        }
    }

    public static String toACE(String idnAddress) throws AddressException {
        return IDNA.toACE((String)idnAddress);
    }

    public static String toIDN(String aceAddress) {
        return IDNA.toIDN((String)aceAddress);
    }

    public QuotedInternetAddress() {
        this.jcharset = MailProperties.getInstance().getDefaultMimeCharset();
    }

    private QuotedInternetAddress(InternetAddress src) throws AddressException {
        this();
        this.address = QuotedInternetAddress.toACE(src.getAddress());
        try {
            this.setPersonal(this.getPersonal(), null);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Unsupported default charset.");
        }
    }

    public QuotedInternetAddress(String address) throws AddressException {
        this.parseAddress0(address);
        this.jcharset = MailProperties.getInstance().getDefaultMimeCharset();
    }

    public QuotedInternetAddress(String address, boolean strict) throws AddressException {
        this(QuotedInternetAddress.init(address, true));
        if (strict) {
            if (this.isGroup()) {
                this.getGroup(true);
            } else {
                QuotedInternetAddress.checkAddress(this.address, true, true);
            }
        }
    }

    public QuotedInternetAddress(String address, boolean strict, boolean suppressControlOrWhitespace) throws AddressException {
        this(QuotedInternetAddress.init(address, suppressControlOrWhitespace));
        if (strict) {
            if (this.isGroup()) {
                this.getGroup(true);
            } else {
                QuotedInternetAddress.checkAddress(this.address, true, true);
            }
        }
    }

    private static String init(String address, boolean suppressControlOrWhitespace) {
        if (!suppressControlOrWhitespace) {
            return address;
        }
        return WHITESPACE_OR_CONTROL.matcher(address).replaceAll("");
    }

    public QuotedInternetAddress(String address, String personal) throws AddressException, UnsupportedEncodingException {
        this(address, personal, null);
    }

    public QuotedInternetAddress(String address, String personal, String charset) throws AddressException, UnsupportedEncodingException {
        this.address = QuotedInternetAddress.toACE(address);
        if (charset == null) {
            this.jcharset = MailProperties.getInstance().getDefaultMimeCharset();
        } else {
            String javaCharset = MimeUtility.javaCharset((String)charset);
            if ("utf8".equalsIgnoreCase(javaCharset)) {
                javaCharset = "UTF-8";
            }
            this.jcharset = javaCharset;
        }
        this.setPersonal(personal, charset);
    }

    public void parseAddress(String address) throws AddressException {
        this.parseAddress0(address);
    }

    private void parseAddress0(String address) throws AddressException {
        InternetAddress[] a = QuotedInternetAddress.parse(address, true);
        if (a.length != 1) {
            throw new AddressException("Illegal address", address);
        }
        QuotedInternetAddress internetAddress = (QuotedInternetAddress)a[0];
        this.address = internetAddress.address;
        this.personal = internetAddress.personal;
        this.encodedPersonal = internetAddress.encodedPersonal;
    }

    public String getIDNAddress() {
        return QuotedInternetAddress.toIDN(this.address);
    }

    public void setPersonal(String name, String charset) throws UnsupportedEncodingException {
        this.personal = name;
        if (name != null) {
            if (charset == null) {
                this.jcharset = MailProperties.getInstance().getDefaultMimeCharset();
            } else {
                String javaCharset = MimeUtility.javaCharset((String)charset);
                if ("utf8".equalsIgnoreCase(javaCharset)) {
                    javaCharset = "UTF-8";
                }
                this.jcharset = javaCharset;
            }
            this.encodedPersonal = MimeUtility.encodeWord((String)name, (String)charset, null);
        } else {
            this.encodedPersonal = null;
        }
    }

    public void setAddress(String address) {
        try {
            this.address = QuotedInternetAddress.toACE(address);
        }
        catch (AddressException e) {
            LOG.error((Object)("ACE string could not be parsed from IDN string: " + address), (Throwable)e);
            this.address = address;
        }
    }

    public String getUnicodeAddress() {
        return QuotedInternetAddress.toIDN(this.address);
    }

    public String getPersonal() {
        if (this.personal != null) {
            return this.personal;
        }
        if (this.encodedPersonal != null) {
            try {
                this.personal = MimeMessageUtility.decodeMultiEncodedHeader(this.encodedPersonal);
                return this.personal;
            }
            catch (Exception ex) {
                return this.encodedPersonal;
            }
        }
        return null;
    }

    public String toString() {
        if (this.encodedPersonal == null && this.personal != null) {
            try {
                this.encodedPersonal = MimeUtility.encodeWord((String)this.personal, (String)this.jcharset, null);
            }
            catch (UnsupportedEncodingException ex) {
                LOG.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        if (this.encodedPersonal != null && this.encodedPersonal.length() > 0) {
            if (null == this.personal) {
                try {
                    this.personal = MimeUtility.decodeText((String)this.encodedPersonal);
                }
                catch (Exception ex) {
                    this.personal = this.encodedPersonal;
                }
            }
            if (QuotedInternetAddress.quoted(this.personal)) {
                if (QuotedInternetAddress.checkQuotedPersonal(this.personal)) {
                    return new StringAllocator(32).append(this.encodedPersonal).append(" <").append(this.address).append('>').toString();
                }
                this.personal = this.personal.substring(1, this.personal.length() - 1);
                try {
                    this.encodedPersonal = MimeUtility.encodeWord((String)this.personal, (String)this.jcharset, null);
                }
                catch (UnsupportedEncodingException ex) {
                    LOG.error((Object)ex.getMessage(), (Throwable)ex);
                }
            }
            if (QuotedInternetAddress.needQuoting(this.personal, true)) {
                try {
                    this.encodedPersonal = MimeUtility.encodeWord((String)QuotedInternetAddress.quotePhrase(this.personal, true), (String)this.jcharset, null);
                }
                catch (UnsupportedEncodingException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            } else if (!QuotedInternetAddress.isAscii(this.personal)) {
                try {
                    this.encodedPersonal = MimeUtility.encodeWord((String)QuotedInternetAddress.quotePhrase(this.personal, true), (String)this.jcharset, null);
                }
                catch (UnsupportedEncodingException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            return new StringAllocator(32).append(this.encodedPersonal).append(" <").append(this.address).append('>').toString();
        }
        if (this.isGroup() || this.isSimple()) {
            return this.address;
        }
        return new StringAllocator().append('<').append(this.address).append('>').toString();
    }

    public String toUnicodeString() {
        String p = this.getPersonal();
        if (p != null && p.length() > 0) {
            if (QuotedInternetAddress.quoted(p)) {
                return new StringAllocator(32).append(p).append(" <").append(QuotedInternetAddress.toIDN(this.address)).append('>').toString();
            }
            return new StringAllocator(32).append(QuotedInternetAddress.quotePhrase(p, true)).append(" <").append(QuotedInternetAddress.toIDN(this.address)).append('>').toString();
        }
        if (this.isGroup() || this.isSimple()) {
            return QuotedInternetAddress.toIDN(this.address);
        }
        return new StringAllocator(32).append('<').append(QuotedInternetAddress.toIDN(this.address)).append('>').toString();
    }

    private boolean isSimple() {
        return null == this.address || QuotedInternetAddress.indexOfAny(this.address, SPECIALS_NO_DOT_NO_AT) < 0;
    }

    private static int indexOfAny(CharSequence s, String any) {
        return QuotedInternetAddress.indexOfAny(s, any, 0);
    }

    private static int indexOfAny(CharSequence s, String any, int start) {
        try {
            int len = s.length();
            for (int i = start; i < len; ++i) {
                if (any.indexOf(s.charAt(i)) < 0) continue;
                return i;
            }
            return -1;
        }
        catch (StringIndexOutOfBoundsException e) {
            return -1;
        }
    }

    private static String quotePhrase(String phrase, boolean allowNonAscii) {
        int len = phrase.length();
        boolean needQuoting = false;
        for (int i = 0; i < len; ++i) {
            char c = phrase.charAt(i);
            if (c == '\"' || c == '\\') {
                StringAllocator sb = new StringAllocator(len + 3);
                sb.append('\"');
                for (int j = 0; j < len; ++j) {
                    char cc = phrase.charAt(j);
                    if (cc == '\"' || cc == '\\') {
                        sb.append('\\');
                    }
                    sb.append(cc);
                }
                sb.append('\"');
                return sb.toString();
            }
            if (!(c < ' ' && c != '\r' && c != '\n' && c != '\t' || !allowNonAscii && c >= '\u007f') && RFC822.indexOf(c) < 0) continue;
            needQuoting = true;
        }
        if (needQuoting) {
            StringAllocator sb = new StringAllocator(len + 2);
            sb.append('\"').append(phrase).append('\"');
            return sb.toString();
        }
        return phrase;
    }

    private static boolean needQuoting(String phrase, boolean allowNonAscii) {
        int len = phrase.length();
        boolean needQuoting = false;
        for (int i = 0; !needQuoting && i < len; ++i) {
            char c = phrase.charAt(i);
            if (c == '\"' || c == '\\') {
                needQuoting = true;
                continue;
            }
            if (!(c < ' ' && c != '\r' && c != '\n' && c != '\t' || !allowNonAscii && c >= '\u007f') && RFC822.indexOf(c) < 0) continue;
            needQuoting = true;
        }
        return needQuoting;
    }

    private static boolean quoted(String s) {
        int length = s.length();
        if (length <= 0) {
            return false;
        }
        return '\"' == s.charAt(0) && length > 1 && '\"' == s.charAt(length - 1);
    }

    private static boolean checkQuotedPersonal(String p) {
        String phrase = p.substring(1, p.length() - 1);
        int len = phrase.length();
        boolean valid = true;
        int i = 0;
        while (valid && i < len) {
            char c = phrase.charAt(i);
            if (c == '\"') {
                valid = i > 1 && '\\' == phrase.charAt(i - 1);
                ++i;
                continue;
            }
            if (c == '\\') {
                int ni = i + 1;
                char c2 = ni < len ? phrase.charAt(ni) : (char)'\u0000';
                valid = c2 == '\"' || c2 == '\\';
                i += 2;
                continue;
            }
            ++i;
        }
        return valid;
    }

    private static String unquote(String str) {
        if (QuotedInternetAddress.isEmpty(str)) {
            return str;
        }
        String s = str;
        int length = s.length();
        if (1 == length) {
            return str;
        }
        if ('\"' == s.charAt(0) && '\"' == s.charAt(length - 1) && (s = s.substring(1, length - 1)).indexOf(92) >= 0) {
            StringAllocator sb = new StringAllocator(length -= 2);
            for (int i = 0; i < length; ++i) {
                char c = s.charAt(i);
                if (c == '\\' && i < length - 1) {
                    c = s.charAt(++i);
                }
                sb.append(c);
            }
            s = sb.toString();
        }
        return s;
    }

    private static boolean isEmpty(String str) {
        if (null == str || 0 == str.length()) {
            return true;
        }
        int len = str.length();
        boolean ret = true;
        for (int i = 0; ret && i < len; ++i) {
            ret = Character.isWhitespace(str.charAt(i));
        }
        return ret;
    }

    private static boolean isAscii(String str) {
        if (null == str || 0 == str.length()) {
            return true;
        }
        int len = str.length();
        boolean ret = true;
        for (int i = 0; ret && i < len; ++i) {
            char c = str.charAt(i);
            ret = c > ' ' && c <= '\u007f';
        }
        return ret;
    }
}

