/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.mime;

import com.openexchange.exception.OXException;
import com.openexchange.i18n.LocaleTools;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.mime.IcsMimeFilter;
import com.openexchange.mail.mime.MimeMailException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class MimeFilter {
    protected final List<String> ignorableContentTypes;

    public static MimeFilter filterFor(String alias) {
        if ("ics".equalsIgnoreCase(alias)) {
            return IcsMimeFilter.getInstance();
        }
        return null;
    }

    public static MimeFilter filterFor(String ... ignorableContentTypes) {
        return new MimeFilter(Arrays.asList(ignorableContentTypes));
    }

    public static MimeFilter filterFor(List<String> ignorableContentTypes) {
        return new MimeFilter(ignorableContentTypes);
    }

    protected MimeFilter(List<String> ignorableContentTypes) {
        this.ignorableContentTypes = ignorableContentTypes;
    }

    public List<String> getIgnorableContentTypes() {
        return this.ignorableContentTypes;
    }

    public MimeMessage filter(MimeMessage mimeMessage) throws OXException {
        try {
            String contentType = LocaleTools.toLowerCase((String)mimeMessage.getContentType());
            if (!contentType.startsWith("multipart/")) {
                return mimeMessage;
            }
            MimeMultipart newMultipart = new MimeMultipart(MimeFilter.getSubType(contentType, "mixed"));
            this.handlePart((Multipart)mimeMessage.getContent(), newMultipart);
            mimeMessage.setContent((Multipart)newMultipart);
            mimeMessage.saveChanges();
            return mimeMessage;
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
        catch (IOException e) {
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            throw MailExceptionCode.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }

    public boolean ignorable(String contentType, BodyPart bodyPart) {
        for (String baseType : this.ignorableContentTypes) {
            if (!contentType.startsWith(baseType)) continue;
            return true;
        }
        return false;
    }

    public boolean ignorable(String contentType, MailPart bodyPart) {
        for (String baseType : this.ignorableContentTypes) {
            if (!contentType.startsWith(baseType)) continue;
            return true;
        }
        return false;
    }

    private void handlePart(Multipart multipart, MimeMultipart newMultipart) throws MessagingException, IOException, OXException {
        int count = multipart.getCount();
        for (int i = 0; i < count; ++i) {
            BodyPart bodyPart = multipart.getBodyPart(i);
            String contentType = bodyPart.getContentType();
            if (MimeFilter.isEmpty(contentType)) {
                newMultipart.addBodyPart(bodyPart);
                continue;
            }
            if ((contentType = LocaleTools.toLowerCase((String)contentType.trim())).startsWith("multipart/")) {
                MimeMultipart newSubMultipart = new MimeMultipart(MimeFilter.getSubType(contentType, "mixed"));
                this.handlePart((Multipart)bodyPart.getContent(), newSubMultipart);
                MimeBodyPart mimeBodyPart = new MimeBodyPart();
                mimeBodyPart.setContent((Multipart)newSubMultipart);
                newMultipart.addBodyPart((BodyPart)mimeBodyPart);
                continue;
            }
            if (contentType.startsWith("message/rfc822")) {
                MimeFilter nestedFilter = new MimeFilter(this.ignorableContentTypes);
                MimeMessage filteredMessage = nestedFilter.filter((MimeMessage)bodyPart.getContent());
                MimeBodyPart mimeBodyPart = new MimeBodyPart();
                mimeBodyPart.setContent((Object)filteredMessage, "message/rfc822");
                newMultipart.addBodyPart((BodyPart)mimeBodyPart);
                continue;
            }
            if (this.ignorable(contentType, bodyPart)) continue;
            newMultipart.addBodyPart(bodyPart);
        }
    }

    private static String getSubType(String contentType, String defaultType) {
        try {
            return new ContentType(contentType).getSubType();
        }
        catch (Exception e) {
            return defaultType;
        }
    }

    private static boolean isEmpty(String string) {
        if (null == string) {
            return true;
        }
        int len = string.length();
        boolean isWhitespace = true;
        for (int i = 0; isWhitespace && i < len; ++i) {
            isWhitespace = Character.isWhitespace(string.charAt(i));
        }
        return isWhitespace;
    }
}

