/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.mime;

import com.openexchange.exception.OXException;
import com.openexchange.java.StringAllocator;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.mime.ParameterList;
import com.openexchange.mail.mime.ParameterizedHeader;
import com.openexchange.mail.mime.utils.MimeMessageUtility;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ContentDisposition
extends ParameterizedHeader {
    private static final long serialVersionUID = 310827213193290169L;
    private static final Pattern PATTERN_CONTENT_DISP = Pattern.compile("(?:inline|attachment)", 2);
    private static final String INLINE = "inline";
    private static final String ATTACHMENT = "attachment";
    private static final String PARAM_FILENAME = "filename";
    private String disposition;

    public ContentDisposition() {
        this.disposition = INLINE;
        this.parameterList = new ParameterList();
    }

    public ContentDisposition(String contentDisp) throws OXException {
        this.parseContentDisp(contentDisp);
    }

    @Override
    public int compareTo(ParameterizedHeader other) {
        int dispComp;
        if (this == other) {
            return 0;
        }
        if (ContentDisposition.class.isInstance(other) && (dispComp = this.getDisposition().compareToIgnoreCase(((ContentDisposition)other).getDisposition())) != 0) {
            return dispComp;
        }
        return super.compareTo(other);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.disposition == null ? 0 : this.disposition.toLowerCase(Locale.US).hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContentDisposition other = (ContentDisposition)obj;
        return !(this.disposition == null ? other.disposition != null : !this.disposition.equalsIgnoreCase(other.disposition));
    }

    private void parseContentDisp(String contentDisp) throws OXException {
        this.parseContentDisp(contentDisp, true);
    }

    private void parseContentDisp(String contentDispArg, boolean paramList) throws OXException {
        if (null == contentDispArg || contentDispArg.length() == 0) {
            this.disposition = INLINE;
            this.parameterList = new ParameterList();
            return;
        }
        String contentDisp = MimeMessageUtility.decodeMultiEncodedHeader(ContentDisposition.prepareParameterizedHeader(contentDispArg));
        Matcher cdMatcher = PATTERN_CONTENT_DISP.matcher(contentDisp);
        if (!cdMatcher.find()) {
            this.disposition = INLINE;
            this.parameterList = new ParameterList();
            return;
        }
        if (cdMatcher.start() != 0) {
            throw MailExceptionCode.INVALID_CONTENT_DISPOSITION.create(contentDispArg);
        }
        this.disposition = cdMatcher.group().toLowerCase(Locale.US);
        if (paramList) {
            try {
                this.parameterList = new ParameterList(contentDisp.substring(cdMatcher.end()));
            }
            catch (RuntimeException e) {
                throw MailExceptionCode.INVALID_CONTENT_DISPOSITION.create(e, contentDispArg);
            }
        }
    }

    public void setContentDisposition(ContentDisposition contentDisp) {
        if (contentDisp == this) {
            return;
        }
        this.disposition = contentDisp.disposition;
        this.parameterList = (ParameterList)contentDisp.parameterList.clone();
    }

    public String getDisposition() {
        return this.disposition;
    }

    public void setDisposition(String disposition) {
        this.disposition = disposition;
    }

    public void setInline() {
        this.disposition = INLINE;
    }

    public void setAttachment() {
        this.disposition = ATTACHMENT;
    }

    public void setFilenameParameter(String filename) {
        this.setParameter(PARAM_FILENAME, filename);
    }

    public String getFilenameParameter() {
        return this.getParameter(PARAM_FILENAME);
    }

    public boolean containsFilenameParameter() {
        return this.containsParameter(PARAM_FILENAME);
    }

    public void setContentDisposition(String contentDisp) throws OXException {
        this.parseContentDisp(contentDisp);
    }

    public boolean isInline() {
        return INLINE.equalsIgnoreCase(this.disposition);
    }

    public boolean isAttachment() {
        return ATTACHMENT.equalsIgnoreCase(this.disposition);
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean skipEmptyParams) {
        StringAllocator sb = new StringAllocator(64);
        sb.append(this.disposition);
        if (null != this.parameterList) {
            this.parameterList.appendRFC2045String(sb, skipEmptyParams);
        }
        return sb.toString();
    }
}

