/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.actions;

import com.openexchange.ajax.requesthandler.AJAXActionService;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.AJAXState;
import com.openexchange.contactcollector.ContactCollectorService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.java.StringAllocator;
import com.openexchange.log.LogFactory;
import com.openexchange.log.LogProperties;
import com.openexchange.log.Props;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailJSONField;
import com.openexchange.mail.MailServletInterface;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.json.MailActionConstants;
import com.openexchange.mail.json.MailRequest;
import com.openexchange.mail.json.parser.MessageParser;
import com.openexchange.mail.mime.MimeMailException;
import com.openexchange.mail.mime.QuotedInternetAddress;
import com.openexchange.mail.usersetting.UserSettingMail;
import com.openexchange.mail.utils.DisplayMode;
import com.openexchange.mailaccount.MailAccount;
import com.openexchange.mailaccount.MailAccountExceptionCodes;
import com.openexchange.mailaccount.MailAccountStorageService;
import com.openexchange.server.ServiceLookup;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.idn.IDNA;
import org.apache.commons.logging.Log;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class AbstractMailAction
implements AJAXActionService,
MailActionConstants {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(AbstractMailAction.class));
    private static final AJAXRequestResult RESULT_JSON_NULL = new AJAXRequestResult(JSONObject.NULL, "json");
    private final ServiceLookup services;
    public static final int[] COLUMNS_ALL_ALIAS = new int[]{600, 601};
    public static final int[] COLUMNS_LIST_ALIAS = new int[]{600, 601, 614, 602, 611, 603, 612, 607, 652, 610, 608, 102};
    protected static final Set<String> CACHABLE_FORMATS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("apiResponse", "json")));
    protected static final String VIEW_RAW = "raw";
    protected static final String VIEW_TEXT = "text";
    protected static final String VIEW_HTML = "html";
    protected static final String VIEW_HTML_BLOCKED_IMAGES = "noimg";

    protected AbstractMailAction(ServiceLookup services) {
        this.services = services;
    }

    protected <S> S getService(Class<? extends S> clazz) {
        return (S)this.services.getService(clazz);
    }

    protected MailServletInterface getMailInterface(MailRequest mailRequest) throws OXException {
        AJAXState state = mailRequest.getRequest().getState();
        MailServletInterface mailInterface = null;
        if (state == null) {
            return MailServletInterface.getInstance(mailRequest.getSession());
        }
        mailInterface = (MailServletInterface)state.optProperty("com.openexchange.mail.json.mailInterface");
        if (mailInterface == null) {
            MailServletInterface newMailInterface = MailServletInterface.getInstance(mailRequest.getSession());
            mailInterface = state.putProperty("com.openexchange.mail.json.mailInterface", newMailInterface);
            if (null == mailInterface) {
                mailInterface = newMailInterface;
            } else {
                newMailInterface.close(true);
            }
        }
        return mailInterface;
    }

    @Override
    public AJAXRequestResult perform(AJAXRequestData requestData, ServerSession session) throws OXException {
        if (!session.getUserConfiguration().hasWebMail()) {
            throw AjaxExceptionCodes.NO_PERMISSION_FOR_MODULE.create("mail");
        }
        try {
            AJAXRequestResult aJAXRequestResult = this.perform(new MailRequest(requestData, session));
            return aJAXRequestResult;
        }
        catch (IllegalStateException e) {
            Throwable cause = e.getCause();
            if (cause instanceof OXException) {
                throw (OXException)cause;
            }
            throw AjaxExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
        finally {
            Props logProperties;
            if (LogProperties.isEnabled() && null != (logProperties = LogProperties.optLogProperties())) {
                for (String name : ALL_LOG_PROPERTIES) {
                    logProperties.remove(name);
                }
            }
        }
    }

    protected abstract AJAXRequestResult perform(MailRequest var1) throws OXException, JSONException;

    public static void triggerContactCollector(ServerSession session, MailMessage mail) {
        ContactCollectorService ccs = ServerServiceRegistry.getInstance().getService(ContactCollectorService.class);
        if (null != ccs) {
            HashSet<InternetAddress> addrs = new HashSet<InternetAddress>();
            addrs.addAll(Arrays.asList(mail.getFrom()));
            addrs.addAll(Arrays.asList(mail.getTo()));
            addrs.addAll(Arrays.asList(mail.getCc()));
            addrs.addAll(Arrays.asList(mail.getBcc()));
            try {
                String[] aliases;
                HashSet<QuotedInternetAddress> validAddrs = new HashSet<QuotedInternetAddress>(4);
                UserSettingMail usm = session.getUserSettingMail();
                if (usm.getSendAddr() != null && usm.getSendAddr().length() > 0) {
                    validAddrs.add(new QuotedInternetAddress(usm.getSendAddr()));
                }
                User user = UserStorage.getStorageUser(session.getUserId(), session.getContextId());
                validAddrs.add(new QuotedInternetAddress(user.getMail()));
                for (String alias : aliases = user.getAliases()) {
                    validAddrs.add(new QuotedInternetAddress(alias));
                }
                addrs.removeAll(validAddrs);
            }
            catch (AddressException e) {
                LOG.warn((Object)("Collected contacts could not be stripped by user's email aliases: " + e.getMessage()), (Throwable)e);
            }
            if (!addrs.isEmpty()) {
                ccs.memorizeAddresses(new ArrayList(addrs), (Session)session);
            }
        }
    }

    protected static void triggerContactCollector(ServerSession session, JSONObject mail) {
        ContactCollectorService ccs = ServerServiceRegistry.getInstance().getService(ContactCollectorService.class);
        if (null != ccs) {
            HashSet<InternetAddress> addrs = new HashSet<InternetAddress>();
            try {
                String[] aliases;
                addrs.addAll(Arrays.asList(MessageParser.parseAddressKey(MailJSONField.FROM.getKey(), mail)));
                addrs.addAll(Arrays.asList(MessageParser.parseAddressKey(MailJSONField.RECIPIENT_TO.getKey(), mail)));
                addrs.addAll(Arrays.asList(MessageParser.parseAddressKey(MailJSONField.RECIPIENT_CC.getKey(), mail)));
                addrs.addAll(Arrays.asList(MessageParser.parseAddressKey(MailJSONField.RECIPIENT_BCC.getKey(), mail)));
                HashSet<QuotedInternetAddress> validAddrs = new HashSet<QuotedInternetAddress>(4);
                UserSettingMail usm = session.getUserSettingMail();
                if (usm.getSendAddr() != null && usm.getSendAddr().length() > 0) {
                    validAddrs.add(new QuotedInternetAddress(usm.getSendAddr()));
                }
                User user = UserStorage.getStorageUser(session.getUserId(), session.getContextId());
                validAddrs.add(new QuotedInternetAddress(user.getMail()));
                for (String alias : aliases = user.getAliases()) {
                    validAddrs.add(new QuotedInternetAddress(alias));
                }
                addrs.removeAll(validAddrs);
            }
            catch (AddressException e) {
                LOG.warn((Object)MessageFormat.format("Contact collector could not be triggered: {0}", e.getMessage()), (Throwable)e);
            }
            catch (JSONException e) {
                LOG.warn((Object)MessageFormat.format("Contact collector could not be triggered: {0}", e.getMessage()), (Throwable)e);
            }
            if (!addrs.isEmpty()) {
                ccs.memorizeAddresses(new ArrayList(addrs), (Session)session);
            }
        }
    }

    public static DisplayMode detectDisplayMode(boolean modifyable, String view, UserSettingMail usm) {
        DisplayMode displayMode;
        if (null != view) {
            if (VIEW_RAW.equals(view)) {
                displayMode = DisplayMode.RAW;
            } else if (VIEW_TEXT.equals(view)) {
                usm.setDisplayHtmlInlineContent(false);
                displayMode = modifyable ? DisplayMode.MODIFYABLE : DisplayMode.DISPLAY;
            } else if (VIEW_HTML.equals(view)) {
                usm.setDisplayHtmlInlineContent(true);
                usm.setAllowHTMLImages(true);
                displayMode = modifyable ? DisplayMode.MODIFYABLE : DisplayMode.DISPLAY;
            } else if (VIEW_HTML_BLOCKED_IMAGES.equals(view)) {
                usm.setDisplayHtmlInlineContent(true);
                usm.setAllowHTMLImages(false);
                displayMode = modifyable ? DisplayMode.MODIFYABLE : DisplayMode.DISPLAY;
            } else {
                LOG.warn((Object)new StringAllocator(64).append("Unknown value in parameter ").append("view").append(": ").append(view).append(". Using user's mail settings as fallback."));
                displayMode = modifyable ? DisplayMode.MODIFYABLE : DisplayMode.DISPLAY;
            }
        } else {
            displayMode = modifyable ? DisplayMode.MODIFYABLE : DisplayMode.DISPLAY;
        }
        return displayMode;
    }

    protected static AJAXRequestResult getJSONNullResult() {
        return RESULT_JSON_NULL;
    }

    protected static int resolveFrom2Account(ServerSession session, InternetAddress from, boolean checkTransportSupport, boolean checkFrom) throws OXException {
        int accountId;
        try {
            MailAccountStorageService storageService = ServerServiceRegistry.getInstance().getService(MailAccountStorageService.class, true);
            int user = session.getUserId();
            int cid = session.getContextId();
            if (null == from) {
                accountId = 0;
            } else {
                accountId = storageService.getByPrimaryAddress(from.getAddress(), user, cid);
                if (accountId != -1) {
                    accountId = storageService.getByPrimaryAddress(IDNA.toIDN((String)from.getAddress()), user, cid);
                }
            }
            if (accountId != -1) {
                MailAccount account;
                if (!session.getUserConfiguration().isMultipleMailAccounts() && accountId != 0) {
                    throw MailAccountExceptionCodes.NOT_ENABLED.create(user, cid);
                }
                if (checkTransportSupport && null == (account = storageService.getMailAccount(accountId, user, cid)).getTransportServer()) {
                    throw MailExceptionCode.NO_TRANSPORT_SUPPORT.create(account.getName(), accountId);
                }
            }
        }
        catch (OXException e) {
            throw new OXException(e);
        }
        if (accountId == -1) {
            if (checkFrom && null != from) {
                try {
                    String[] aliases;
                    HashSet<QuotedInternetAddress> validAddrs = new HashSet<QuotedInternetAddress>(4);
                    User user = session.getUser();
                    for (String alias : aliases = user.getAliases()) {
                        validAddrs.add(new QuotedInternetAddress(alias));
                    }
                    if (!validAddrs.contains(from)) {
                        throw MailExceptionCode.INVALID_SENDER.create(from.toString());
                    }
                }
                catch (AddressException e) {
                    throw MimeMailException.handleMessagingException((MessagingException)((Object)e));
                }
            }
            accountId = 0;
        }
        return accountId;
    }

    protected static String getDefaultSendAddress(ServerSession session) throws OXException {
        try {
            MailAccountStorageService storageService = ServerServiceRegistry.getInstance().getService(MailAccountStorageService.class, true);
            return storageService.getDefaultMailAccount(session.getUserId(), session.getContextId()).getPrimaryAddress();
        }
        catch (OXException e) {
            throw new OXException(e);
        }
    }

    protected static boolean isEmpty(String string) {
        if (null == string) {
            return true;
        }
        char[] chars = string.toCharArray();
        boolean isWhitespace = true;
        for (int i = 0; isWhitespace && i < chars.length; ++i) {
            isWhitespace = Character.isWhitespace(chars[i]);
        }
        return isWhitespace;
    }
}

