/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.index;

import com.openexchange.index.IndexField;
import com.openexchange.mail.MailField;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;

public enum MailIndexField implements IndexField
{
    UUID(null),
    TIMESTAMP(null),
    ACCOUNT(MailField.ACCOUNT_NAME),
    FULL_NAME(MailField.FOLDER_ID),
    ID(MailField.ID),
    COLOR_LABEL(MailField.COLOR_LABEL),
    ATTACHMENT(MailField.CONTENT_TYPE),
    RECEIVED_DATE(MailField.RECEIVED_DATE),
    SENT_DATE(MailField.SENT_DATE),
    SIZE(MailField.SIZE),
    FLAG_ANSWERED(MailField.FLAGS),
    FLAG_DELETED(MailField.FLAGS),
    FLAG_DRAFT(MailField.FLAGS),
    FLAG_FLAGGED(MailField.FLAGS),
    FLAG_RECENT(MailField.FLAGS),
    FLAG_SEEN(MailField.FLAGS),
    FLAG_USER(MailField.FLAGS),
    FLAG_SPAM(MailField.FLAGS),
    FLAG_FORWARDED(MailField.FLAGS),
    FLAG_READ_ACK(MailField.FLAGS),
    USER_FLAGS(MailField.FLAGS),
    FROM(MailField.FROM),
    TO(MailField.TO),
    CC(MailField.CC),
    BCC(MailField.BCC),
    SUBJECT(MailField.SUBJECT),
    CONTENT_FLAG(null),
    CONTENT(MailField.BODY);

    private static final Map<MailField, EnumSet<MailIndexField>> reverseMap;
    private final MailField mailField;

    public static Set<MailIndexField> getFor(MailField[] mailFields) {
        EnumSet<MailIndexField> indexFields = EnumSet.noneOf(MailIndexField.class);
        for (MailField mailField : mailFields) {
            EnumSet<MailIndexField> enumSet = reverseMap.get((Object)mailField);
            if (enumSet == null) continue;
            indexFields.addAll(enumSet);
        }
        return indexFields;
    }

    public static MailIndexField getFor(MailField mailField) {
        EnumSet<MailIndexField> enumSet = reverseMap.get((Object)mailField);
        if (enumSet.size() > 0) {
            return (MailIndexField)((Object)enumSet.iterator().next());
        }
        return null;
    }

    private MailIndexField(MailField mailField) {
        this.mailField = mailField;
    }

    public boolean hasMailField() {
        return this.mailField != null;
    }

    public MailField getMailField() {
        return this.mailField;
    }

    static {
        reverseMap = new EnumMap<MailField, EnumSet<MailIndexField>>(MailField.class);
        for (MailIndexField field : MailIndexField.values()) {
            MailField tmpMailField = field.getMailField();
            if (tmpMailField == null) continue;
            EnumSet<MailIndexField> enumSet = reverseMap.get((Object)tmpMailField);
            if (enumSet == null) {
                enumSet = EnumSet.noneOf(MailIndexField.class);
                reverseMap.put(tmpMailField, enumSet);
            }
            enumSet.add(field);
        }
    }
}

