/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.login.internal;

import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.login.LoginRequest;
import com.openexchange.sessiond.AddSessionParameter;
import com.openexchange.sessiond.Parameterized;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

final class AddSessionParameterImpl
implements AddSessionParameter,
Parameterized {
    private final String username;
    private final LoginRequest request;
    private final User user;
    private final Context ctx;
    private final Map<String, Object> parameters = new HashMap<String, Object>(4);

    AddSessionParameterImpl(String username, LoginRequest request, User user, Context ctx) {
        this.username = username;
        this.request = request;
        this.user = user;
        this.ctx = ctx;
    }

    public String getClientIP() {
        return this.request.getClientIP();
    }

    public Context getContext() {
        return this.ctx;
    }

    public String getFullLogin() {
        return this.request.getLogin();
    }

    public String getUserLoginInfo() {
        return this.username;
    }

    public String getPassword() {
        return this.request.getPassword();
    }

    public int getUserId() {
        return this.user.getId();
    }

    public String getAuthId() {
        return this.request.getAuthId();
    }

    public String getHash() {
        return this.request.getHash();
    }

    public String getClient() {
        return this.request.getClient();
    }

    public Set<String> getParameterNames() {
        return this.parameters.keySet();
    }

    public <V> V getParameter(String name) {
        try {
            return (V)this.parameters.get(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setParameter(String name, Object value) {
        if (null == name) {
            this.parameters.remove(name);
        } else {
            this.parameters.put(name, value);
        }
    }

    public Object removeParameter(String name) {
        return this.parameters.remove(name);
    }
}

