/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.i18n.tools;

import com.openexchange.i18n.tools.AbstractTemplate;
import com.openexchange.i18n.tools.RenderMap;
import com.openexchange.i18n.tools.StringHelper;
import com.openexchange.i18n.tools.TemplateReplacement;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import java.util.ArrayList;
import java.util.Locale;

public abstract class CompiledLineParserTemplate
extends AbstractTemplate {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(CompiledLineParserTemplate.class));
    private static final String STR_EMPTY = "";
    private int[][] positions;

    protected CompiledLineParserTemplate() {
    }

    @Override
    public String render(Locale locale, RenderMap renderMap) {
        char[] content = StringHelper.valueOf(locale).getString(this.getContent()).toCharArray();
        if (null == content) {
            return STR_EMPTY;
        }
        if (this.positions == null) {
            this.positions = CompiledLineParserTemplate.load(content);
        }
        StringBuilder result = new StringBuilder(content.length + 1024);
        int off = 0;
        for (int i = 0; i < this.positions.length; ++i) {
            int bracketS = this.positions[i][0];
            int bracketE = this.positions[i][1];
            result.append(content, off, bracketS - off);
            String toReplace = new String(content, bracketS + 1, bracketE - bracketS - 1);
            TemplateReplacement repl = renderMap.get(toReplace);
            if (repl == null) {
                result.append(STR_EMPTY);
            } else {
                result.append(repl.getReplacement());
            }
            off = bracketE + 1;
        }
        if (off < content.length) {
            result.append(content, off, content.length - off);
        }
        return result.toString();
    }

    private static final int[][] load(char[] content) {
        ArrayList<int[]> positions = new ArrayList<int[]>();
        boolean escaped = false;
        int lineCount = 1;
        int columnCount = 1;
        int[] open = null;
        int firstPos = -1;
        block6: for (int i = 0; i < content.length; ++i) {
            char c = content[i];
            switch (c) {
                case '[': {
                    if (escaped) {
                        escaped = false;
                    } else {
                        firstPos = i;
                        open = new int[]{lineCount, columnCount};
                    }
                    ++columnCount;
                    continue block6;
                }
                case ']': {
                    if (escaped) {
                        escaped = false;
                    } else if (firstPos == -1) {
                        LOG.error((Object)("Parser Error: Missing opening bracket in line: " + lineCount), new Throwable());
                        open = null;
                    } else {
                        positions.add(new int[]{firstPos, i});
                        firstPos = -1;
                        open = null;
                    }
                    ++columnCount;
                    continue block6;
                }
                case '\\': {
                    escaped = !escaped;
                    ++columnCount;
                    continue block6;
                }
                case '\n': {
                    ++lineCount;
                    columnCount = 0;
                    continue block6;
                }
                default: {
                    if (escaped) {
                        escaped = false;
                    }
                    ++columnCount;
                }
            }
        }
        if (open != null) {
            LOG.error((Object)("Parser Error: Seems that the bracket opened on line " + (int)open[0] + " column " + (int)open[1] + " is never closed."), new Throwable());
            return new int[0][];
        }
        int[][] positionsArr = new int[positions.size()][];
        for (int i = 0; i < positionsArr.length; ++i) {
            positionsArr[i] = (int[])positions.get(i);
        }
        return positionsArr;
    }

    protected abstract String getContent();
}

