/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.userconfiguration;

import com.openexchange.cache.registry.CacheAvailabilityListener;
import com.openexchange.cache.registry.CacheAvailabilityRegistry;
import com.openexchange.caching.Cache;
import com.openexchange.caching.CacheKey;
import com.openexchange.caching.CacheService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.userconfiguration.RdbUserConfigurationStorage;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.groupware.userconfiguration.UserConfigurationCodes;
import com.openexchange.groupware.userconfiguration.UserConfigurationStorage;
import com.openexchange.log.LogFactory;
import com.openexchange.server.services.ServerServiceRegistry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;

public class CachingUserConfigurationStorage
extends UserConfigurationStorage {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(CachingUserConfigurationStorage.class));
    private static final String CACHE_REGION_NAME = "UserConfiguration";
    private final CacheAvailabilityListener cacheAvailabilityListener;
    private final transient UserConfigurationStorage delegateStorage;
    private final Lock cacheWriteLock = new ReentrantLock();
    private Cache cache;
    private UserConfigurationStorage fallback;

    public CachingUserConfigurationStorage() throws OXException {
        this.delegateStorage = new RdbUserConfigurationStorage();
        this.cacheAvailabilityListener = new CacheAvailabilityListener(){

            @Override
            public void handleAbsence() throws OXException {
                CachingUserConfigurationStorage.this.releaseCache();
            }

            @Override
            public void handleAvailability() throws OXException {
                CachingUserConfigurationStorage.this.initCache();
            }
        };
        this.initCache();
    }

    private UserConfigurationStorage getFallback() {
        if (null == this.fallback) {
            this.fallback = new RdbUserConfigurationStorage();
        }
        return this.fallback;
    }

    @Override
    protected void startInternal() throws OXException {
        CacheAvailabilityRegistry reg = CacheAvailabilityRegistry.getInstance();
        if (null != reg && !reg.registerListener(this.cacheAvailabilityListener)) {
            LOG.error((Object)"Cache availability listener could not be registered", new Throwable());
        }
    }

    @Override
    protected void stopInternal() throws OXException {
        CacheAvailabilityRegistry reg = CacheAvailabilityRegistry.getInstance();
        if (null != reg) {
            reg.unregisterListener(this.cacheAvailabilityListener);
        }
        this.releaseCache();
    }

    private final CacheKey getKey(int userId, Context ctx) {
        return this.cache.newCacheKey(ctx.getContextId(), userId);
    }

    void initCache() throws OXException {
        if (this.cache != null) {
            return;
        }
        try {
            this.cache = ServerServiceRegistry.getInstance().getService(CacheService.class).getCache(CACHE_REGION_NAME);
        }
        catch (RuntimeException e) {
            throw UserConfigurationCodes.CACHE_INITIALIZATION_FAILED.create(e, CACHE_REGION_NAME);
        }
    }

    void releaseCache() throws OXException {
        if (this.cache == null) {
            return;
        }
        try {
            this.cache.clear();
            CacheService cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class);
            if (null != cacheService) {
                cacheService.freeCache(CACHE_REGION_NAME);
            }
        }
        catch (RuntimeException e) {
            throw UserConfigurationCodes.CACHE_INITIALIZATION_FAILED.create(e, CACHE_REGION_NAME);
        }
        finally {
            this.cache = null;
        }
    }

    @Override
    public void setExtendedPermissions(Set<String> extendedPermissions, int userId, Context ctx) {
        if (this.cache == null) {
            return;
        }
        UserConfiguration userConfig = (UserConfiguration)this.cache.get((Serializable)this.getKey(userId, ctx));
        if (null != userConfig) {
            userConfig.setExtendedPermissions(extendedPermissions);
        }
    }

    @Override
    public Object getLock(int userId, Context ctx) {
        try {
            return this.getUserConfiguration(userId, null, ctx);
        }
        catch (OXException e) {
            return new Object();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserConfiguration getUserConfiguration(int userId, int[] groups, Context ctx) throws OXException {
        if (this.cache == null) {
            return this.getFallback().getUserConfiguration(userId, groups, ctx);
        }
        CacheKey key = this.getKey(userId, ctx);
        UserConfiguration userConfig = (UserConfiguration)this.cache.get((Serializable)key);
        if (null == userConfig) {
            this.cacheWriteLock.lock();
            try {
                userConfig = (UserConfiguration)this.cache.get((Serializable)key);
                if (null == userConfig) {
                    userConfig = this.delegateStorage.getUserConfiguration(userId, groups, ctx);
                    this.cache.put((Serializable)key, (Serializable)userConfig);
                }
            }
            catch (RuntimeException rte) {
                UserConfiguration userConfiguration = this.getFallback().getUserConfiguration(userId, groups, ctx);
                return userConfiguration;
            }
            finally {
                this.cacheWriteLock.unlock();
            }
        }
        return (UserConfiguration)userConfig.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserConfiguration[] getUserConfiguration(Context ctx, User[] users) throws OXException {
        UserConfiguration[] userConfigs;
        if (this.cache == null) {
            return this.getFallback().getUserConfiguration(ctx, users);
        }
        ArrayList<User> toLoad = new ArrayList<User>(users.length);
        ArrayList<UserConfiguration> retval = new ArrayList<UserConfiguration>(users.length);
        for (User user : users) {
            UserConfiguration userConfig = (UserConfiguration)this.cache.get((Serializable)this.getKey(user.getId(), ctx));
            if (null == userConfig) {
                toLoad.add(user);
                continue;
            }
            retval.add((UserConfiguration)userConfig.clone());
        }
        for (UserConfiguration userConfig : userConfigs = this.delegateStorage.getUserConfiguration(ctx, toLoad.toArray(new User[toLoad.size()]))) {
            this.cacheWriteLock.lock();
            try {
                this.cache.put((Serializable)this.getKey(userConfig.getUserId(), ctx), (Serializable)userConfig);
            }
            catch (RuntimeException rte) {
                UserConfiguration[] userConfigurationArray = this.getFallback().getUserConfiguration(ctx, users);
                return userConfigurationArray;
            }
            finally {
                this.cacheWriteLock.unlock();
            }
            retval.add((UserConfiguration)userConfig.clone());
        }
        return retval.toArray(new UserConfiguration[retval.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearStorage() throws OXException {
        if (this.cache == null) {
            return;
        }
        this.cacheWriteLock.lock();
        try {
            this.cache.clear();
        }
        catch (RuntimeException rte) {
            LOG.warn((Object)"A runtime error occurred.", (Throwable)rte);
        }
        finally {
            this.cacheWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeUserConfiguration(int userId, Context ctx) throws OXException {
        if (this.cache == null) {
            return;
        }
        this.cacheWriteLock.lock();
        try {
            this.cache.remove((Serializable)this.getKey(userId, ctx));
        }
        catch (RuntimeException rte) {
            LOG.warn((Object)"A runtime error occurred.", (Throwable)rte);
        }
        finally {
            this.cacheWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveUserConfiguration(int permissionBits, int userId, Context ctx) throws OXException {
        this.delegateStorage.saveUserConfiguration(permissionBits, userId, ctx);
        this.cacheWriteLock.lock();
        try {
            this.cache.remove((Serializable)this.getKey(userId, ctx));
        }
        catch (RuntimeException rte) {
            LOG.warn((Object)"A runtime error occurred.", (Throwable)rte);
        }
        finally {
            this.cacheWriteLock.unlock();
        }
    }
}

