/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.upload.quotachecker;

import com.openexchange.configuration.ServerConfig;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.upload.impl.UploadQuotaChecker;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.usersetting.UserSettingMail;
import com.openexchange.mail.usersetting.UserSettingMailStorage;
import com.openexchange.session.Session;

public final class MailUploadQuotaChecker
extends UploadQuotaChecker {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(MailUploadQuotaChecker.class));
    private final long uploadQuota;
    private final long uploadQuotaPerFile;

    public MailUploadQuotaChecker(UserSettingMail settings) {
        if (settings.getUploadQuota() > 0L) {
            this.uploadQuota = settings.getUploadQuota();
        } else if (settings.getUploadQuota() == 0L) {
            this.uploadQuota = -1L;
        } else {
            int globalQuota;
            try {
                globalQuota = ServerConfig.getInt(ServerConfig.Property.MAX_UPLOAD_SIZE);
            }
            catch (OXException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                globalQuota = 0;
            }
            this.uploadQuota = globalQuota > 0 ? (long)globalQuota : -1L;
        }
        this.uploadQuotaPerFile = settings.getUploadQuotaPerFile() > 0L ? settings.getUploadQuotaPerFile() : -1L;
    }

    public MailUploadQuotaChecker(Session session, Context ctx) {
        UserSettingMail settings = UserSettingMailStorage.getInstance().getUserSettingMail(session.getUserId(), ctx);
        if (settings.getUploadQuota() > 0L) {
            this.uploadQuota = settings.getUploadQuota();
        } else if (settings.getUploadQuota() == 0L) {
            this.uploadQuota = -1L;
        } else {
            int globalQuota;
            try {
                globalQuota = ServerConfig.getInt(ServerConfig.Property.MAX_UPLOAD_SIZE);
            }
            catch (OXException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                globalQuota = 0;
            }
            this.uploadQuota = globalQuota > 0 ? (long)globalQuota : -1L;
        }
        this.uploadQuotaPerFile = settings.getUploadQuotaPerFile() > 0L ? settings.getUploadQuotaPerFile() : -1L;
    }

    @Override
    public long getFileQuotaMax() {
        return this.uploadQuotaPerFile;
    }

    @Override
    public long getQuotaMax() {
        return this.uploadQuota;
    }
}

