/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.Schema;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTask;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class TaskReminderFolderZero
implements UpdateTask {
    private static final String SELECT_REMINDER = "SELECT cid,object_id,target_id,userid,folder FROM reminder WHERE module=4";
    private static final String SELECT_FOLDER = "SELECT folder FROM task_folder WHERE cid=? AND id=? AND user=?";
    private static final String UPDATE_REMINDER = "UPDATE reminder SET folder=? WHERE cid=? AND object_id=?";
    private static final String DELETE_REMINDER = "DELETE FROM reminder WHERE cid=? AND object_id=?";
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(TaskReminderFolderZero.class));

    @Override
    public int addedWithVersion() {
        return 6;
    }

    @Override
    public int getPriority() {
        return UpdateTask.UpdateTaskPriority.LOW.priority;
    }

    @Override
    public void perform(Schema schema, int contextId) throws OXException {
        LOG.info((Object)"Performing update task TaskReminderFolderZero.");
        List<ReminderData> reminders = this.getReminder(contextId);
        ArrayList<ReminderData> update = new ArrayList<ReminderData>();
        ArrayList<ReminderData> remove = new ArrayList<ReminderData>();
        for (ReminderData remind : reminders) {
            int folder = this.findFolder(remind.cid, remind.targetId, remind.userid);
            if (-1 == folder) {
                remove.add(remind);
                continue;
            }
            if (remind.folder == folder) continue;
            remind.folder = folder;
            update.add(remind);
        }
        LOG.info((Object)("Fixing " + update.size() + " reminder and removing " + remove.size() + " not fixable reminder."));
        Connection con = Database.get(contextId, true);
        try {
            con.setAutoCommit(false);
            this.update(con, update);
            this.delete(con, remove);
            con.commit();
        }
        catch (SQLException e) {
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        finally {
            try {
                con.setAutoCommit(true);
            }
            catch (SQLException e) {
                LOG.error((Object)"Problem setting autocommit to true.", (Throwable)e);
            }
            Database.back(contextId, true, con);
        }
        LOG.info((Object)"Update task TaskReminderFolderZero all DONE.");
    }

    private List<ReminderData> getReminder(int contextId) throws OXException {
        ArrayList<ReminderData> retval = new ArrayList<ReminderData>();
        Connection con = Database.get(contextId, false);
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            stmt = con.prepareStatement(SELECT_REMINDER);
            result = stmt.executeQuery();
            while (result.next()) {
                ReminderData remind = new ReminderData();
                int pos = 1;
                remind.cid = result.getInt(pos++);
                remind.reminderId = result.getInt(pos++);
                remind.targetId = result.getInt(pos++);
                remind.userid = result.getInt(pos++);
                remind.folder = result.getInt(pos++);
                retval.add(remind);
            }
        }
        catch (SQLException e) {
            try {
                throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                Database.back(contextId, false, con);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        Database.back(contextId, false, con);
        return retval;
    }

    private int findFolder(int contextId, int taskId, int userId) throws OXException {
        Connection con = Database.get(contextId, false);
        int retval = -1;
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            stmt = con.prepareStatement(SELECT_FOLDER);
            stmt.setInt(1, contextId);
            stmt.setInt(2, taskId);
            stmt.setInt(3, userId);
            result = stmt.executeQuery();
            if (result.next()) {
                retval = result.getInt(1);
            }
        }
        catch (SQLException e) {
            try {
                throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                Database.back(contextId, false, con);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        Database.back(contextId, false, con);
        return retval;
    }

    private int update(Connection con, List<ReminderData> update) throws OXException {
        int retval = 0;
        PreparedStatement stmt = null;
        try {
            int[] updated;
            stmt = con.prepareStatement(UPDATE_REMINDER);
            for (ReminderData remind : update) {
                stmt.setInt(1, remind.folder);
                stmt.setInt(2, remind.cid);
                stmt.setInt(3, remind.reminderId);
                stmt.addBatch();
            }
            for (int i : updated = stmt.executeBatch()) {
                retval += i;
            }
        }
        catch (SQLException e) {
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.closeSQLStuff(null, stmt);
        }
        if (retval != update.size()) {
            LOG.error((Object)(String.valueOf(update.size()) + " reminder should be changed, but only " + retval + " have been changed."));
        }
        return retval;
    }

    private int delete(Connection con, List<ReminderData> remove) throws OXException {
        int retval = 0;
        PreparedStatement stmt = null;
        try {
            int[] removed;
            stmt = con.prepareStatement(DELETE_REMINDER);
            for (ReminderData remind : remove) {
                stmt.setInt(1, remind.cid);
                stmt.setInt(2, remind.reminderId);
                stmt.addBatch();
            }
            for (int i : removed = stmt.executeBatch()) {
                retval += i;
            }
        }
        catch (SQLException e) {
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.closeSQLStuff(null, stmt);
        }
        if (retval != remove.size()) {
            LOG.error((Object)(String.valueOf(remove.size()) + " reminder should be removed, but only " + retval + " have been removed."));
        }
        return retval;
    }

    private class ReminderData {
        private int cid;
        private int reminderId;
        private int targetId;
        private int userid;
        private int folder;

        private ReminderData() {
        }
    }
}

