/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.log.Log;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import org.apache.commons.logging.LogFactory;

public final class DListAddIndexForLookup
extends UpdateTaskAdapter {
    @Override
    public String[] getDependencies() {
        return new String[0];
    }

    @Override
    public void perform(PerformParameters params) throws OXException {
        int contextId = params.getContextId();
        Connection con = Database.getNoTimeout(contextId, true);
        try {
            con.setAutoCommit(false);
            String[] tables = new String[]{"prg_dlist", "del_dlist"};
            this.createDListIndex(con, tables, "userIndex", "intfield02", "intfield03");
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.UPDATE_FAILED.create(e, params.getSchema().getSchema(), e.getMessage());
        }
        finally {
            DBUtils.autocommit(con);
            Database.backNoTimeout(contextId, true, con);
        }
    }

    private void createDListIndex(Connection con, String[] tables, String name, String ... columns) throws SQLException {
        org.apache.commons.logging.Log log = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(DListAddIndexForLookup.class));
        Object[] cols = new String[columns.length + 1];
        cols[0] = "cid";
        System.arraycopy(columns, 0, cols, 1, columns.length);
        StringBuilder sb = new StringBuilder(64);
        for (String table : tables) {
            String indexName = Tools.existsIndex(con, table, (String[])cols);
            if (null == indexName) {
                if (log.isInfoEnabled()) {
                    sb.setLength(0);
                    sb.append("Creating new index named \"");
                    sb.append(name);
                    sb.append("\" with columns ");
                    sb.append(Arrays.toString(cols));
                    sb.append(" on table ");
                    sb.append(table);
                    sb.append('.');
                    log.info((Object)sb.toString());
                }
                Tools.createIndex(con, table, name, (String[])cols, false);
                continue;
            }
            if (!log.isInfoEnabled()) continue;
            sb.setLength(0);
            sb.append("New index named \"");
            sb.append(indexName);
            sb.append("\" with columns ");
            sb.append(Arrays.toString(cols));
            sb.append(" already exists on table ");
            sb.append(table);
            sb.append('.');
            log.info((Object)sb.toString());
        }
    }
}

