/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.impl.ContextExtended;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.update.Schema;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTask;
import com.openexchange.log.LogFactory;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.logging.Log;

public final class ContactsGlobalMoveUpdateTask
implements UpdateTask {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(ContactsGlobalMoveUpdateTask.class));
    private static final String STR_INFO = "Performing update task 'ContactsGlobalMoveUpdateTask'";
    private static final String SQL_QUERY = "SELECT created_from,cid,intfield01 FROM prg_contacts WHERE fid = 6 AND userid is NULL";

    @Override
    public int addedWithVersion() {
        return 16;
    }

    @Override
    public int getPriority() {
        return UpdateTask.UpdateTaskPriority.HIGHEST.priority;
    }

    @Override
    public void perform(Schema schema, int contextId) throws OXException {
        this.correctTable("prg_contacts", contextId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void correctTable(String sqltable, int contextId) throws OXException {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)STR_INFO);
        }
        Connection writeCon = null;
        Statement stmt = null;
        Statement st = null;
        ResultSet resultSet = null;
        FolderObject des = null;
        try {
            writeCon = Database.get(contextId, true);
            try {
                st = writeCon.createStatement();
                ContextExtended ct = null;
                OXFolderAccess oxa = null;
                resultSet = st.executeQuery(SQL_QUERY);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"UPDATING WRONG GLOBAL ADDRESSBOOK CONTACTS: MOVING BACK TO OWNER'S PRIVATE ADDRESSBOOK");
                }
                while (resultSet.next()) {
                    int creator = resultSet.getInt(1);
                    int cid = resultSet.getInt(2);
                    int id = resultSet.getInt(3);
                    ct = ContextStorage.getInstance().loadContext(cid);
                    oxa = new OXFolderAccess(writeCon, ct);
                    des = oxa.getDefaultFolder(creator, 3);
                    if (LOG.isWarnEnabled()) {
                        LOG.warn((Object)("UPDATING OPBJECT " + id + " IN CONTEXT " + cid + " MOVING TO " + des.getObjectID()));
                    }
                    StringBuilder sb = new StringBuilder("UPDATE prg_contacts SET fid = ");
                    sb.append(des.getObjectID());
                    sb.append(" , changing_date = ");
                    sb.append(System.currentTimeMillis());
                    sb.append(" , changed_from = ");
                    sb.append(ct.getMailadmin());
                    sb.append(" WHERE cid = ");
                    sb.append(cid);
                    sb.append(" AND intfield01 = ");
                    sb.append(id);
                    st.addBatch(sb.toString());
                }
                st.executeBatch();
                st.close();
            }
            catch (SQLException e) {
                throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
            }
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(resultSet, stmt);
            DBUtils.closeSQLStuff(null, st);
            if (writeCon != null) {
                Database.back(contextId, true, writeCon);
            }
            throw throwable;
        }
        DBUtils.closeSQLStuff(resultSet, stmt);
        DBUtils.closeSQLStuff(null, st);
        if (writeCon != null) {
            Database.back(contextId, true, writeCon);
        }
    }
}

