/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update;

import com.openexchange.database.DatabaseService;
import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Column;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.SQLException;

public abstract class ExtendedColumnCreationTask
extends UpdateTaskAdapter {
    private final DatabaseService dbService;

    protected ExtendedColumnCreationTask(DatabaseService dbService) {
        this.dbService = dbService;
    }

    @Override
    public void perform(PerformParameters params) throws OXException {
        int cid = params.getContextId();
        Connection con = this.dbService.getForUpdateTask(cid);
        try {
            con.setAutoCommit(false);
            Tools.checkAndAddColumns(con, this.getTableName(), this.getColumns());
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(con);
            Database.backNoTimeout(cid, true, con);
        }
    }

    protected abstract String getTableName();

    protected abstract Column[] getColumns();
}

