/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.tasks;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.tasks.SQL;
import com.openexchange.groupware.tasks.StorageType;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.groupware.tasks.TaskExceptionCode;
import com.openexchange.groupware.tasks.TaskIterator2;
import com.openexchange.groupware.tasks.TaskSearch;
import com.openexchange.tools.Collections;
import com.openexchange.tools.iterator.CombinedSearchIterator;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;

public class RdbTaskSearch
extends TaskSearch {
    RdbTaskSearch() {
    }

    @Override
    int[] findUserTasks(Context ctx, Connection con, int userId, StorageType type) throws OXException {
        PreparedStatement stmt = null;
        ResultSet result = null;
        ArrayList<Integer> tasks2 = new ArrayList<Integer>();
        try {
            stmt = con.prepareStatement(SQL.SEARCH_USER_TASKS.get((Object)type));
            int pos = 1;
            stmt.setInt(pos++, ctx.getContextId());
            stmt.setInt(pos++, userId);
            stmt.setInt(pos++, userId);
            result = stmt.executeQuery();
            while (result.next()) {
                tasks2.add(result.getInt(1));
            }
        }
        catch (SQLException e) {
            try {
                throw TaskExceptionCode.SQL_ERROR.create(e, new Object[0]);
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        return Collections.toArray(tasks2);
    }

    @Override
    SearchIterator<Task> listModifiedTasks(final Context ctx, final int folderId, StorageType type, int[] columns, final Date since, final boolean onlyOwn, final int userId, boolean noPrivate) throws OXException {
        StringBuilder sql1 = new StringBuilder();
        sql1.append("SELECT ");
        sql1.append(SQL.getFields(columns, false));
        sql1.append(" FROM ");
        String taskTable = SQL.TASK_TABLES.get((Object)type);
        sql1.append(taskTable);
        sql1.append(" JOIN ");
        String folderTable = SQL.FOLDER_TABLES.get((Object)type);
        sql1.append(folderTable);
        sql1.append(" USING (cid,id) WHERE ");
        sql1.append(taskTable);
        sql1.append(".cid=? AND ");
        sql1.append(folderTable);
        sql1.append(".folder=? AND ");
        sql1.append(taskTable);
        sql1.append(".last_modified>?");
        if (onlyOwn) {
            sql1.append(" AND ");
            sql1.append(SQL.getOnlyOwn(taskTable));
        }
        if (noPrivate) {
            sql1.append(" AND ");
            sql1.append(SQL.getNoPrivate(taskTable));
        }
        TaskIterator2 iter1 = new TaskIterator2(ctx, userId, sql1.toString(), new TaskIterator2.StatementSetter(){

            @Override
            public void perform(PreparedStatement stmt) throws SQLException {
                int pos = 1;
                stmt.setInt(pos++, ctx.getContextId());
                stmt.setInt(pos++, folderId);
                stmt.setLong(pos++, since.getTime());
                if (onlyOwn) {
                    stmt.setInt(pos++, userId);
                }
            }
        }, folderId, columns, type);
        if (StorageType.DELETED == type) {
            StringBuilder sql2 = new StringBuilder();
            sql2.append("SELECT ");
            sql2.append(SQL.getFields(columns, false));
            sql2.append(" FROM ");
            String activeTaskTable = SQL.TASK_TABLES.get((Object)StorageType.ACTIVE);
            sql2.append(activeTaskTable);
            sql2.append(" JOIN ");
            String removedPartsTable = SQL.PARTS_TABLES.get((Object)StorageType.REMOVED);
            sql2.append(removedPartsTable);
            sql2.append(" ON ");
            sql2.append(activeTaskTable);
            sql2.append(".cid=");
            sql2.append(removedPartsTable);
            sql2.append(".cid AND ");
            sql2.append(activeTaskTable);
            sql2.append(".id=");
            sql2.append(removedPartsTable);
            sql2.append(".task ");
            sql2.append("WHERE ");
            sql2.append(activeTaskTable);
            sql2.append(".cid=? AND ");
            sql2.append(removedPartsTable);
            sql2.append(".folder=? AND ");
            sql2.append(activeTaskTable);
            sql2.append(".last_modified>?");
            if (onlyOwn) {
                sql2.append(" AND ");
                sql2.append(SQL.getOnlyOwn(activeTaskTable));
            }
            if (noPrivate) {
                sql2.append(" AND ");
                sql2.append(SQL.getNoPrivate(activeTaskTable));
            }
            TaskIterator2 iter2 = new TaskIterator2(ctx, userId, sql2.toString(), new TaskIterator2.StatementSetter(){

                @Override
                public void perform(PreparedStatement stmt) throws SQLException {
                    int pos = 1;
                    stmt.setInt(pos++, ctx.getContextId());
                    stmt.setInt(pos++, folderId);
                    stmt.setLong(pos++, since.getTime());
                    if (onlyOwn) {
                        stmt.setInt(pos++, userId);
                    }
                }
            }, folderId, columns, StorageType.REMOVED);
            return new CombinedSearchIterator(new SearchIterator[]{iter1, iter2});
        }
        return iter1;
    }
}

