/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.tasks;

import com.openexchange.event.impl.EventClient;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.tasks.Folder;
import com.openexchange.groupware.tasks.FolderStorage;
import com.openexchange.groupware.tasks.InternalParticipant;
import com.openexchange.groupware.tasks.Mapper;
import com.openexchange.groupware.tasks.Mapping;
import com.openexchange.groupware.tasks.ParticipantStorage;
import com.openexchange.groupware.tasks.StorageType;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.groupware.tasks.TaskExceptionCode;
import com.openexchange.groupware.tasks.TaskLogic;
import com.openexchange.groupware.tasks.TaskParticipant;
import com.openexchange.groupware.tasks.TaskStorage;
import com.openexchange.groupware.tasks.UpdateData;
import com.openexchange.java.Autoboxing;
import com.openexchange.server.impl.DBPool;
import com.openexchange.session.Session;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.Set;

public final class ConfirmTask {
    private static final TaskStorage storage = TaskStorage.getInstance();
    private static final FolderStorage foldStor = FolderStorage.getInstance();
    private static final ParticipantStorage partStor = ParticipantStorage.getInstance();
    private static final int[] CHANGED_ATTRIBUTES = new int[]{5, 3};
    private final Context ctx;
    private final int taskId;
    private final int userId;
    private final int confirm;
    private final String message;
    private Task origTask;
    private Set<TaskParticipant> participants;
    private Set<Folder> folders;
    private Task changedTask;
    private InternalParticipant origParticipant;
    private InternalParticipant changedParticipant;
    private final boolean filledTask = false;

    ConfirmTask(Context ctx, int taskId, int userId, int confirm, String message) {
        this.ctx = ctx;
        this.taskId = taskId;
        this.userId = userId;
        this.confirm = confirm;
        this.message = message;
    }

    void prepare() throws OXException {
        this.getOrigTask();
        this.changedParticipant = this.getOrigParticipant();
        this.changedParticipant.setConfirm(this.confirm);
        this.changedParticipant.setConfirmMessage(this.message);
        this.changedTask = new Task();
        this.changedTask.setObjectID(this.taskId);
        this.changedTask.setModifiedBy(this.userId);
        this.changedTask.setLastModified(new Date());
    }

    void doConfirmation() throws OXException {
        Connection con = DBPool.pickupWriteable(this.ctx);
        try {
            con.setAutoCommit(false);
            partStor.updateInternal(this.ctx, con, this.taskId, this.changedParticipant, StorageType.ACTIVE);
            UpdateData.updateTask(this.ctx, con, this.changedTask, this.getOrigTask().getLastModified(), CHANGED_ATTRIBUTES, null, null, null, null);
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw TaskExceptionCode.SQL_ERROR.create(e, new Object[0]);
        }
        finally {
            DBUtils.autocommit(con);
            DBPool.closeWriterSilent(this.ctx, con);
        }
    }

    void sentEvent(Session session) throws OXException {
        Task orig = this.getOrigTask();
        if (this.userId != orig.getCreatedBy() && null == ParticipantStorage.getParticipant(ParticipantStorage.extractInternal(this.getParticipants()), orig.getCreatedBy())) {
            Folder delegatorFolder = FolderStorage.extractFolderOfUser(this.getFolders(), orig.getCreatedBy());
            orig.setParentFolderID(delegatorFolder.getIdentifier());
            orig.setUsers(new UserParticipant[0]);
            orig.setParticipants(new Participant[0]);
        }
        EventClient eventClient = new EventClient(session);
        switch (this.changedParticipant.getConfirm()) {
            case 1: {
                eventClient.accept(orig, this.getFilledChangedTask());
                break;
            }
            case 2: {
                eventClient.declined(orig, this.getFilledChangedTask());
                break;
            }
            case 3: {
                eventClient.tentative(orig, this.getFilledChangedTask());
            }
        }
    }

    Date getLastModified() {
        return this.changedTask.getLastModified();
    }

    private Task getOrigTask() throws OXException {
        if (null == this.origTask) {
            this.origTask = storage.selectTask(this.ctx, this.taskId, StorageType.ACTIVE);
        }
        return this.origTask;
    }

    private InternalParticipant getOrigParticipant() throws OXException {
        if (null == this.origParticipant) {
            this.origParticipant = ParticipantStorage.getParticipant(ParticipantStorage.extractInternal(this.getParticipants()), this.userId);
            if (null == this.origParticipant) {
                throw TaskExceptionCode.PARTICIPANT_NOT_FOUND.create(Autoboxing.I((int)this.userId), Autoboxing.I((int)this.taskId));
            }
        }
        return this.origParticipant;
    }

    private Set<TaskParticipant> getParticipants() throws OXException {
        if (null == this.participants) {
            this.participants = partStor.selectParticipants(this.ctx, this.taskId, StorageType.ACTIVE);
        }
        return this.participants;
    }

    private Set<Folder> getFolders() throws OXException {
        if (null == this.folders) {
            this.folders = foldStor.selectFolder(this.ctx, this.taskId, StorageType.ACTIVE);
        }
        return this.folders;
    }

    private Task getFilledChangedTask() throws OXException {
        Task oldTask = this.getOrigTask();
        for (Mapper<? extends Object> mapper : Mapping.MAPPERS) {
            if (mapper.isSet(this.changedTask) || !mapper.isSet(this.getOrigTask())) continue;
            mapper.set(this.changedTask, mapper.get(this.getOrigTask()));
        }
        this.changedTask.setParticipants(TaskLogic.createParticipants(this.getParticipants()));
        this.changedTask.setUsers(TaskLogic.createUserParticipants(this.getParticipants()));
        Folder folder = FolderStorage.extractFolderOfUser(this.getFolders(), this.userId);
        if (null == folder) {
            if (this.getFolders().isEmpty()) {
                throw TaskExceptionCode.MISSING_FOLDER.create(Autoboxing.I((int)this.taskId));
            }
            folder = this.getFolders().iterator().next();
        }
        this.changedTask.setParentFolderID(folder.getIdentifier());
        return this.changedTask;
    }
}

