/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.settings.tree.folder;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.settings.IValueHandler;
import com.openexchange.groupware.settings.PreferencesItemService;
import com.openexchange.groupware.settings.ReadOnlyValue;
import com.openexchange.groupware.settings.Setting;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.session.Session;
import com.openexchange.tools.oxfolder.OXFolderAccess;

public class Calendar
implements PreferencesItemService {
    @Override
    public String[] getPath() {
        return new String[]{"folder", "calendar"};
    }

    @Override
    public IValueHandler getSharedValue() {
        return new ReadOnlyValue(){

            @Override
            public boolean isAvailable(UserConfiguration userConfig) {
                return userConfig.hasCalendar();
            }

            @Override
            public void getValue(Session session, Context ctx, User user, UserConfiguration userConfig, Setting setting) throws OXException {
                OXFolderAccess acc = new OXFolderAccess(ctx);
                try {
                    setting.setSingleValue(acc.getDefaultFolder(user.getId(), 2).getObjectID());
                }
                catch (OXException e) {
                    throw new OXException(e);
                }
            }
        };
    }
}

