/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.modules;

import java.util.HashMap;
import java.util.Map;

public enum Module {
    TASK("tasks", 1),
    CALENDAR("calendar", 2),
    CONTACTS("contacts", 3),
    UNBOUND("unbound", 4),
    MAIL("mail", 7),
    PROJECT("projects", 6),
    INFOSTORE("infostore", 8),
    SYSTEM("system", 5);

    private static Map<Integer, Module> folderConstant2Module;
    private String name;
    private int folderConstant;

    private Module(String name, int folderConstant) {
        this.name = name;
        this.folderConstant = folderConstant;
    }

    public static Module getForFolderConstant(int constant) {
        return folderConstant2Module.get(constant);
    }

    public String getName() {
        return this.name;
    }

    public int getFolderConstant() {
        return this.folderConstant;
    }

    public static final String getModuleString(int module, int objectId) {
        String moduleStr = null;
        switch (module) {
            case 1: {
                moduleStr = TASK.getName();
                break;
            }
            case 3: {
                moduleStr = CONTACTS.getName();
                break;
            }
            case 2: {
                moduleStr = CALENDAR.getName();
                break;
            }
            case 4: {
                moduleStr = UNBOUND.getName();
                break;
            }
            case 7: {
                moduleStr = MAIL.getName();
                break;
            }
            case 6: {
                moduleStr = PROJECT.getName();
                break;
            }
            case 8: {
                moduleStr = INFOSTORE.getName();
                break;
            }
            case 5: {
                if (objectId == 8) {
                    moduleStr = PROJECT.getName();
                    break;
                }
                if (objectId == 9) {
                    moduleStr = INFOSTORE.getName();
                    break;
                }
                moduleStr = SYSTEM.getName();
                break;
            }
            default: {
                moduleStr = "";
            }
        }
        return moduleStr;
    }

    public static final int getModuleInteger(String moduleStr) {
        for (Module module : Module.values()) {
            if (!module.getName().equalsIgnoreCase(moduleStr)) continue;
            return module.folderConstant;
        }
        return -1;
    }

    static {
        folderConstant2Module = new HashMap<Integer, Module>();
        for (Module module : Module.values()) {
            folderConstant2Module.put(module.folderConstant, module);
        }
    }
}

