/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.downgrade;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.CalendarAdministrationService;
import com.openexchange.groupware.downgrade.DowngradeEvent;
import com.openexchange.groupware.downgrade.DowngradeListener;
import com.openexchange.groupware.infostore.InfostoreDowngrade;
import com.openexchange.groupware.tasks.TasksDowngrade;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.oxfolder.downgrade.OXFolderDowngradeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class DowngradeRegistry {
    private static final Comparator<DowngradeListener> COMPARATOR = new Comparator<DowngradeListener>(){

        @Override
        public int compare(DowngradeListener o1, DowngradeListener o2) {
            if (o1.getOrder() > o2.getOrder()) {
                return 1;
            }
            if (o1.getOrder() < o2.getOrder()) {
                return -1;
            }
            return 0;
        }
    };
    private static volatile DowngradeRegistry instance;
    private final Set<Class<? extends DowngradeListener>> classes;
    private final List<DowngradeListener> listeners;
    private final Lock registryLock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void initInstance() {
        Class<DowngradeRegistry> clazz = DowngradeRegistry.class;
        synchronized (DowngradeRegistry.class) {
            if (instance == null) {
                instance = new DowngradeRegistry();
                instance.init();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void releaseInstance() {
        Class<DowngradeRegistry> clazz = DowngradeRegistry.class;
        synchronized (DowngradeRegistry.class) {
            if (instance != null) {
                instance = null;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static DowngradeRegistry getInstance() {
        return instance;
    }

    private void init() {
        this.registerDowngradeListener(ServerServiceRegistry.getInstance().getService(CalendarAdministrationService.class).getDowngradeListener());
        this.registerDowngradeListener(new InfostoreDowngrade());
        this.registerDowngradeListener(new TasksDowngrade());
        this.registerDowngradeListener(new OXFolderDowngradeListener());
    }

    private DowngradeRegistry() {
        this.listeners = new ArrayList<DowngradeListener>();
        this.classes = new HashSet<Class<? extends DowngradeListener>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireDowngradeEvent(DowngradeEvent downgradeEvent) throws OXException {
        this.registryLock.lock();
        try {
            int size = this.listeners.size();
            Iterator<DowngradeListener> iter = this.listeners.iterator();
            for (int i = 0; i < size; ++i) {
                iter.next().downgradePerformed(downgradeEvent);
            }
        }
        finally {
            this.registryLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerDowngradeListener(DowngradeListener listener) {
        this.registryLock.lock();
        try {
            if (this.classes.contains(listener.getClass())) {
                boolean bl = false;
                return bl;
            }
            this.listeners.add(listener);
            Collections.sort(this.listeners, COMPARATOR);
            this.classes.add(listener.getClass());
            boolean bl = true;
            return bl;
        }
        finally {
            this.registryLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterDowngradeListener(DowngradeListener listener) {
        this.registryLock.lock();
        try {
            Class<?> clazz = listener.getClass();
            if (!this.classes.contains(clazz)) {
                return;
            }
            if (!this.listeners.remove(listener)) {
                int size = this.listeners.size();
                for (int i = 0; i < size; ++i) {
                    if (!clazz.equals(this.listeners.get(i).getClass())) continue;
                    this.listeners.remove(i);
                    size = 0;
                }
            }
            this.classes.remove(clazz);
        }
        finally {
            this.registryLock.unlock();
        }
    }
}

