/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.datahandler;

import com.openexchange.api2.AppointmentSQLInterface;
import com.openexchange.configuration.ServerConfig;
import com.openexchange.conversion.DataExceptionCodes;
import com.openexchange.conversion.DataHandler;
import com.openexchange.data.conversion.ical.ConversionError;
import com.openexchange.data.conversion.ical.ConversionWarning;
import com.openexchange.data.conversion.ical.ICalParser;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.AppointmentSqlFactoryService;
import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.groupware.calendar.OXCalendarExceptionCodes;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.datahandler.ICalInsertDataHandler;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.groupware.tasks.TasksSQLImpl;
import com.openexchange.log.LogFactory;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import com.openexchange.tools.stream.UnsynchronizedByteArrayInputStream;
import com.openexchange.tools.stream.UnsynchronizedByteArrayOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class ICalDataHandler
implements DataHandler {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(ICalInsertDataHandler.class));
    private static final int LIMIT = 0x100000;

    protected void insertTasks(Session session, int taskFolder, List<Task> tasks2, JSONArray folderAndIdArray) throws OXException, JSONException {
        TasksSQLImpl taskSql = new TasksSQLImpl(session);
        for (Task task : tasks2) {
            task.setParentFolderID(taskFolder);
            taskSql.insertTaskObject(task);
            folderAndIdArray.put((Object)new JSONObject().put("folder_id", taskFolder).put("id", task.getObjectID()));
        }
    }

    protected void insertAppointments(Session session, int calendarFolder, Context ctx, List<CalendarDataObject> appointments, Confirm confirm, JSONArray folderAndIdArray) throws OXException, JSONException, OXException {
        AppointmentSQLInterface appointmentSql = ServerServiceRegistry.getInstance().getService(AppointmentSqlFactoryService.class).createAppointmentSql(session);
        for (CalendarDataObject appointment : appointments) {
            String uid;
            appointment.setContext(ctx);
            if (confirm != null) {
                this.setConfirmation(session, appointment, confirm);
            }
            int objectId = 0;
            if (appointment.containsUid() && (uid = appointment.getUid()) != null) {
                objectId = appointmentSql.resolveUid(uid);
            }
            if (objectId != 0) {
                if (confirm != null) {
                    try {
                        this.updateOwnParticipantStatus(session, ctx, objectId, confirm, appointmentSql);
                    }
                    catch (OXException e) {
                        if (e.isGeneric(OXException.Generic.NO_PERMISSION)) {
                            this.handleWithoutPermission(session, appointment, calendarFolder, confirm, appointmentSql);
                        }
                        throw e;
                    }
                }
                appointment.setObjectID(objectId);
                appointment.setIgnoreConflicts(true);
                this.updateAppointment(appointment, calendarFolder, appointmentSql);
                folderAndIdArray.put((Object)new JSONObject().put("folder_id", calendarFolder).put("id", objectId));
                continue;
            }
            appointment.setParentFolderID(calendarFolder);
            appointment.setIgnoreConflicts(true);
            appointmentSql.insertAppointmentObject(appointment);
            folderAndIdArray.put((Object)new JSONObject().put("folder_id", calendarFolder).put("id", appointment.getObjectID()));
        }
    }

    private void updateAppointment(CalendarDataObject appointment, int calendarFolder, AppointmentSQLInterface appointmentSql) throws OXException {
        try {
            CalendarDataObject loadAppointment = appointmentSql.getObjectById(appointment.getObjectID(), calendarFolder);
            if (loadAppointment.getSequence() >= appointment.getSequence()) {
                return;
            }
        }
        catch (SQLException e) {
            throw OXCalendarExceptionCodes.CALENDAR_SQL_ERROR.create(e, new Object[0]);
        }
        appointmentSql.updateAppointmentObject(appointment, calendarFolder, new Date());
    }

    private void handleWithoutPermission(Session session, CalendarDataObject appointment, int calendarFolder, Confirm confirm, AppointmentSQLInterface appointmentSql) throws OXException {
        appointment.removeUid();
        appointment.removeObjectID();
        appointment.removeUsers();
        appointment.removeParticipants();
        appointment.setParentFolderID(calendarFolder);
        UserParticipant self = new UserParticipant(session.getUserId());
        self.setConfirm(confirm.getConfirm());
        self.setConfirmMessage(confirm.getConfirmMessage());
        appointment.setUsers(new UserParticipant[]{self});
        appointmentSql.insertAppointmentObject(appointment);
    }

    private void updateOwnParticipantStatus(Session session, Context ctx, int objectId, Confirm confirm, AppointmentSQLInterface appSql) throws OXException, OXException {
        block6: {
            FolderObject calendarFolder = new OXFolderAccess(ctx).getDefaultFolder(session.getUserId(), 2);
            try {
                CalendarDataObject loadedObject = appSql.getObjectById(objectId, calendarFolder.getObjectID());
                UserParticipant[] users = loadedObject.getUsers();
                boolean found = false;
                for (UserParticipant user : users) {
                    if (user.getIdentifier() != session.getUserId()) continue;
                    found = true;
                    break;
                }
                if (found) {
                    try {
                        appSql.setUserConfirmation(objectId, calendarFolder.getObjectID(), session.getUserId(), confirm.getConfirm(), confirm.getConfirmMessage());
                        break block6;
                    }
                    catch (OXException e) {
                        throw DataExceptionCodes.UNABLE_TO_CHANGE_DATA.create(new Object[]{"Error during confirmation update."});
                    }
                }
                throw DataExceptionCodes.UNABLE_TO_CHANGE_DATA.create(new Object[]{"Object already exists, but user is not participant."});
            }
            catch (SQLException e) {
                throw DataExceptionCodes.ERROR.create((Throwable)e, new Object[]{e.getMessage()});
            }
        }
    }

    private void setConfirmation(Session session, CalendarDataObject appointment, Confirm confirm) {
        Participant[] participants = appointment.getParticipants();
        if (null != participants) {
            for (Participant participant : participants) {
                UserParticipant user;
                if (participant.getType() != 1 || (user = (UserParticipant)participant).getIdentifier() != session.getUserId()) continue;
                user.setConfirm(confirm.getConfirm());
                if (confirm.getConfirmMessage() == null) continue;
                user.setConfirmMessage(confirm.getConfirmMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<CalendarDataObject> parseAppointmentStream(Context ctx, ICalParser iCalParser, InputStreamCopy inputStreamCopy, List<ConversionError> conversionErrors, List<ConversionWarning> conversionWarnings, TimeZone defaultZone) throws IOException, ConversionError {
        InputStream inputStream = inputStreamCopy.getInputStream();
        try {
            List<CalendarDataObject> list = iCalParser.parseAppointments(inputStream, defaultZone, ctx, conversionErrors, conversionWarnings);
            return list;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                LOG.error((Object)"Error closing input stream", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Task> parseTaskStream(Context ctx, ICalParser iCalParser, InputStreamCopy inputStreamCopy, List<ConversionError> conversionErrors, List<ConversionWarning> conversionWarnings, TimeZone defaultZone) throws IOException, ConversionError {
        InputStream inputStream = inputStreamCopy.getInputStream();
        try {
            List<Task> list = iCalParser.parseTasks(inputStream, defaultZone, ctx, conversionErrors, conversionWarnings);
            return list;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                LOG.error((Object)"Error closing input stream", (Throwable)e);
            }
        }
    }

    protected static InputStreamCopy copyStream(InputStream orig, long size) throws OXException {
        try {
            return new InputStreamCopy(orig, size <= 0L || size > 0x100000L);
        }
        catch (IOException e) {
            throw DataExceptionCodes.ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
    }

    protected class Confirm {
        private final int confirm;
        private final String confirmMessage;

        public Confirm(int confirm, String confirmMessage) {
            this.confirm = confirm;
            this.confirmMessage = confirmMessage;
        }

        public int getConfirm() {
            return this.confirm;
        }

        public String getConfirmMessage() {
            return this.confirmMessage;
        }
    }

    protected static final class InputStreamCopy {
        private static final int DEFAULT_BUF_SIZE = 8192;
        private static final String FILE_PREFIX = "openexchange";
        private byte[] bytes;
        private File file;
        private final long size;

        public InputStreamCopy(InputStream orig, boolean createFile) throws IOException {
            this.size = createFile ? this.copy2File(orig) : (long)this.copy2ByteArr(orig);
        }

        public InputStream getInputStream() throws IOException {
            return this.bytes == null ? (this.file == null ? null : new BufferedInputStream(new FileInputStream(this.file), 8192)) : new UnsynchronizedByteArrayInputStream(this.bytes);
        }

        public long getSize() {
            return this.size;
        }

        public void close() {
            if (this.file != null) {
                if (this.file.exists()) {
                    this.file.delete();
                }
                this.file = null;
            }
            if (this.bytes != null) {
                this.bytes = null;
            }
        }

        private int copy2ByteArr(InputStream in) throws IOException {
            int len;
            UnsynchronizedByteArrayOutputStream out = new UnsynchronizedByteArrayOutputStream(16384);
            byte[] bbuf = new byte[8192];
            while ((len = in.read(bbuf)) > 0) {
                out.write(bbuf, 0, len);
            }
            out.flush();
            this.bytes = out.toByteArray();
            return this.bytes.length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long copy2File(InputStream in) throws IOException {
            long totalBytes = 0L;
            File tmpFile = File.createTempFile(FILE_PREFIX, null, new File(ServerConfig.getProperty(ServerConfig.Property.UploadDirectory)));
            tmpFile.deleteOnExit();
            OutputStream out = null;
            try {
                int len;
                out = new BufferedOutputStream(new FileOutputStream(tmpFile), 8192);
                byte[] bbuf = new byte[8192];
                while ((len = in.read(bbuf)) > 0) {
                    out.write(bbuf, 0, len);
                    totalBytes += (long)len;
                }
                out.flush();
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        LOG.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
            this.file = tmpFile;
            return totalBytes;
        }
    }
}

