/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.container;

import com.openexchange.groupware.container.DataObject;
import com.openexchange.groupware.container.Difference;
import java.util.Date;

public abstract class Differ<T extends DataObject> {
    public abstract Difference getDifference(T var1, T var2);

    public abstract int getColumn();

    public static boolean isDifferent(DataObject original, DataObject update, int column) {
        Object v2;
        if (!update.contains(column)) {
            return false;
        }
        if (!original.contains(column) && update.contains(column)) {
            return true;
        }
        Object v1 = Differ.unpack(original.get(column));
        if (v1 == (v2 = Differ.unpack(update.get(column)))) {
            return false;
        }
        if (v1 == null) {
            return true;
        }
        if (v2 == null) {
            return true;
        }
        return !v1.equals(v2);
    }

    private static Object unpack(Object object) {
        if (Date.class.isInstance(object)) {
            return ((Date)object).getTime();
        }
        return object;
    }

    protected Difference isArrayDifferent(Object[] original, Object[] update) {
        boolean found;
        Difference difference = new Difference();
        boolean isDifferent = false;
        for (Object o : original) {
            found = false;
            for (Object u : update) {
                if (!o.equals(u)) continue;
                found = true;
                break;
            }
            if (found) continue;
            difference.getRemoved().add(o);
            isDifferent = true;
        }
        for (Object u : update) {
            found = false;
            for (Object o : original) {
                if (!u.equals(o)) continue;
                found = true;
                break;
            }
            if (found) continue;
            difference.getAdded().add(u);
            isDifferent = true;
        }
        return isDifferent ? difference : null;
    }
}

