/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.attach.json.actions;

import com.openexchange.ajax.container.ByteArrayFileHolder;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.attach.AttachmentMetadata;
import com.openexchange.groupware.attach.json.actions.AbstractAttachmentAction;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.log.LogFactory;
import com.openexchange.server.ServiceLookup;
import com.openexchange.session.Session;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.stream.UnsynchronizedByteArrayOutputStream;
import java.io.InputStream;
import org.apache.commons.logging.Log;

@Action(method=RequestMethod.GET, name="[filename]?action=document", description="Get an attachments filedata.", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="folder", description="Object ID of the folder, whose contents are queried."), @Parameter(name="attached", description="Object ID of the object to which the attachments are attached."), @Parameter(name="module", description="Module ID (as per Attachment object) of the attached object."), @Parameter(name="id", description="Object ID of the requested attachment."), @Parameter(name="content_type", optional=true, description="If set the responses Content-Type header is set to this value, not the attachements file mime type.")}, responseDescription="The raw byte data of the document. The response type for the HTTP Request is set accordingly to the defined mimetype for this infoitem. Note: The Filename may be added to the customary infostore path to suggest a filename to a Save-As dialog.")
public final class GetDocumentAction
extends AbstractAttachmentAction {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(GetDocumentAction.class));

    public GetDocumentAction(ServiceLookup serviceLookup) {
        super(serviceLookup);
    }

    @Override
    public AJAXRequestResult perform(AJAXRequestData requestData, ServerSession session) throws OXException {
        GetDocumentAction.require(requestData, "folder", "attached", "module", "id");
        String contentType = requestData.getParameter("content_type");
        int folderId = this.requireNumber(requestData, "folder");
        int attachedId = this.requireNumber(requestData, "attached");
        int moduleId = this.requireNumber(requestData, "module");
        int id = this.requireNumber(requestData, "id");
        requestData.setFormat("file");
        return this.document(session, folderId, attachedId, moduleId, id, contentType, session.getContext(), session.getUser(), session.getUserConfiguration());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AJAXRequestResult document(Session session, int folderId, int attachedId, int moduleId, int id, String contentType, Context ctx, User user, UserConfiguration userConfig) throws OXException {
        try {
            UnsynchronizedByteArrayOutputStream os;
            ATTACHMENT_BASE.startTransaction();
            AttachmentMetadata attachment = ATTACHMENT_BASE.getAttachment(session, folderId, attachedId, moduleId, id, ctx, user, userConfig);
            InputStream documentData = ATTACHMENT_BASE.getAttachedFile(session, folderId, attachedId, moduleId, id, ctx, user, userConfig);
            try {
                os = new UnsynchronizedByteArrayOutputStream();
                byte[] buffer = new byte[65535];
                int bytesRead = 0;
                while ((bytesRead = documentData.read(buffer)) > 0) {
                    os.write(buffer, 0, bytesRead);
                }
                os.flush();
            }
            finally {
                documentData.close();
            }
            ByteArrayFileHolder fileHolder = new ByteArrayFileHolder(os.toByteArray());
            fileHolder.setContentType(contentType);
            fileHolder.setName(attachment.getFilename());
            ATTACHMENT_BASE.commit();
            AJAXRequestResult aJAXRequestResult = new AJAXRequestResult((Object)fileHolder, "file");
            return aJAXRequestResult;
        }
        catch (Throwable t) {
            this.rollback();
            if (t instanceof OXException) {
                throw (OXException)t;
            }
            throw new OXException(t);
        }
        finally {
            try {
                ATTACHMENT_BASE.finish();
            }
            catch (OXException e) {
                LOG.debug((Object)"", (Throwable)e);
            }
        }
    }
}

