/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.attach;

import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionCode;
import com.openexchange.exception.OXExceptionFactory;
import com.openexchange.groupware.EnumComponent;

public enum AttachmentExceptionCodes implements OXExceptionCode
{
    OVER_LIMIT("Attachment cannot be saved. File store limit is exceeded.", CATEGORY_CAPACITY, 1),
    SQL_PROBLEM("Invalid SQL Query: %s", CATEGORY_ERROR, 100),
    SAVE_FAILED("Could not save file to the file store.", CATEGORY_SERVICE_DOWN, 400),
    FILE_MISSING("Attachments must contain a file.", CATEGORY_USER_INPUT, 401),
    GENERATIING_ID_FAILED("Cannot generate ID for new attachment: %s", CATEGORY_ERROR, 402),
    READ_FAILED("Could not retrieve file: %s", CATEGORY_SERVICE_DOWN, 404),
    ATTACHMENT_NOT_FOUND("The attachment you requested no longer exists. Please refresh the view.", CATEGORY_USER_INPUT, 405),
    DELETE_FAILED("Could not delete attachment.", CATEGORY_ERROR, 407),
    ATTACHMENT_WITH_FILEID_NOT_FOUND("Could not find an attachment with the file id %s. Either the file is orphaned or belongs to another module.", CATEGORY_ERROR, 408),
    FILE_DELETE_FAILED("Could not delete files from file store. Context: %d.", CATEGORY_SERVICE_DOWN, 416),
    INVALID_CHARACTERS("Validation failed: %s", CATEGORY_USER_INPUT, 418),
    SEARCH_PROBLEM("An error occurred executing the search in the database.", CATEGORY_ERROR, 420),
    FILESTORE_DOWN("Unable to access the file store.", CATEGORY_SERVICE_DOWN, 421),
    FILESTORE_WRITE_FAILED("Writing to file store failed.", CATEGORY_SERVICE_DOWN, 422),
    UNDONE_FAILED("Changes done to the object this attachment was added to could not be undone. Your database is probably inconsistent, run the consistency tool.", CATEGORY_ERROR, 600),
    ATTACH_FAILED("An error occurred attaching to the given object.", CATEGORY_ERROR, 601),
    DETACH_FAILED("The object could not be detached because the update to an underlying object failed.", CATEGORY_ERROR, 602),
    INVALID_REQUEST_PARAMETER("Invalid parameter sent in request. Parameter '%1$s' was '%2$s' which does not look like a number.", CATEGORY_USER_INPUT, 701),
    SERVICE_CONFLICT("Conflicting services registered for context %1$i and folder %2$i", CATEGORY_CONFIGURATION, 900);

    private final String message;
    private final Category category;
    private final int number;

    private AttachmentExceptionCodes(String message, Category category, int number) {
        this.message = message;
        this.category = category;
        this.number = number;
    }

    public String getPrefix() {
        return EnumComponent.ATTACHMENT.getAbbreviation();
    }

    public int getNumber() {
        return this.number;
    }

    public String getMessage() {
        return this.message;
    }

    public String getHelp() {
        return null;
    }

    public Category getCategory() {
        return this.category;
    }

    public boolean equals(OXException e) {
        return OXExceptionFactory.getInstance().equals((OXExceptionCode)this, e);
    }

    public OXException create() {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, new Object[0]);
    }

    public OXException create(Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, (Throwable)null, args);
    }

    public OXException create(Throwable cause, Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, cause, args);
    }
}

