/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.attach;

import com.openexchange.database.provider.DBPoolProvider;
import com.openexchange.event.impl.AppointmentEventInterface;
import com.openexchange.event.impl.ContactEventInterface;
import com.openexchange.event.impl.TaskEventInterface;
import com.openexchange.exception.Log;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.attach.AttachmentBase;
import com.openexchange.groupware.attach.AttachmentField;
import com.openexchange.groupware.attach.AttachmentMetadata;
import com.openexchange.groupware.attach.impl.AttachmentBaseImpl;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.results.TimedResult;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.log.LogFactory;
import com.openexchange.session.Session;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionAdapter;
import gnu.trove.list.array.TIntArrayList;

public class AttachmentCleaner
implements AppointmentEventInterface,
TaskEventInterface,
ContactEventInterface {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(AttachmentCleaner.class));
    private static final AttachmentBase ATTACHMENT_BASE = new AttachmentBaseImpl(new DBPoolProvider());

    @Override
    public final void appointmentDeleted(Appointment appointmentObj, Session sessionObj) {
        this.deleteAttachments(appointmentObj.getParentFolderID(), appointmentObj.getObjectID(), 1, sessionObj);
    }

    @Override
    public final void taskDeleted(Task taskObj, Session sessionObj) {
        this.deleteAttachments(taskObj.getParentFolderID(), taskObj.getObjectID(), 4, sessionObj);
    }

    @Override
    public final void contactDeleted(Contact contactObj, Session sessionObj) {
        this.deleteAttachments(contactObj.getParentFolderID(), contactObj.getObjectID(), 7, sessionObj);
    }

    @Override
    public final void appointmentCreated(Appointment appointmentObj, Session sessionObj) {
    }

    @Override
    public final void appointmentModified(Appointment appointment, Session session) {
    }

    @Override
    public final void taskCreated(Task taskObj, Session sessionObj) {
    }

    @Override
    public final void taskModified(Task taskObj, Session sessionObj) {
    }

    @Override
    public final void contactCreated(Contact contactObj, Session sessionObj) {
    }

    @Override
    public final void contactModified(Contact contact, Session session) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void deleteAttachments(int parentFolderID, int objectID, int type, Session session) {
        SearchIterator iter = null;
        try {
            ServerSession sessionObj = ServerSessionAdapter.valueOf(session);
            ATTACHMENT_BASE.startTransaction();
            TimedResult<AttachmentMetadata> rs = ATTACHMENT_BASE.getAttachments(session, parentFolderID, objectID, type, new AttachmentField[]{AttachmentField.ID_LITERAL}, AttachmentField.ID_LITERAL, 1, sessionObj.getContext(), null, null);
            TIntArrayList ids = new TIntArrayList();
            iter = rs.results();
            if (!iter.hasNext()) {
                return;
            }
            while (iter.hasNext()) {
                ids.add(((AttachmentMetadata)iter.next()).getId());
            }
            ATTACHMENT_BASE.detachFromObject(parentFolderID, objectID, type, ids.toArray(), sessionObj, sessionObj.getContext(), null, null);
            ATTACHMENT_BASE.commit();
        }
        catch (OXException e) {
            this.rollback(e);
        }
        finally {
            if (iter != null) {
                try {
                    iter.close();
                }
                catch (OXException e) {
                    e.log(LOG);
                }
            }
            try {
                ATTACHMENT_BASE.finish();
            }
            catch (OXException e) {
                e.log(LOG);
            }
        }
    }

    private void rollback(OXException x) {
        try {
            ATTACHMENT_BASE.rollback();
        }
        catch (OXException e) {
            e.log(LOG);
        }
        x.log(LOG);
    }

    @Override
    public void appointmentAccepted(Appointment appointmentObj, Session sessionObj) {
    }

    @Override
    public void appointmentDeclined(Appointment appointmentObj, Session sessionObj) {
    }

    @Override
    public void appointmentTentativelyAccepted(Appointment appointmentObj, Session sessionObj) {
    }

    @Override
    public void appointmentWaiting(Appointment appointmentObj, Session sessionObj) {
    }

    @Override
    public void taskAccepted(Task taskObj, Session sessionObj) {
    }

    @Override
    public void taskDeclined(Task taskObj, Session sessionObj) {
    }

    @Override
    public void taskTentativelyAccepted(Task taskObj, Session sessionObj) {
    }
}

