/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.group.internal;

import com.openexchange.exception.OXException;
import com.openexchange.group.Group;
import com.openexchange.group.GroupExceptionCodes;
import com.openexchange.group.GroupStorage;
import com.openexchange.group.internal.Logic;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.impl.IDGenerator;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.userconfiguration.UserConfigurationStorage;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.server.impl.DBPool;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.SQLException;

public final class Create {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(Create.class));
    private final Context ctx;
    private final User user;
    private final Group group;
    private static final GroupStorage storage = GroupStorage.getInstance();

    public Create(Context ctx, User user, Group group) {
        this.ctx = ctx;
        this.user = user;
        this.group = group;
    }

    void perform() throws OXException {
        this.allowed();
        this.check();
        this.insert();
        this.propagate();
    }

    private void allowed() throws OXException {
        if (!UserConfigurationStorage.getInstance().getUserConfiguration(this.user.getId(), this.ctx).isEditGroup()) {
            throw GroupExceptionCodes.NO_CREATE_PERMISSION.create();
        }
    }

    private void check() throws OXException {
        if (null == this.group) {
            throw GroupExceptionCodes.NULL.create();
        }
        Logic.checkMandatoryForCreate(this.group);
        Logic.validateSimpleName(this.group);
        Logic.checkData(this.group);
        Logic.checkForDuplicate(storage, this.ctx, this.group);
        Logic.doMembersExist(this.ctx, this.group);
    }

    private void insert() throws OXException {
        Connection con = DBPool.pickupWriteable(this.ctx);
        try {
            con.setAutoCommit(false);
            this.insert(con);
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw GroupExceptionCodes.SQL_ERROR.create(e, e.getMessage());
        }
        catch (OXException e) {
            DBUtils.rollback(con);
            throw e;
        }
        finally {
            try {
                con.setAutoCommit(true);
            }
            catch (SQLException e) {
                LOG.error((Object)"Problem setting autocommit to true.", (Throwable)e);
            }
            DBPool.closeWriterSilent(this.ctx, con);
        }
    }

    public void insert(Connection con) throws OXException {
        try {
            int identifier = IDGenerator.getId(this.ctx.getContextId(), 130, con);
            this.group.setIdentifier(identifier);
            storage.insertGroup(this.ctx, con, this.group);
            storage.insertMember(this.ctx, con, this.group, this.group.getMember());
        }
        catch (SQLException e) {
            throw GroupExceptionCodes.SQL_ERROR.create(e, e.getMessage());
        }
    }

    private void propagate() throws OXException {
        UserStorage storage = UserStorage.getInstance();
        try {
            storage.invalidateUser(this.ctx, this.group.getMember());
        }
        catch (OXException e) {
            throw new OXException(e);
        }
    }
}

