/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.filestorage;

import com.openexchange.file.storage.FileStorageFolder;
import com.openexchange.file.storage.FileStorageFolderType;
import com.openexchange.file.storage.FileStoragePermission;
import com.openexchange.file.storage.TypeAware;
import com.openexchange.folderstorage.AbstractFolder;
import com.openexchange.folderstorage.ContentType;
import com.openexchange.folderstorage.Permission;
import com.openexchange.folderstorage.Type;
import com.openexchange.folderstorage.filestorage.FileStorageFolderIdentifier;
import com.openexchange.folderstorage.filestorage.FileStoragePermissionImpl;
import com.openexchange.folderstorage.filestorage.contentType.FileStorageContentType;
import com.openexchange.folderstorage.type.FileStorageType;
import com.openexchange.folderstorage.type.SystemType;
import java.util.List;

public final class FileStorageFolderImpl
extends AbstractFolder {
    private static final long serialVersionUID = 6445442372690458946L;
    private static final String INFOSTORE_USER = Integer.toString(10);
    private static final String INFOSTORE_PUBLIC = Integer.toString(15);
    private boolean cacheable;
    private static final String PRIVATE_FOLDER_ID = String.valueOf(1);

    public FileStorageFolderImpl() {
    }

    public FileStorageFolderImpl(FileStorageFolder fsFolder, String accountId, String serviceId) {
        String fullname = fsFolder.getId();
        this.id = FileStorageFolderIdentifier.getFQN(serviceId, accountId, fullname);
        this.name = fsFolder.getName();
        boolean isRootFolder = fsFolder.isRootFolder();
        if (isRootFolder) {
            this.parent = PRIVATE_FOLDER_ID;
        } else {
            String parentId = null;
            if (fsFolder instanceof TypeAware) {
                FileStorageFolderType folderType = ((TypeAware)fsFolder).getType();
                if (FileStorageFolderType.HOME_DIRECTORY.equals((Object)folderType)) {
                    parentId = INFOSTORE_USER;
                } else if (FileStorageFolderType.PUBLIC_FOLDER.equals((Object)folderType)) {
                    parentId = INFOSTORE_PUBLIC;
                }
            }
            this.parent = null == parentId ? FileStorageFolderIdentifier.getFQN(serviceId, accountId, fsFolder.getParentId()) : parentId;
        }
        List fsPermissions = fsFolder.getPermissions();
        int size = fsPermissions.size();
        this.permissions = new Permission[size];
        for (int i = 0; i < size; ++i) {
            this.permissions[i] = new FileStoragePermissionImpl((FileStoragePermission)fsPermissions.get(i));
        }
        this.type = SystemType.getInstance();
        this.subscribed = fsFolder.isSubscribed();
        this.subscribedSubfolders = fsFolder.hasSubscribedSubfolders();
        this.deefault = fsFolder.isDefaultFolder();
        this.total = fsFolder.getFileCount();
        this.defaultType = this.deefault ? FileStorageContentType.getInstance().getModule() : 0;
        this.cacheable = !fsFolder.isDefaultFolder();
    }

    @Override
    public Object clone() {
        FileStorageFolderImpl clone = (FileStorageFolderImpl)super.clone();
        clone.cacheable = this.cacheable;
        return clone;
    }

    @Override
    public boolean isCacheable() {
        return this.cacheable;
    }

    @Override
    public ContentType getContentType() {
        return FileStorageContentType.getInstance();
    }

    @Override
    public Type getType() {
        return FileStorageType.getInstance();
    }

    @Override
    public void setContentType(ContentType contentType) {
    }

    @Override
    public void setType(Type type) {
    }

    @Override
    public boolean isGlobalID() {
        return false;
    }
}

