/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.cache.memory;

import com.openexchange.folderstorage.cache.memory.FolderMap;
import com.openexchange.java.StringAllocator;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.session.Session;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.cliffc.high_scale_lib.NonBlockingHashMap;

public final class FolderMapManagement {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(FolderMapManagement.class));
    private static final FolderMapManagement INSTANCE = new FolderMapManagement();
    private final ConcurrentMap<Integer, ConcurrentMap<Integer, FolderMap>> map = new NonBlockingHashMap(64);

    public static FolderMapManagement getInstance() {
        return INSTANCE;
    }

    private FolderMapManagement() {
    }

    public void clear() {
        this.map.clear();
    }

    public void dropFor(int contextId) {
        this.map.remove(contextId);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)new StringAllocator("Cleaned user-sensitive folder cache for context ").append(contextId).toString());
        }
    }

    public void dropFor(Session session) {
        ConcurrentMap contextMap = (ConcurrentMap)this.map.get(session.getContextId());
        if (null != contextMap) {
            contextMap.remove(session.getUserId());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)new StringAllocator("Cleaned user-sensitive folder cache for user ").append(session.getUserId()).append(" in context ").append(session.getContextId()).toString());
        }
    }

    public void dropFor(int userId, int contextId) {
        ConcurrentMap contextMap = (ConcurrentMap)this.map.get(contextId);
        if (null != contextMap) {
            contextMap.remove(userId);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)new StringAllocator("Cleaned user-sensitive folder cache for user ").append(userId).append(" in context ").append(contextId).toString());
        }
    }

    public FolderMap getFor(Session session) {
        FolderMap newFolderMap;
        Integer us;
        FolderMap folderMap;
        NonBlockingHashMap newMap;
        Integer cid = session.getContextId();
        NonBlockingHashMap contextMap = (NonBlockingHashMap)this.map.get(cid);
        if (null == contextMap && null == (contextMap = this.map.putIfAbsent(cid, (ConcurrentMap<Integer, FolderMap>)(newMap = new NonBlockingHashMap(256))))) {
            contextMap = newMap;
        }
        if (null == (folderMap = (FolderMap)contextMap.get(us = Integer.valueOf(session.getUserId()))) && null == (folderMap = contextMap.putIfAbsent(us, newFolderMap = new FolderMap(1024, 300, TimeUnit.SECONDS, session.getUserId(), session.getContextId())))) {
            folderMap = newFolderMap;
        }
        return folderMap;
    }

    public FolderMap optFor(Session session) {
        ConcurrentMap contextMap = (ConcurrentMap)this.map.get(session.getContextId());
        if (null == contextMap) {
            return null;
        }
        return (FolderMap)contextMap.get(session.getUserId());
    }

    public FolderMap optFor(int userId, int contextId) {
        ConcurrentMap contextMap = (ConcurrentMap)this.map.get(contextId);
        if (null == contextMap) {
            return null;
        }
        return (FolderMap)contextMap.get(userId);
    }
}

