/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.database.internal;

import com.openexchange.database.Assignment;
import com.openexchange.database.ConfigDatabaseService;
import com.openexchange.database.DBPoolingExceptionCodes;
import com.openexchange.database.DatabaseService;
import com.openexchange.database.internal.AssignmentImpl;
import com.openexchange.database.internal.ConfigDBStorage;
import com.openexchange.database.internal.ContextDatabaseAssignmentService;
import com.openexchange.database.internal.Pools;
import com.openexchange.database.internal.ReplicationMonitor;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.java.Autoboxing;
import com.openexchange.log.ForceLog;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.log.LogProperties;
import com.openexchange.pooling.PoolingException;
import java.sql.Connection;
import java.sql.SQLException;

public final class DatabaseServiceImpl
implements DatabaseService {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(DatabaseServiceImpl.class));
    private final Pools pools;
    private final ConfigDatabaseService configDatabaseService;
    private final ContextDatabaseAssignmentService assignmentService;

    public DatabaseServiceImpl(Pools pools, ConfigDatabaseService configDatabaseService, ContextDatabaseAssignmentService assignmentService) {
        this.pools = pools;
        this.configDatabaseService = configDatabaseService;
        this.assignmentService = assignmentService;
    }

    private Connection get(int contextId, boolean write, boolean noTimeout) throws OXException {
        AssignmentImpl assign = this.assignmentService.getAssignment(contextId);
        LogProperties.putLogProperty((String)"com.openexchange.database.schema", (Object)ForceLog.valueOf((Object)assign.getSchema()));
        return ReplicationMonitor.checkActualAndFallback(this.pools, assign, noTimeout, write);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void back(Connection con) {
        if (null == con) {
            LogProperties.putLogProperty((String)"com.openexchange.database.schema", null);
            OXException e = DBPoolingExceptionCodes.NULL_CONNECTION.create();
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return;
        }
        try {
            con.close();
        }
        catch (SQLException e) {
            OXException e1 = DBPoolingExceptionCodes.SQL_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
            LOG.error((Object)e1.getMessage(), (Throwable)e1);
        }
        finally {
            LogProperties.putLogProperty((String)"com.openexchange.database.schema", null);
        }
    }

    public void invalidate(int contextId) throws OXException {
        this.assignmentService.removeAssignments(contextId);
    }

    public Connection getReadOnly() throws OXException {
        return this.configDatabaseService.getReadOnly();
    }

    public Connection getWritable() throws OXException {
        return this.configDatabaseService.getWritable();
    }

    public void backReadOnly(Connection con) {
        this.configDatabaseService.backReadOnly(con);
    }

    public void backWritable(Connection con) {
        this.configDatabaseService.backWritable(con);
    }

    public int[] listContexts(int poolId) throws OXException {
        return this.configDatabaseService.listContexts(poolId);
    }

    public int getServerId() throws OXException {
        return this.configDatabaseService.getServerId();
    }

    public Connection getReadOnly(Context ctx) throws OXException {
        return this.get(ctx.getContextId(), false, false);
    }

    public Connection getReadOnly(int contextId) throws OXException {
        return this.get(contextId, false, false);
    }

    public Connection getWritable(Context ctx) throws OXException {
        return this.get(ctx.getContextId(), true, false);
    }

    public Connection getWritable(int contextId) throws OXException {
        return this.get(contextId, true, false);
    }

    public Connection getForUpdateTask(int contextId) throws OXException {
        return this.get(contextId, true, true);
    }

    public Connection get(int poolId, String schema) throws OXException {
        Connection con;
        try {
            con = (Connection)this.pools.getPool(poolId).get();
        }
        catch (PoolingException e) {
            throw DBPoolingExceptionCodes.NO_CONNECTION.create((Throwable)e, new Object[]{Autoboxing.I((int)poolId)});
        }
        try {
            if (null != schema && !con.getCatalog().equals(schema)) {
                con.setCatalog(schema);
            }
        }
        catch (SQLException e) {
            try {
                this.pools.getPool(poolId).back(con);
            }
            catch (PoolingException e1) {
                LOG.error((Object)e1.getMessage(), (Throwable)e1);
            }
            throw DBPoolingExceptionCodes.SCHEMA_FAILED.create((Throwable)e, new Object[0]);
        }
        return con;
    }

    public Connection getNoTimeout(int poolId, String schema) throws OXException {
        Connection con;
        try {
            con = this.pools.getPool(poolId).getWithoutTimeout();
        }
        catch (PoolingException e) {
            throw DBPoolingExceptionCodes.NO_CONNECTION.create((Throwable)e, new Object[]{Autoboxing.I((int)poolId)});
        }
        try {
            if (null != schema && !con.getCatalog().equals(schema)) {
                con.setCatalog(schema);
            }
        }
        catch (SQLException e) {
            try {
                this.pools.getPool(poolId).back(con);
            }
            catch (PoolingException e1) {
                LOG.error((Object)e1.getMessage(), (Throwable)e1);
            }
            throw DBPoolingExceptionCodes.SCHEMA_FAILED.create((Throwable)e, new Object[0]);
        }
        return con;
    }

    public void backReadOnly(Context ctx, Connection con) {
        this.back(con);
    }

    public void backReadOnly(int contextId, Connection con) {
        this.back(con);
    }

    public void backWritable(Context ctx, Connection con) {
        this.back(con);
    }

    public void backWritable(int contextId, Connection con) {
        this.back(con);
    }

    public void backForUpdateTask(int contextId, Connection con) {
        this.back(con);
    }

    public void back(int poolId, Connection con) {
        try {
            this.pools.getPool(poolId).back(con);
        }
        catch (PoolingException e) {
            OXException e2 = DBPoolingExceptionCodes.RETURN_FAILED.create((Throwable)e, new Object[]{con.toString()});
            LOG.error((Object)e2.getMessage(), (Throwable)e2);
        }
        catch (OXException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void backNoTimeoout(int poolId, Connection con) {
        try {
            this.pools.getPool(poolId).backWithoutTimeout(con);
        }
        catch (OXException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public int getWritablePool(int contextId) throws OXException {
        AssignmentImpl assign = this.assignmentService.getAssignment(contextId);
        return assign.getWritePoolId();
    }

    public String getSchemaName(int contextId) throws OXException {
        return this.assignmentService.getAssignment(contextId).getSchema();
    }

    public int[] getContextsInSameSchema(int contextId) throws OXException {
        AssignmentImpl assign = this.assignmentService.getAssignment(contextId);
        ConfigDBStorage configDBStorage = new ConfigDBStorage(this.configDatabaseService);
        return configDBStorage.getContextsFromSchema(assign.getSchema(), assign.getWritePoolId());
    }

    public void writeAssignment(Connection con, Assignment assignment) throws OXException {
        this.assignmentService.writeAssignment(con, assignment);
    }
}

