/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler;

import com.openexchange.ajax.requesthandler.AJAXActionCustomizer;
import com.openexchange.ajax.requesthandler.AJAXActionCustomizerFactory;
import com.openexchange.ajax.requesthandler.AJAXActionService;
import com.openexchange.ajax.requesthandler.AJAXActionServiceFactory;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.AJAXState;
import com.openexchange.ajax.requesthandler.AJAXStateHandler;
import com.openexchange.ajax.requesthandler.CombinedActionFactory;
import com.openexchange.ajax.requesthandler.Dispatcher;
import com.openexchange.ajax.requesthandler.DispatcherNotes;
import com.openexchange.ajax.requesthandler.ETagAwareAJAXActionService;
import com.openexchange.ajax.requesthandler.FlowControl;
import com.openexchange.ajax.requesthandler.Module;
import com.openexchange.exception.OXException;
import com.openexchange.java.Java7ConcurrentLinkedQueue;
import com.openexchange.java.StringAllocator;
import com.openexchange.log.LogFactory;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;

public class DefaultDispatcher
implements Dispatcher {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(DefaultDispatcher.class));
    private final ConcurrentMap<String, AJAXActionServiceFactory> actionFactories = new ConcurrentHashMap<String, AJAXActionServiceFactory>();
    private final Queue<AJAXActionCustomizerFactory> customizerFactories = new Java7ConcurrentLinkedQueue();
    private static final Pattern SPLIT_SLASH = Pattern.compile("/");

    @Override
    public AJAXState begin() throws OXException {
        return new AJAXState();
    }

    @Override
    public void end(AJAXState state) {
        if (null != state) {
            state.close();
        }
    }

    @Override
    public boolean handles(String module) {
        return this.actionFactories.containsKey(module);
    }

    @Override
    public AJAXRequestResult perform(AJAXRequestData requestData, AJAXState state, ServerSession session) throws OXException {
        AJAXRequestResult result;
        AJAXActionCustomizer customizer;
        if (null == session) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create("session");
        }
        AbstractList outgoing = new ArrayList<AJAXActionCustomizer>(this.customizerFactories.size());
        LinkedList<AJAXActionCustomizer> todo = new LinkedList<AJAXActionCustomizer>();
        for (AJAXActionCustomizerFactory customizerFactory : this.customizerFactories) {
            customizer = customizerFactory.createCustomizer(requestData, session);
            if (customizer == null) continue;
            todo.add(customizer);
        }
        AJAXRequestData modifiedRequestData = requestData;
        while (!todo.isEmpty()) {
            Iterator iterator = todo.iterator();
            while (iterator.hasNext()) {
                customizer = (AJAXActionCustomizer)iterator.next();
                try {
                    AJAXRequestData modified = customizer.incoming(modifiedRequestData, session);
                    if (modified != null) {
                        modifiedRequestData = modified;
                    }
                    outgoing.add(customizer);
                    iterator.remove();
                }
                catch (FlowControl.Later l) {}
            }
        }
        AJAXActionServiceFactory factory = this.lookupFactory(modifiedRequestData.getModule());
        if (factory == null) {
            throw AjaxExceptionCodes.UNKNOWN_MODULE.create(modifiedRequestData.getModule());
        }
        AJAXActionService action = factory.createActionService(modifiedRequestData.getAction());
        if (action == null) {
            throw AjaxExceptionCodes.UNKNOWN_ACTION_IN_MODULE.create(modifiedRequestData.getAction(), modifiedRequestData.getModule());
        }
        String eTag = modifiedRequestData.getETag();
        if (null != eTag && action instanceof ETagAwareAJAXActionService && ((ETagAwareAJAXActionService)action).checkETag(eTag, modifiedRequestData, session)) {
            AJAXRequestResult etagResult = new AJAXRequestResult();
            etagResult.setType(AJAXRequestResult.ResultType.ETAG);
            long newExpires = modifiedRequestData.getExpires();
            if (newExpires > 0L) {
                etagResult.setExpires(newExpires);
            }
            return etagResult;
        }
        if (modifiedRequestData.getFormat() == null) {
            DispatcherNotes actionMetadata = this.getActionMetadata(action);
            modifiedRequestData.setFormat(actionMetadata == null ? "apiResponse" : actionMetadata.defaultFormat());
        }
        if (factory instanceof AJAXStateHandler) {
            AJAXStateHandler handler = (AJAXStateHandler)((Object)factory);
            if (state.addInitializer(modifiedRequestData.getModule(), handler)) {
                handler.initialize(state);
            }
        }
        modifiedRequestData.setState(state);
        try {
            result = action.perform(modifiedRequestData, session);
        }
        catch (IllegalStateException e) {
            Throwable cause = e.getCause();
            if (cause instanceof OXException) {
                throw (OXException)cause;
            }
            throw AjaxExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        Collections.reverse(outgoing);
        outgoing = new LinkedList(outgoing);
        while (!outgoing.isEmpty()) {
            Iterator iterator = outgoing.iterator();
            while (iterator.hasNext()) {
                AJAXActionCustomizer customizer2 = (AJAXActionCustomizer)iterator.next();
                try {
                    AJAXRequestResult modified = customizer2.outgoing(modifiedRequestData, result, session);
                    if (modified != null) {
                        result = modified;
                    }
                    iterator.remove();
                }
                catch (FlowControl.Later l) {}
            }
        }
        return result;
    }

    private AJAXActionServiceFactory lookupFactory(String module) {
        AJAXActionServiceFactory serviceFactory = (AJAXActionServiceFactory)this.actionFactories.get(module);
        if (serviceFactory == null && module.contains("/")) {
            serviceFactory = (AJAXActionServiceFactory)this.actionFactories.get(SPLIT_SLASH.split(module, 0)[0]);
        }
        return serviceFactory;
    }

    private DispatcherNotes getActionMetadata(AJAXActionService action) {
        if (null == action) {
            return null;
        }
        return action.getClass().getAnnotation(DispatcherNotes.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(String module, AJAXActionServiceFactory factory) {
        ConcurrentMap<String, AJAXActionServiceFactory> concurrentMap = this.actionFactories;
        synchronized (concurrentMap) {
            AJAXActionServiceFactory current = this.actionFactories.putIfAbsent(module, factory);
            if (null != current) {
                ConcurrentMap<String, AJAXActionServiceFactory> concurrentMap2 = this.actionFactories;
                synchronized (concurrentMap2) {
                    try {
                        current = (AJAXActionServiceFactory)this.actionFactories.get(module);
                        Module moduleAnnotation = current.getClass().getAnnotation(Module.class);
                        if (null == moduleAnnotation) {
                            StringAllocator sb = new StringAllocator(512).append("There is already a factory associated with module \"");
                            sb.append(module).append("\": ").append(current.getClass().getName());
                            sb.append(". Therefore registration is denied for factory \"").append(factory.getClass().getName());
                            sb.append("\". Unless these two factories provide the \"").append(Module.class.getName()).append("\" annotation to specify what actions are supported by each factory.");
                            LOG.warn((Object)sb.toString());
                        } else {
                            CombinedActionFactory combinedFactory;
                            if (current instanceof CombinedActionFactory) {
                                combinedFactory = (CombinedActionFactory)current;
                            } else {
                                combinedFactory = new CombinedActionFactory();
                                combinedFactory.add(current);
                                this.actionFactories.put(module, combinedFactory);
                            }
                            combinedFactory.add(factory);
                        }
                    }
                    catch (IllegalArgumentException e) {
                        LOG.error((Object)e.getMessage());
                    }
                }
            }
        }
    }

    public void addCustomizer(AJAXActionCustomizerFactory factory) {
        this.customizerFactories.add(factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String module, AJAXActionServiceFactory factory) {
        ConcurrentMap<String, AJAXActionServiceFactory> concurrentMap = this.actionFactories;
        synchronized (concurrentMap) {
            AJAXActionServiceFactory removed = (AJAXActionServiceFactory)this.actionFactories.remove(module);
            if (removed instanceof CombinedActionFactory) {
                CombinedActionFactory combinedFactory = (CombinedActionFactory)removed;
                combinedFactory.remove(factory);
                if (!combinedFactory.isEmpty()) {
                    this.actionFactories.put(module, combinedFactory);
                }
            }
        }
    }

    @Override
    public boolean mayUseFallbackSession(String module, String action) throws OXException {
        AJAXActionServiceFactory factory = this.lookupFactory(module);
        if (factory == null) {
            return false;
        }
        DispatcherNotes actionMetadata = this.getActionMetadata(factory.createActionService(action));
        if (actionMetadata == null) {
            return false;
        }
        return actionMetadata.allowPublicSession();
    }

    @Override
    public boolean mayOmitSession(String module, String action) throws OXException {
        AJAXActionServiceFactory factory = this.lookupFactory(module);
        if (factory == null) {
            return false;
        }
        DispatcherNotes actionMetadata = this.getActionMetadata(factory.createActionService(action));
        if (actionMetadata == null) {
            return false;
        }
        return actionMetadata.noSession();
    }
}

