/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.request;

import com.openexchange.ajax.parser.DataParser;
import com.openexchange.ajax.parser.ReminderParser;
import com.openexchange.ajax.writer.ReminderWriter;
import com.openexchange.api2.AppointmentSQLInterface;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.AppointmentSqlFactoryService;
import com.openexchange.groupware.calendar.CalendarCollectionService;
import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.groupware.calendar.OXCalendarExceptionCodes;
import com.openexchange.groupware.calendar.RecurringResultInterface;
import com.openexchange.groupware.calendar.RecurringResultsInterface;
import com.openexchange.groupware.container.CalendarObject;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.reminder.ReminderExceptionCode;
import com.openexchange.groupware.reminder.ReminderHandler;
import com.openexchange.groupware.reminder.ReminderObject;
import com.openexchange.log.LogFactory;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.TimeZoneUtils;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONValue;

public final class ReminderRequest {
    private final ServerSession session;
    private final User userObj;
    private Date timestamp;
    private final AppointmentSqlFactoryService appointmentFactory;
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(ReminderRequest.class));

    public Date getTimestamp() {
        return this.timestamp;
    }

    public ReminderRequest(ServerSession session) {
        this.session = session;
        this.appointmentFactory = ServerServiceRegistry.getInstance().getService(AppointmentSqlFactoryService.class);
        this.userObj = session.getUser();
    }

    public JSONValue action(String action, JSONObject jsonObject) throws JSONException, OXException {
        if (action.equalsIgnoreCase("delete")) {
            return this.actionDelete(jsonObject);
        }
        if (action.equalsIgnoreCase("updates")) {
            return this.actionUpdates(jsonObject);
        }
        if (action.equalsIgnoreCase("range")) {
            return this.actionRange(jsonObject);
        }
        if (action.equalsIgnoreCase("remindAgain")) {
            return this.actionRemindAgain(jsonObject);
        }
        throw AjaxExceptionCodes.UNKNOWN_ACTION.create(action);
    }

    private JSONArray actionDelete(JSONObject jsonObject) throws JSONException, OXException, OXException, OXException {
        JSONObject jData = DataParser.checkJSONObject(jsonObject, "data");
        int id = DataParser.checkInt(jData, "id");
        TimeZone tz = TimeZoneUtils.getTimeZone(this.userObj.getTimeZone());
        JSONArray jsonArray = new JSONArray();
        try {
            ReminderHandler reminderSql = new ReminderHandler(this.session.getContext());
            ReminderObject reminder = reminderSql.loadReminder(id);
            if (reminder.isRecurrenceAppointment()) {
                ReminderObject nextReminder = ReminderRequest.getNextRecurringReminder(this.session, tz, reminder);
                if (nextReminder != null) {
                    reminderSql.updateReminder(nextReminder);
                    jsonArray.put(nextReminder.getObjectId());
                } else {
                    reminderSql.deleteReminder(reminder);
                }
            } else {
                reminderSql.deleteReminder(reminder);
            }
        }
        catch (OXException oxe) {
            LOG.debug((Object)oxe.getMessage(), (Throwable)oxe);
            if (ReminderExceptionCode.NOT_FOUND.equals(oxe)) {
                jsonArray.put(id);
                return jsonArray;
            }
            throw oxe;
        }
        return jsonArray;
    }

    private JSONArray actionUpdates(JSONObject jsonObject) throws JSONException, OXException {
        this.timestamp = DataParser.checkDate(jsonObject, "timestamp");
        String timeZoneId = DataParser.parseString(jsonObject, "timezone");
        TimeZone timeZone = null == timeZoneId ? TimeZoneUtils.getTimeZone(this.userObj.getTimeZone()) : TimeZoneUtils.getTimeZone(timeZoneId);
        JSONArray jsonResponseArray = new JSONArray();
        SearchIterator it = null;
        try {
            ReminderHandler reminderSql = new ReminderHandler(this.session.getContext());
            it = reminderSql.listModifiedReminder(this.userObj.getId(), this.timestamp);
            while (it.hasNext()) {
                ReminderWriter reminderWriter = new ReminderWriter(timeZone);
                ReminderObject reminderObj = (ReminderObject)it.next();
                if (reminderObj.isRecurrenceAppointment()) {
                    int targetId = reminderObj.getTargetId();
                    int inFolder = reminderObj.getFolder();
                }
                if (!this.hasModulePermission(reminderObj)) continue;
                JSONObject jsonReminderObj = new JSONObject();
                reminderWriter.writeObject(reminderObj, jsonReminderObj);
                jsonResponseArray.put((Object)jsonReminderObj);
            }
            JSONArray jSONArray = jsonResponseArray;
            return jSONArray;
        }
        catch (OXException e) {
            throw e;
        }
        finally {
            if (null != it) {
                it.close();
            }
        }
    }

    private JSONObject actionRemindAgain(JSONObject jsonObject) throws JSONException, OXException {
        int reminderId = DataParser.checkInt(jsonObject, "id");
        TimeZone tz = TimeZoneUtils.getTimeZone(this.userObj.getTimeZone());
        String timeZoneId = DataParser.parseString(jsonObject, "timezone");
        TimeZone timeZone = null == timeZoneId ? tz : TimeZoneUtils.getTimeZone(timeZoneId);
        JSONObject jreminder = jsonObject.getJSONObject("data");
        ReminderObject reminder = new ReminderObject();
        new ReminderParser(tz).parse(reminder, jreminder);
        if (null == reminder.getDate()) {
            throw ReminderExceptionCode.MANDATORY_FIELD_ALARM.create();
        }
        reminder.setObjectId(reminderId);
        ReminderHandler reminderSql = new ReminderHandler(this.session.getContext());
        ReminderObject storageReminder = reminderSql.loadReminder(reminder.getObjectId());
        if (!this.hasModulePermission(storageReminder)) {
            throw ReminderExceptionCode.UNEXPECTED_ERROR.create("No module permission.");
        }
        reminder.setModule(storageReminder.getModule());
        reminder.setDescription(storageReminder.getDescription());
        reminder.setFolder(storageReminder.getFolder());
        reminder.setTargetId(storageReminder.getTargetId());
        reminder.setUser(storageReminder.getUser());
        reminderSql.remindAgain(reminder, this.session, this.session.getContext());
        this.timestamp = reminder.getLastModified();
        ReminderWriter reminderWriter = new ReminderWriter(timeZone);
        JSONObject jsonReminderObj = new JSONObject();
        reminderWriter.writeObject(reminder, jsonReminderObj);
        return jsonReminderObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JSONArray actionRange(JSONObject jsonObject) throws JSONException, OXException {
        Date end = DataParser.checkDate(jsonObject, "end");
        TimeZone tz = TimeZoneUtils.getTimeZone(this.userObj.getTimeZone());
        String timeZoneId = DataParser.parseString(jsonObject, "timezone");
        TimeZone timeZone = null == timeZoneId ? tz : TimeZoneUtils.getTimeZone(timeZoneId);
        ReminderWriter reminderWriter = new ReminderWriter(timeZone);
        ReminderHandler reminderSql = new ReminderHandler(this.session.getContext());
        JSONArray jsonResponseArray = new JSONArray();
        SearchIterator<ReminderObject> it = reminderSql.getArisingReminder(this.session, this.session.getContext(), this.userObj, end);
        try {
            while (it.hasNext()) {
                ReminderObject reminder = (ReminderObject)it.next();
                if (reminder.isRecurrenceAppointment()) {
                    try {
                        if (!this.getLatestRecurringReminder(this.session, tz, end, reminder)) {
                            ReminderObject nextReminder = ReminderRequest.getNextRecurringReminder(this.session, tz, reminder);
                            if (nextReminder != null) {
                                reminderSql.updateReminder(nextReminder);
                                continue;
                            }
                            reminderSql.deleteReminder(reminder);
                            continue;
                        }
                    }
                    catch (OXException e) {
                        if (e.isGeneric(OXException.Generic.NOT_FOUND)) {
                            LOG.warn((Object)"Cannot load target object of this reminder.", (Throwable)e);
                            reminderSql.deleteReminder(reminder.getTargetId(), this.userObj.getId(), reminder.getModule());
                        }
                        LOG.error((Object)("Can not calculate recurrence of appointment " + reminder.getTargetId() + ':' + this.session.getContextId()), (Throwable)e);
                    }
                }
                if (!this.hasModulePermission(reminder)) continue;
                JSONObject jsonReminderObj = new JSONObject();
                reminderWriter.writeObject(reminder, jsonReminderObj);
                jsonResponseArray.put((Object)jsonReminderObj);
            }
            return jsonResponseArray;
        }
        finally {
            it.close();
        }
    }

    protected boolean hasModulePermission(ReminderObject reminderObj) {
        switch (reminderObj.getModule()) {
            case 1: {
                return this.session.getUserConfiguration().hasCalendar();
            }
            case 4: {
                return this.session.getUserConfiguration().hasTask();
            }
        }
        return true;
    }

    protected boolean getLatestRecurringReminder(Session sessionObj, TimeZone tz, Date endRange, ReminderObject reminder) throws OXException {
        CalendarDataObject calendarDataObject;
        AppointmentSQLInterface calendarSql = this.appointmentFactory.createAppointmentSql(sessionObj);
        CalendarCollectionService recColl = ServerServiceRegistry.getInstance().getService(CalendarCollectionService.class);
        try {
            calendarDataObject = calendarSql.getObjectById(reminder.getTargetId(), reminder.getFolder());
        }
        catch (SQLException e) {
            throw OXCalendarExceptionCodes.CALENDAR_SQL_ERROR.create(e, new Object[0]);
        }
        Calendar calendar2 = Calendar.getInstance(tz);
        calendar2.add(2, -3);
        RecurringResultsInterface recurringResults = recColl.calculateRecurring(calendarDataObject, calendar2.getTimeInMillis(), endRange.getTime(), 0);
        boolean retval = false;
        if (recurringResults != null && recurringResults.size() > 0) {
            RecurringResultInterface recurringResult = recurringResults.getRecurringResult(recurringResults.size() - 1);
            calendar2.setTimeInMillis(recurringResult.getStart());
            calendar2.add(12, -calendarDataObject.getAlarm());
            if (calendar2.getTimeInMillis() >= reminder.getDate().getTime()) {
                reminder.setDate(calendar2.getTime());
                reminder.setRecurrencePosition(recurringResult.getPosition());
                retval = true;
            }
        } else if (calendarDataObject.getRecurrenceID() != calendarDataObject.getObjectID()) {
            retval = true;
        }
        return retval;
    }

    private static final ReminderObject getNextRecurringReminder(Session sessionObj, TimeZone tz, ReminderObject reminder) throws OXException {
        RecurringResultsInterface recurringResults;
        CalendarDataObject calendarDataObject;
        AppointmentSQLInterface calendarSql = ServerServiceRegistry.getInstance().getService(AppointmentSqlFactoryService.class).createAppointmentSql(sessionObj);
        CalendarCollectionService recColl = ServerServiceRegistry.getInstance().getService(CalendarCollectionService.class);
        try {
            calendarDataObject = calendarSql.getObjectById(reminder.getTargetId(), reminder.getFolder());
        }
        catch (SQLException e) {
            throw OXCalendarExceptionCodes.CALENDAR_SQL_ERROR.create(e, new Object[0]);
        }
        try {
            long end_mod = calendarDataObject.getEndDate().getTime() % 86400000L;
            Date until = null;
            until = new Date(((CalendarObject)calendarDataObject).getUntil().getTime() + end_mod + (long)tz.getOffset(((CalendarObject)calendarDataObject).getUntil().getTime()));
            recurringResults = recColl.calculateRecurring(calendarDataObject, reminder.getDate().getTime(), until.getTime(), 0);
        }
        catch (OXException e) {
            LOG.error((Object)("Can't calculate next recurrence for appointment " + reminder.getTargetId() + " in context " + sessionObj.getContextId()), (Throwable)e);
            return null;
        }
        if (null == recurringResults || recurringResults.size() == 0) {
            return null;
        }
        ReminderObject nextReminder = null;
        Date now = new Date();
        for (int i = 0; i < recurringResults.size(); ++i) {
            RecurringResultInterface recurringResult = recurringResults.getRecurringResult(i);
            Calendar calendar2 = Calendar.getInstance(tz);
            calendar2.setTimeInMillis(recurringResult.getStart());
            calendar2.add(12, -calendarDataObject.getAlarm());
            if (!calendar2.getTime().after(reminder.getDate()) || !calendar2.getTime().after(now)) continue;
            nextReminder = reminder.clone();
            nextReminder.setRecurrenceAppointment(true);
            nextReminder.setRecurrencePosition(recurringResult.getPosition());
            nextReminder.setDate(calendar2.getTime());
            break;
        }
        return nextReminder;
    }
}

