/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.container;

import com.openexchange.ajax.container.IFileHolder;
import com.openexchange.configuration.ServerConfig;
import com.openexchange.exception.OXException;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class TmpFileFileHolder
implements IFileHolder {
    private final File tmpFile = TmpFileFileHolder.newTempFile();
    private long length = -1L;
    private String contentType;
    private String name;
    private String disposition;
    private String delivery;

    @Override
    public void close() throws IOException {
        if (null == this.tmpFile) {
            return;
        }
        this.tmpFile.delete();
    }

    public File getTmpFile() {
        return this.tmpFile;
    }

    @Override
    public InputStream getStream() throws OXException {
        try {
            return new FileInputStream(this.tmpFile);
        }
        catch (IOException e) {
            throw AjaxExceptionCodes.IO_ERROR.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            throw AjaxExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDisposition() {
        return this.disposition;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDisposition(String disposition) {
        this.disposition = disposition;
    }

    public static File newTempFile() throws OXException {
        try {
            File tmpFile = File.createTempFile("open-xchange-", ".tmp", new File(ServerConfig.getProperty(ServerConfig.Property.UploadDirectory)));
            tmpFile.deleteOnExit();
            return tmpFile;
        }
        catch (IOException e) {
            throw AjaxExceptionCodes.IO_ERROR.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            throw AjaxExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }

    public void setDelivery(String delivery) {
        this.delivery = delivery;
    }

    @Override
    public String getDelivery() {
        return this.delivery;
    }
}

