/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.messaging;

import com.openexchange.exception.OXException;
import com.openexchange.messaging.ByteArrayContent;
import com.openexchange.messaging.ContentType;
import com.openexchange.messaging.MessagingBodyPart;
import com.openexchange.messaging.MessagingContent;
import com.openexchange.messaging.MessagingHeader;
import com.openexchange.messaging.MessagingMessage;
import com.openexchange.messaging.MessagingPartArrayContent;
import com.openexchange.messaging.MultipartContent;
import com.openexchange.messaging.ReferenceContent;
import com.openexchange.messaging.StringContent;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class SimpleMessagingMessage
implements MessagingMessage,
MessagingBodyPart {
    private int colorLabel;
    private int flags;
    private String folder;
    private long receivedDate;
    private Collection<String> userFlags;
    private String disposition;
    private String fileName;
    private Map<String, Collection<MessagingHeader>> headers = new HashMap<String, Collection<MessagingHeader>>();
    private String sectionId;
    private MessagingContent content;
    private long size;
    private int threadLevel;
    private MultipartContent parent;
    private ContentType contentType;
    private String id;
    private String picture;
    private String url;

    @Override
    public int getColorLabel() {
        return this.colorLabel;
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    @Override
    public String getFolder() {
        return this.folder;
    }

    @Override
    public long getReceivedDate() {
        return this.receivedDate;
    }

    @Override
    public Collection<String> getUserFlags() {
        return this.userFlags;
    }

    @Override
    public MessagingContent getContent() throws OXException {
        return this.content;
    }

    @Override
    public String getDisposition() throws OXException {
        return this.disposition;
    }

    @Override
    public String getFileName() throws OXException {
        return this.fileName;
    }

    @Override
    public MessagingHeader getFirstHeader(String name) throws OXException {
        Collection<MessagingHeader> collection = this.headers.get(name);
        return null == collection ? null : (collection.isEmpty() ? null : collection.iterator().next());
    }

    @Override
    public Collection<MessagingHeader> getHeader(String name) {
        return this.headers.get(name);
    }

    @Override
    public Map<String, Collection<MessagingHeader>> getHeaders() {
        return this.headers;
    }

    @Override
    public String getSectionId() {
        return this.sectionId;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public int getThreadLevel() {
        return this.threadLevel;
    }

    @Override
    public void writeTo(OutputStream os) throws IOException, OXException {
        throw new UnsupportedOperationException();
    }

    public void setColorLabel(int colorLabel) {
        this.colorLabel = colorLabel;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public void setFolder(String folder) {
        this.folder = folder;
    }

    public void setReceivedDate(long receivedDate) {
        this.receivedDate = receivedDate;
    }

    public void setUserFlags(Collection<String> userFlags) {
        this.userFlags = userFlags;
    }

    public void setDisposition(String disposition) {
        this.disposition = disposition;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setHeaders(Map<String, Collection<MessagingHeader>> headers) {
        this.headers = headers;
    }

    public void putHeader(MessagingHeader header) {
        if (this.headers.containsKey(header.getName())) {
            this.headers.get(header.getName()).add(header);
        } else {
            this.headers.put(header.getName(), new ArrayList<MessagingHeader>(Arrays.asList(header)));
        }
    }

    public void setSectionId(String sectionId) {
        this.sectionId = sectionId;
    }

    public void setContent(String content) {
        this.content = new StringContent(content);
    }

    public void setSize(long size) {
        this.size = size;
    }

    public void setThreadLevel(int threadLevel) {
        this.threadLevel = threadLevel;
    }

    public void setContent(byte[] bytes) {
        this.content = new ByteArrayContent(bytes);
    }

    public void setContent(MessagingBodyPart ... parts) {
        this.content = new MessagingPartArrayContent(parts);
    }

    @Override
    public MultipartContent getParent() throws OXException {
        return this.parent;
    }

    public void setParent(MultipartContent parent) {
        this.parent = parent;
    }

    @Override
    public ContentType getContentType() throws OXException {
        return this.contentType;
    }

    public void setContentType(ContentType contentType) {
        this.contentType = contentType;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getPicture() {
        return this.picture;
    }

    public void setPicture(String picture) {
        this.picture = picture;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public String getUrl() throws OXException {
        return this.url;
    }

    public void setContentReference(String string) {
        this.content = new ReferenceContent(string);
    }
}

