/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.messaging;

import com.openexchange.exception.OXException;
import com.openexchange.messaging.MessagingHeader;
import com.openexchange.messaging.MessagingMessageSwitcher;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;

public final class MessagingField
extends Enum<MessagingField> {
    public static final /* enum */ MessagingField ID;
    public static final /* enum */ MessagingField FOLDER_ID;
    public static final /* enum */ MessagingField CONTENT_TYPE;
    public static final /* enum */ MessagingField FROM;
    public static final /* enum */ MessagingField TO;
    public static final /* enum */ MessagingField CC;
    public static final /* enum */ MessagingField BCC;
    public static final /* enum */ MessagingField SUBJECT;
    public static final /* enum */ MessagingField SIZE;
    public static final /* enum */ MessagingField SENT_DATE;
    public static final /* enum */ MessagingField RECEIVED_DATE;
    public static final /* enum */ MessagingField FLAGS;
    public static final /* enum */ MessagingField THREAD_LEVEL;
    public static final /* enum */ MessagingField DISPOSITION_NOTIFICATION_TO;
    public static final /* enum */ MessagingField PRIORITY;
    public static final /* enum */ MessagingField COLOR_LABEL;
    public static final /* enum */ MessagingField ACCOUNT_NAME;
    public static final /* enum */ MessagingField PICTURE;
    public static final /* enum */ MessagingField BODY;
    public static final /* enum */ MessagingField HEADERS;
    public static final /* enum */ MessagingField FULL;
    public static final /* enum */ MessagingField URL;
    private final String name;
    public static final MessagingField[] FIELDS_LOW_COST;
    public static final MessagingField[] FIELDS_WO_BODY;
    private static final Map<String, MessagingField> FIELDS_MAP;
    private static final MessagingField[] EMPTY_FIELDS;
    private static final Map<MessagingField, MessagingHeader.KnownHeader> equivalentHeaders;
    private static final /* synthetic */ MessagingField[] $VALUES;

    public static MessagingField[] values() {
        return (MessagingField[])$VALUES.clone();
    }

    public static MessagingField valueOf(String name) {
        return Enum.valueOf(MessagingField.class, name);
    }

    private MessagingField(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public static final MessagingField[] getFields(String[] names) {
        if (names == null || names.length == 0) {
            return EMPTY_FIELDS;
        }
        MessagingField[] retval = new MessagingField[names.length];
        for (int i = 0; i < names.length; ++i) {
            retval[i] = MessagingField.getField(names[i]);
        }
        return retval;
    }

    public static MessagingField getField(String name) {
        return FIELDS_MAP.get(name);
    }

    public Object doSwitch(MessagingMessageSwitcher switcher, Object ... args) throws OXException {
        switch (this) {
            case ID: {
                return switcher.id(args);
            }
            case FOLDER_ID: {
                return switcher.folderId(args);
            }
            case CONTENT_TYPE: {
                return switcher.contentType(args);
            }
            case FROM: {
                return switcher.from(args);
            }
            case TO: {
                return switcher.to(args);
            }
            case CC: {
                return switcher.cc(args);
            }
            case BCC: {
                return switcher.bcc(args);
            }
            case SUBJECT: {
                return switcher.subject(args);
            }
            case SIZE: {
                return switcher.size(args);
            }
            case SENT_DATE: {
                return switcher.sentDate(args);
            }
            case RECEIVED_DATE: {
                return switcher.receivedDate(args);
            }
            case FLAGS: {
                return switcher.flags(args);
            }
            case THREAD_LEVEL: {
                return switcher.threadLevel(args);
            }
            case DISPOSITION_NOTIFICATION_TO: {
                return switcher.dispositionNotificationTo(args);
            }
            case PRIORITY: {
                return switcher.priority(args);
            }
            case COLOR_LABEL: {
                return switcher.colorLabel(args);
            }
            case ACCOUNT_NAME: {
                return switcher.accountName(args);
            }
            case PICTURE: {
                return switcher.picture(args);
            }
            case BODY: {
                return switcher.body(args);
            }
            case HEADERS: {
                return switcher.headers(args);
            }
            case FULL: {
                return switcher.full(args);
            }
            case URL: {
                return switcher.url(args);
            }
        }
        throw new IllegalArgumentException("Don't know how to handle " + (Object)((Object)this));
    }

    public MessagingHeader.KnownHeader getEquivalentHeader() {
        return equivalentHeaders.get((Object)this);
    }

    public static void initHeaders() {
        for (MessagingHeader.KnownHeader header : MessagingHeader.KnownHeader.values()) {
            if (null == header.getEquivalentField()) continue;
            equivalentHeaders.put(header.getEquivalentField(), header);
        }
    }

    static {
        MessagingField[] fields;
        ID = new MessagingField("id");
        FOLDER_ID = new MessagingField("folder");
        CONTENT_TYPE = new MessagingField("contentType");
        FROM = new MessagingField("from");
        TO = new MessagingField("to");
        CC = new MessagingField("cc");
        BCC = new MessagingField("bcc");
        SUBJECT = new MessagingField("subject");
        SIZE = new MessagingField("size");
        SENT_DATE = new MessagingField("sentDate");
        RECEIVED_DATE = new MessagingField("receivedDate");
        FLAGS = new MessagingField("flags");
        THREAD_LEVEL = new MessagingField("threadLevel");
        DISPOSITION_NOTIFICATION_TO = new MessagingField("dispositionNotificationTo");
        PRIORITY = new MessagingField("priority");
        COLOR_LABEL = new MessagingField("colorLabel");
        ACCOUNT_NAME = new MessagingField("accountName");
        PICTURE = new MessagingField("picture");
        BODY = new MessagingField("body");
        HEADERS = new MessagingField("headers");
        FULL = new MessagingField("full");
        URL = new MessagingField("url");
        $VALUES = new MessagingField[]{ID, FOLDER_ID, CONTENT_TYPE, FROM, TO, CC, BCC, SUBJECT, SIZE, SENT_DATE, RECEIVED_DATE, FLAGS, THREAD_LEVEL, DISPOSITION_NOTIFICATION_TO, PRIORITY, COLOR_LABEL, ACCOUNT_NAME, PICTURE, BODY, HEADERS, FULL, URL};
        FIELDS_LOW_COST = new MessagingField[]{ID, FOLDER_ID, CONTENT_TYPE, FROM, TO, CC, BCC, SUBJECT, SIZE, SENT_DATE, RECEIVED_DATE, FLAGS, THREAD_LEVEL, DISPOSITION_NOTIFICATION_TO, PRIORITY, COLOR_LABEL, PICTURE};
        FIELDS_WO_BODY = new MessagingField[]{ID, FOLDER_ID, CONTENT_TYPE, FROM, TO, CC, BCC, SUBJECT, SIZE, SENT_DATE, RECEIVED_DATE, FLAGS, THREAD_LEVEL, DISPOSITION_NOTIFICATION_TO, PRIORITY, COLOR_LABEL, HEADERS};
        HashMap<String, MessagingField> m = new HashMap<String, MessagingField>(32);
        for (MessagingField field : fields = MessagingField.values()) {
            m.put(field.name, field);
        }
        FIELDS_MAP = Collections.unmodifiableMap(m);
        EMPTY_FIELDS = new MessagingField[0];
        equivalentHeaders = new EnumMap<MessagingField, MessagingHeader.KnownHeader>(MessagingField.class);
    }
}

