/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.messaging.generic;

import com.openexchange.exception.OXException;
import com.openexchange.messaging.ContentType;
import com.openexchange.messaging.MessagingMessage;
import com.openexchange.messaging.MessagingPart;
import com.openexchange.messaging.MultipartContent;
import com.openexchange.messaging.generic.MessageHandler;
import com.openexchange.messaging.generic.internet.MimeContentType;

public final class MessageParser {
    private static final InlineDetector LENIENT_DETECTOR = new InlineDetector(){

        @Override
        public boolean isInline(String disposition, String fileName) {
            return "inline".equalsIgnoreCase(disposition) || disposition == null && fileName == null;
        }
    };
    private static final InlineDetector STRICT_DETECTOR = new InlineDetector(){

        @Override
        public boolean isInline(String disposition, String fileName) {
            return ("inline".equalsIgnoreCase(disposition) || disposition == null) && fileName == null;
        }
    };
    private boolean stop;
    private InlineDetector inlineDetector = LENIENT_DETECTOR;
    private static final String PRIMARY_MULTI = "multipart/";
    private static final String PRIMARY_RFC822 = "message/rfc822";

    public MessageParser setInlineDetectorBehavior(boolean strict) {
        this.inlineDetector = strict ? STRICT_DETECTOR : LENIENT_DETECTOR;
        return this;
    }

    public MessageParser reset() {
        this.stop = false;
        return this;
    }

    public void parseMessage(MessagingMessage message, MessageHandler handler) throws OXException {
        if (null == message) {
            throw new IllegalArgumentException("Message is null.");
        }
        if (null == handler) {
            throw new IllegalArgumentException("Handler is null.");
        }
        this.parseEnvelope(message, handler);
        this.parsePart((MessagingPart)message, handler);
        handler.handleMessageEnd(message);
    }

    private void parsePart(MessagingPart part, MessageHandler handler) throws OXException {
        ContentType contentType;
        if (this.stop) {
            return;
        }
        String disposition = part.getDisposition();
        ContentType ct = part.getContentType();
        if (null == ct) {
            MimeContentType mct = new MimeContentType();
            mct.setPrimaryType("application");
            mct.setSubType("octet-stream");
            contentType = mct;
        } else {
            contentType = ct;
        }
        String lcct = MessageParser.toLowerCase(contentType.getBaseType());
        boolean isInline = this.inlineDetector.isInline(disposition, part.getFileName());
        if (MessageParser.isMultipart(lcct)) {
            if (!handler.handlePart(part, isInline)) {
                this.stop = true;
                return;
            }
            MultipartContent multipart = (MultipartContent)part.getContent();
            int count = multipart.getCount();
            if (!handler.handleMultipart(multipart)) {
                this.stop = true;
                return;
            }
            for (int i = 0; i < count; ++i) {
                this.parsePart((MessagingPart)multipart.get(i), handler);
            }
        } else if (MessageParser.isMessage(lcct)) {
            if (!handler.handlePart(part, isInline)) {
                this.stop = true;
                return;
            }
            if (isInline && !handler.handleNestedMessage((MessagingMessage)part.getContent())) {
                this.stop = true;
                return;
            }
        } else if (!handler.handlePart(part, isInline)) {
            this.stop = true;
            return;
        }
    }

    private void parseEnvelope(MessagingMessage message, MessageHandler handler) throws OXException {
        handler.handleHeaders(message.getHeaders());
        handler.handleColorLabel(message.getColorLabel());
        handler.handleReceivedDate(message.getReceivedDate());
        handler.handleSystemFlags(message.getFlags());
        handler.handleUserFlags(message.getUserFlags());
    }

    private static String toLowerCase(String str) {
        char[] buf = new char[str.length()];
        for (int i = 0; i < buf.length; ++i) {
            buf[i] = Character.toLowerCase(str.charAt(i));
        }
        return new String(buf);
    }

    private static boolean isMultipart(String contentType) {
        return contentType.startsWith(PRIMARY_MULTI, 0);
    }

    private static boolean isMessage(String contentType) {
        return contentType.startsWith(PRIMARY_RFC822, 0);
    }

    private static interface InlineDetector {
        public boolean isInline(String var1, String var2);
    }
}

