/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.messaging.generic;

import com.openexchange.messaging.MessagingAccount;
import com.openexchange.messaging.MessagingService;
import com.openexchange.messaging.ServiceAware;
import com.openexchange.messaging.generic.services.MessagingGenericServiceRegistry;
import com.openexchange.messaging.registry.MessagingServiceRegistry;
import java.util.Map;

public class DefaultMessagingAccount
implements MessagingAccount,
ServiceAware {
    private static final long serialVersionUID = -8295765793020470243L;
    private Map<String, Object> configuration;
    private String displayName;
    private int id;
    private String serviceId;
    private int[] staticRootPermissions;
    private transient MessagingService messagingService;

    public Map<String, Object> getConfiguration() {
        return this.configuration;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public int getId() {
        return this.id;
    }

    public MessagingService getMessagingService() {
        MessagingService messagingService = this.messagingService;
        if (null == messagingService && null != this.serviceId) {
            MessagingServiceRegistry registry = MessagingGenericServiceRegistry.getService(MessagingServiceRegistry.class);
            if (null == registry) {
                return null;
            }
            try {
                messagingService = registry.getMessagingService(this.serviceId, -1, -1);
            }
            catch (Exception e) {
                messagingService = null;
            }
            if (null != messagingService) {
                this.messagingService = messagingService;
            }
        }
        return messagingService;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public DefaultMessagingAccount setServiceId(String serviceId) {
        this.serviceId = serviceId;
        return this;
    }

    public void setConfiguration(Map<String, Object> configuration) {
        this.configuration = configuration;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setMessagingService(MessagingService messagingService) {
        this.messagingService = messagingService;
        this.serviceId = null == messagingService ? null : messagingService.getId();
    }
}

