/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.java;

import com.openexchange.java.UnsynchronizedByteArrayInputStream;
import com.openexchange.java.UnsynchronizedByteArrayOutputStream;
import com.openexchange.java.UnsynchronizedStringReader;
import com.openexchange.java.UnsynchronizedStringWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;

public class Streams {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] stream2bytes(InputStream is) throws IOException {
        if (null == is) {
            return new byte[0];
        }
        try {
            int read;
            ByteArrayOutputStream bos = Streams.newByteArrayOutputStream(4096);
            int buflen = 2048;
            byte[] buf = new byte[2048];
            while ((read = is.read(buf, 0, 2048)) > 0) {
                bos.write(buf, 0, read);
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        finally {
            Streams.close((Closeable)is);
        }
    }

    public static Reader newStringReader(String s) {
        return null == s ? null : new UnsynchronizedStringReader(s);
    }

    public static Writer newStringWriter() {
        return new UnsynchronizedStringWriter(32);
    }

    public static Writer newStringWriter(int initial) {
        return new UnsynchronizedStringWriter(initial);
    }

    public static ByteArrayOutputStream newByteArrayOutputStream() {
        return new UnsynchronizedByteArrayOutputStream(32);
    }

    public static ByteArrayOutputStream newByteArrayOutputStream(int capacity) {
        return new UnsynchronizedByteArrayOutputStream(capacity);
    }

    public static ByteArrayInputStream newByteArrayInputStream(InputStream inputStream) throws IOException {
        return new UnsynchronizedByteArrayInputStream(Streams.stream2bytes(inputStream));
    }

    public static ByteArrayInputStream newByteArrayInputStream(byte[] bytes) {
        return new UnsynchronizedByteArrayInputStream(bytes);
    }

    public static void close(Closeable toClose) {
        if (null != toClose) {
            try {
                toClose.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void close(Closeable ... closeables) {
        if (null != closeables) {
            for (Closeable toClose : closeables) {
                if (null == toClose) continue;
                try {
                    toClose.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    public static void flush(Flushable toFlush) {
        if (null != toFlush) {
            try {
                toFlush.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

